/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.sender;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.QueueSupplier;

public class SenderOptions<K, V> {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private Duration closeTimeout = Duration.ofMillis(Long.MAX_VALUE);
    private Scheduler scheduler = Schedulers.single();
    private int maxInFlight = QueueSupplier.SMALL_BUFFER_SIZE;

    public static <K, V> SenderOptions<K, V> create() {
        return new SenderOptions<K, V>();
    }

    public static <K, V> SenderOptions<K, V> create(Map<String, Object> configProperties) {
        SenderOptions<K, V> options = SenderOptions.create();
        options.properties.putAll(configProperties);
        return options;
    }

    public static <K, V> SenderOptions<K, V> create(Properties configProperties) {
        SenderOptions<K, V> options = SenderOptions.create();
        configProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> options.properties.put((String)name, value)));
        return options;
    }

    private SenderOptions() {
    }

    public Map<String, Object> producerProperties() {
        return this.properties;
    }

    public Object producerProperty(String name) {
        return this.properties.get(name);
    }

    public SenderOptions<K, V> producerProperty(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public SenderOptions<K, V> scheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public int maxInFlight() {
        return this.maxInFlight;
    }

    public SenderOptions<K, V> maxInFlight(int maxInFlight) {
        this.maxInFlight = maxInFlight;
        return this;
    }

    public Duration closeTimeout() {
        return this.closeTimeout;
    }

    public SenderOptions<K, V> closeTimeout(Duration timeout) {
        this.closeTimeout = timeout;
        return this;
    }

    public SenderOptions<K, V> toImmutable() {
        SenderOptions options = new SenderOptions<K, V>(){

            @Override
            public Map<String, Object> producerProperties() {
                return Collections.unmodifiableMap(((SenderOptions)this).properties);
            }

            @Override
            public SenderOptions<K, V> producerProperty(String name, Object value) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public SenderOptions<K, V> scheduler(Scheduler scheduler) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public SenderOptions<K, V> maxInFlight(int maxInFlight) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public SenderOptions<K, V> closeTimeout(Duration timeout) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }
        };
        options.properties.putAll(this.properties);
        options.closeTimeout = this.closeTimeout;
        options.scheduler = this.scheduler;
        options.maxInFlight = this.maxInFlight;
        return options;
    }
}

