/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq.samples;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.RabbitFlux;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.Sender;

public class SampleReceiver {
    private static final String QUEUE = "demo-queue";
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleReceiver.class);
    private final Receiver receiver = RabbitFlux.createReceiver();
    private final Sender sender = RabbitFlux.createSender();

    public Disposable consume(String queue, CountDownLatch latch) {
        return this.receiver.consumeAutoAck(queue).delaySubscription((Publisher)this.sender.declareQueue(QueueSpecification.queue((String)queue))).subscribe(m -> {
            LOGGER.info("Received message {}", (Object)new String(m.getBody()));
            latch.countDown();
        });
    }

    public void close() {
        this.sender.close();
        this.receiver.close();
    }

    public static void main(String[] args) throws Exception {
        int count = 20;
        CountDownLatch latch = new CountDownLatch(count);
        SampleReceiver receiver = new SampleReceiver();
        Disposable disposable = receiver.consume(QUEUE, latch);
        latch.await(10L, TimeUnit.SECONDS);
        disposable.dispose();
        receiver.close();
    }
}

