/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.jmx.BuildInfoCollector;
import io.prometheus.jmx.JmxCollector;
import java.io.File;
import java.net.InetSocketAddress;

public class WebServer {
    public static void main(String[] args) throws Exception {
        InetSocketAddress socket;
        String[] hostnamePort;
        if (args.length < 2) {
            System.err.println("Usage: WebServer <[hostname:]port> <yaml configuration file>");
            System.exit(1);
        }
        if ((hostnamePort = args[0].split(":")).length == 2) {
            int port = Integer.parseInt(hostnamePort[1]);
            socket = new InetSocketAddress(hostnamePort[0], port);
        } else {
            int port = Integer.parseInt(hostnamePort[0]);
            socket = new InetSocketAddress(port);
        }
        new BuildInfoCollector().register();
        new JmxCollector(new File(args[1])).register();
        new HTTPServer(socket, CollectorRegistry.defaultRegistry);
    }
}

