/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.jmx.BuildInfoCollector;
import io.prometheus.jmx.JmxCollector;
import java.io.File;
import java.net.InetSocketAddress;

public class WebServer {
    public static void main(String[] args) throws Exception {
        InetSocketAddress socket;
        int colonIndex;
        if (args.length < 2) {
            System.err.println("Usage: WebServer <[hostname:]port> <yaml configuration file>");
            System.exit(1);
        }
        if ((colonIndex = args[0].lastIndexOf(58)) < 0) {
            int port = Integer.parseInt(args[0]);
            socket = new InetSocketAddress(port);
        } else {
            int port = Integer.parseInt(args[0].substring(colonIndex + 1));
            String host = args[0].substring(0, colonIndex);
            socket = new InetSocketAddress(host, port);
        }
        new BuildInfoCollector().register();
        new JmxCollector(new File(args[1]), JmxCollector.Mode.STANDALONE).register();
        new HTTPServer(socket, CollectorRegistry.defaultRegistry);
    }
}

