/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.UUID;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.FieldStatAccumulator;
import org.apache.spark.sql.InterimExec2;
import org.apache.spark.sql.InterimExec2$;
import org.apache.spark.sql.InterimOutput;
import org.apache.spark.sql.InterimOutputHive;
import org.apache.spark.sql.InterimOutputHive$;
import org.apache.spark.sql.InterimStat;
import org.apache.spark.sql.InterimStore;
import org.apache.spark.sql.InterimStore$;
import org.apache.spark.sql.MetricsCollector$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.crosssupport.package;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.prophecy.FieldDetailedStat;
import org.apache.spark.sql.prophecy.FieldStat;
import org.apache.spark.sql.prophecy.FieldValueAndCount;
import org.apache.spark.sql.prophecy.ProphecyDetailedStatEvent;
import org.apache.spark.sql.prophecy.ProphecyInterimEvent;
import org.apache.spark.sql.prophecy.ProphecyInterimEvent$;
import org.apache.spark.sql.prophecy.Quantile;
import org.apache.spark.sql.prophecy.RDDInterimKey;
import org.apache.spark.sql.prophecy.package$;
import org.apache.spark.sql.prophecy.util.CommonUtils$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.CollectionAccumulator;
import org.apache.spark.util.LongAccumulator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class InterimExec2$class {
    public static final Seq children(InterimExec2 $this) {
        SparkPlan sparkPlan = $this.child();
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    public static int MIN_INTERIM_ROWS_PER_PARTITION(InterimExec2 $this) {
        return 10;
    }

    public static Seq output(InterimExec2 $this) {
        return $this.child().output();
    }

    public static Map metrics(InterimExec2 $this) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"numOutputRows"), (Object)SQLMetrics$.MODULE$.createMetric($this.org$apache$spark$sql$InterimExec2$$super$sparkContext(), "number of output rows"))}));
    }

    public static int numRowsInPartition(InterimExec2 $this, RDD childExecution) {
        int numPartitions = childExecution.getNumPartitions();
        return numPartitions == 0 ? 0 : 1 + $this.numRows() / numPartitions;
    }

    public static RDD appendInterimRDDAndSaveInterimState(InterimExec2 $this, RDD childExecution) {
        Option<InterimStore> option;
        block8: {
            RDDInterimKey key;
            RDD rdd;
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    int numSampleRows = $this.numRowsInPartition((RDD<InternalRow>)childExecution);
                    String jobId = (String)new Some((Object)$this.outputFunction().jobid()).filterNot((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String jobId) {
                            return jobId.isEmpty() || CommonUtils$.MODULE$.isBlank(jobId);
                        }
                    }).getOrElse((Function0)new Serializable($this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ InterimExec2 $outer;

                        public final String apply() {
                            return (String)this.$outer.sparkSessionHashCode().getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return UUID.randomUUID().toString();
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    InterimStore$.MODULE$.setSpark($this.sparkSession());
                    boolean basicStats = $this.detailedStats() || new StringOps(Predef$.MODULE$.augmentString($this.sparkSession().conf().get("prophecy.collect.basic.stats", "false"))).toBoolean();
                    int numPartitions = childExecution.getNumPartitions();
                    StructType rowAccSchema = InterimOutputHive$.MODULE$.sampleSchema();
                    StructType interimSchema = InterimOutputHive$.MODULE$.writeSampleSchema();
                    Seq schemaJson = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)((QueryPlan)$this).schema().json())}))}));
                    StructType schemaSchema = InterimExec2$.MODULE$.schemaSchema();
                    String uuid = UUID.randomUUID().toString();
                    String accKeyStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", "_", "_", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobId, uuid, $this.subgraph(), $this.component(), $this.port()}));
                    SparkSession sparkSession = $this.sparkSession();
                    FieldStatAccumulator[] statsAcc = (FieldStatAccumulator[])Predef$.MODULE$.refArrayOps((Object[])((QueryPlan)$this).schema().fields()).map((Function1)new Serializable($this, sparkSession){
                        public static final long serialVersionUID = 0L;
                        private final SparkSession eta$0$1$1;

                        public final FieldStatAccumulator apply(StructField field) {
                            return org.apache.spark.sql.crosssupport.package$.MODULE$.fieldAccumulator(this.eta$0$1$1, field);
                        }
                        {
                            this.eta$0$1$1 = eta$0$1$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FieldStatAccumulator.class)));
                    CollectionAccumulator rowAcc = $this.sparkSession().sparkContext().collectionAccumulator(accKeyStr);
                    LongAccumulator counterAcc = $this.sparkSession().sparkContext().longAccumulator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{accKeyStr})));
                    LongAccumulator partitionCountAcc = $this.sparkSession().sparkContext().longAccumulator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition_count_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{accKeyStr})));
                    InterimExec2$.MODULE$.org$apache$spark$sql$InterimExec2$$LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering accumulator with name: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{counterAcc.name()})));
                    InterimStat state = new InterimStat(((QueryPlan)$this).schema(), basicStats, statsAcc, (CollectionAccumulator<InterimOutputHive.InterimRow>)rowAcc, counterAcc, partitionCountAcc, rowAccSchema, interimSchema, numPartitions, $this.numRows(), (Seq<InternalRow>)schemaJson, schemaSchema);
                    String string2 = $this.subgraph();
                    String string3 = $this.component();
                    String string4 = $this.port();
                    InterimOutput interimOutput = $this.outputFunction();
                    rdd = childExecution.mapPartitions((Function1)new Serializable($this, numSampleRows, basicStats, statsAcc, rowAcc, counterAcc, partitionCountAcc, string2, string3, string4, interimOutput){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ InterimExec2 $outer;
                        private final int numSampleRows$1;
                        private final boolean basicStats$1;
                        private final FieldStatAccumulator[] statsAcc$1;
                        private final CollectionAccumulator rowAcc$1;
                        private final LongAccumulator counterAcc$1;
                        private final LongAccumulator partitionCountAcc$1;
                        private final String eta$0$2$1;
                        private final String eta$1$1$1;
                        private final String eta$2$1$1;
                        private final InterimOutput eta$3$1$1;

                        public final Iterator<InternalRow> apply(Iterator<InternalRow> rows) {
                            return this.eta$3$1$1.getInterimRows(((QueryPlan)this.$outer).schema(), this.numSampleRows$1, this.basicStats$1, this.statsAcc$1, (CollectionAccumulator<InterimOutputHive.InterimRow>)this.rowAcc$1, this.counterAcc$1, this.partitionCountAcc$1, this.eta$0$2$1, this.eta$1$1$1, this.eta$2$1$1, rows);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.numSampleRows$1 = numSampleRows$1;
                            this.basicStats$1 = basicStats$1;
                            this.statsAcc$1 = statsAcc$1;
                            this.rowAcc$1 = rowAcc$1;
                            this.counterAcc$1 = counterAcc$1;
                            this.partitionCountAcc$1 = partitionCountAcc$1;
                            this.eta$0$2$1 = eta$0$2$1;
                            this.eta$1$1$1 = eta$1$1$1;
                            this.eta$2$1$1 = eta$2$1$1;
                            this.eta$3$1$1 = eta$3$1$1;
                        }
                    }, childExecution.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class)).setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"interim|", "|", "|", "|", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.subgraph(), $this.component(), $this.port(), jobId})));
                    key = new RDDInterimKey($this.subgraph(), $this.component(), $this.port(), rdd.id());
                    option = InterimStore$.MODULE$.getInterimStore($this.sparkSession());
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    InterimStore interimStore = (InterimStore)some.x();
                    InterimExec2$.MODULE$.org$apache$spark$sql$InterimExec2$$LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found interimStore for sparkSession ", " interimStore ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.sparkSession(), interimStore})));
                    interimStore.update(key, state);
                    if (rdd.getNumPartitions() == 0) {
                        interimStore.execute(key, (Function1<InterimStat, BoxedUnit>)new Serializable($this, jobId, rdd, key){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ InterimExec2 $outer;
                            private final String jobId$1;
                            private final RDD rdd$1;
                            private final RDDInterimKey key$1;

                            public final void apply(InterimStat stat) {
                                InterimExec2$.MODULE$.org$apache$spark$sql$InterimExec2$$LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating Event for Empty RDD:  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rdd$1.name()})));
                                ProphecyInterimEvent event = new ProphecyInterimEvent(this.key$1.getProphecyInterimEventKey(), this.jobId$1, 0L, (List<String>)List$.MODULE$.empty(), package$.MODULE$.compress(((QueryPlan)this.$outer).schema().json()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Seq<FieldStat<?>>>)None$.MODULE$, ProphecyInterimEvent$.MODULE$.apply$default$8());
                                this.$outer.org$apache$spark$sql$InterimExec2$$super$sparkContext().listenerBus().post((SparkListenerEvent)event);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.jobId$1 = jobId$1;
                                this.rdd$1 = rdd$1;
                                this.key$1 = key$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    break block7;
                }
                if (!None$.MODULE$.equals(option)) break block8;
                InterimExec2$.MODULE$.org$apache$spark$sql$InterimExec2$$LOGGER().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"InterimStore is empty for sparkSession ", " within keys ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.sparkSession(), InterimStore$.MODULE$.keys()})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if ($this.detailedStats()) {
                ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(((QueryPlan)$this).schema());
                Seq x$3 = qual$1.resolveAndBind$default$1();
                Analyzer x$4 = qual$1.resolveAndBind$default$2();
                ExpressionEncoder rowEncoder = qual$1.resolveAndBind(x$3, x$4);
                package.ExpressionEncoderWithDeserializeSupport expressionEncoderWithDeserializeSupport = org.apache.spark.sql.crosssupport.package$.MODULE$.ExpressionEncoderWithDeserializeSupport((ExpressionEncoder<Row>)rowEncoder);
                Dataset df = $this.sparkSession().sqlContext().createDataFrame(rdd.map((Function1)new Serializable($this, expressionEncoderWithDeserializeSupport){
                    public static final long serialVersionUID = 0L;
                    private final package.ExpressionEncoderWithDeserializeSupport eta$0$3$1;

                    public final Row apply(InternalRow r) {
                        return this.eta$0$3$1.deserializeRow(r);
                    }
                    {
                        this.eta$0$3$1 = eta$0$3$1;
                    }
                }, ClassTag$.MODULE$.apply(Row.class)), ((QueryPlan)$this).schema());
                StructField[] numericCols = (StructField[])Predef$.MODULE$.refArrayOps((Object[])((QueryPlan)$this).schema().fields()).filter((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(StructField x0$1) {
                        StructField structField = x0$1;
                        boolean bl = structField != null && structField.dataType() instanceof NumericType;
                        return bl;
                    }
                });
                double[] probs = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.95, 0.99};
                Map allQuantiles = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.stat().approxQuantile((String[])Predef$.MODULE$.refArrayOps((Object[])numericCols).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(StructField x$2) {
                        return x$2.name();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), probs, 0.1)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])numericCols), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable($this, probs){
                    public static final long serialVersionUID = 0L;
                    private final double[] probs$1;

                    public final Tuple2<String, Seq<Quantile>> apply(Tuple2<double[], StructField> x0$2) {
                        Tuple2<double[], StructField> tuple2 = x0$2;
                        if (tuple2 != null) {
                            double[] quantiles = (double[])tuple2._1();
                            StructField field = (StructField)tuple2._2();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(this.probs$1).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(quantiles), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Quantile apply(Tuple2<Object, Object> x0$3) {
                                    Tuple2<Object, Object> tuple2 = x0$3;
                                    if (tuple2 != null) {
                                        double prob = tuple2._1$mcD$sp();
                                        double q = tuple2._2$mcD$sp();
                                        Quantile quantile = new Quantile((int)((double)100 * prob), q);
                                        return quantile;
                                    }
                                    throw new MatchError(tuple2);
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Quantile.class)))).toSeq());
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.probs$1 = probs$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
                FieldDetailedStat[] stats = (FieldDetailedStat[])Predef$.MODULE$.refArrayOps((Object[])((QueryPlan)$this).schema().fields()).map((Function1)new Serializable($this, df, allQuantiles){
                    public static final long serialVersionUID = 0L;
                    private final Dataset df$1;
                    private final Map allQuantiles$1;

                    public final FieldDetailedStat apply(StructField x0$4) {
                        StructField structField = x0$4;
                        if (structField != null) {
                            String name = structField.name();
                            DataType dataType = structField.dataType();
                            long distinct = ((Row)Predef$.MODULE$.refArrayOps((Object[])this.df$1.agg(functions$.MODULE$.approx_count_distinct(name), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).collect()).head()).getLong(0);
                            DataType dataType2 = dataType;
                            boolean bl = StringType$.MODULE$.equals(dataType2) ? true : (dataType2 instanceof CharType ? true : dataType2 instanceof VarcharType);
                            Object object = bl ? new Some((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.df$1.groupBy(name, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.desc("count")})).take(10)).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final FieldValueAndCount apply(Row row) {
                                    String str = row.getString(0);
                                    long count = row.getLong(1);
                                    return new FieldValueAndCount((Option<String>)Option$.MODULE$.apply((Object)str), count);
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FieldValueAndCount.class)))).toSeq()) : None$.MODULE$;
                            None$ topN = object;
                            FieldDetailedStat fieldDetailedStat = new FieldDetailedStat(name, distinct, (Option<Seq<Quantile>>)this.allQuantiles$1.get((Object)name), (Option<Seq<FieldValueAndCount>>)topN);
                            return fieldDetailedStat;
                        }
                        throw new MatchError((Object)structField);
                    }
                    {
                        this.df$1 = df$1;
                        this.allQuantiles$1 = allQuantiles$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FieldDetailedStat.class)));
                $this.org$apache$spark$sql$InterimExec2$$super$sparkContext().listenerBus().post((SparkListenerEvent)new ProphecyDetailedStatEvent(key.getProphecyInterimEventKey(), $this.outputFunction().jobid(), (Seq<FieldDetailedStat>)Predef$.MODULE$.wrapRefArray((Object[])stats)));
            }
            return rdd;
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    public static RDD doExecute(InterimExec2 $this) {
        void var3_3;
        RDD childExecution = $this.child().execute();
        RDDInterimKey key = new RDDInterimKey($this.subgraph(), $this.component(), $this.port(), childExecution.id());
        InterimExec2$.MODULE$.org$apache$spark$sql$InterimExec2$$LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invocation of doExecute for ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
        RDD<InternalRow> rdd = $this.appendInterimRDDAndSaveInterimState((RDD<InternalRow>)childExecution);
        return var3_3;
    }

    public static Seq outputOrdering(InterimExec2 $this) {
        return $this.child().outputOrdering();
    }

    public static Partitioning outputPartitioning(InterimExec2 $this) {
        return $this.child().outputPartitioning();
    }

    public static void $init$(InterimExec2 $this) {
        $this.org$apache$spark$sql$InterimExec2$_setter_$sparkSessionHashCode_$eq(MetricsCollector$.MODULE$.getUniqueSessionId($this.sparkSession()));
        $this.org$apache$spark$sql$InterimExec2$_setter_$n_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.subgraph(), $this.component(), $this.port()})));
    }
}

