/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.typesafe.scalalogging.LazyLogging;
import io.prophecy.libs.metadata.package$;
import java.util.UUID;
import org.apache.spark.annotation.Py4JWhitelist;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.InterimStore$;
import org.apache.spark.sql.InterimStrategy;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.event.RunType$Interactive$;
import org.apache.spark.sql.event.SparkExecutionMetricsCollector;
import org.apache.spark.sql.event.SparkExecutionMetricsCollector$ExecutionMetricsMetadata$;
import org.apache.spark.sql.event.Succeeded;
import org.apache.spark.sql.event.package;
import org.apache.spark.sql.event.package$PipelineStatus$SUCCEEDED$;
import org.apache.spark.sql.event.package$WorkflowProcessNodeInfo$;
import org.apache.spark.sql.executionmetrics.InMemoryStore;
import org.apache.spark.sql.executionmetrics.package;
import org.apache.spark.sql.prophecy.JobMetricsMetadata;
import org.apache.spark.sql.prophecy.ProphecyEventSendingListener;
import org.apache.spark.sql.prophecy.ProphecyEventSendingListener$;
import org.apache.spark.sql.prophecy.util.CommonUtils$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class MetricsCollector$
implements Serializable,
LazyLogging {
    public static final MetricsCollector$ MODULE$;
    private Logger org$apache$spark$sql$MetricsCollector$$LOGGER;
    private final TrieMap<SparkSession, String> sparkSessionToIdMap;
    private final TrieMap<String, ProphecyEventSendingListener> org$apache$spark$sql$MetricsCollector$$sessionIdToListener;
    private final TrieMap<String, SparkSession> org$apache$spark$sql$MetricsCollector$$sparkSessionIdToSparkSession;
    private final TrieMap<String, InMemoryStore> sessionDataStore;
    private final String groupIdKey;
    private final String sparkConfPipelineUriKey;
    private final String sparkConfFabricIdKey;
    private final String sparkConfServiceUrlKey;
    private final String sparkConfRunTypeKey;
    private final String sparkConfJobUriKey;
    private final String sparkConfUserIdKey;
    private final String sparkConfPipelineProcessesKey;
    private final String DeltaPathPrefix;
    private final String sparkConfPipelineUUIDKey;
    private final String sparkConfJobBranch;
    private final String sparkConfURL;
    private final String sparkConfTestEnabled;
    private final String sparkConfProjectID;
    private final transient com.typesafe.scalalogging.Logger logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new MetricsCollector$();
    }

    private Logger org$apache$spark$sql$MetricsCollector$$LOGGER$lzycompute() {
        MetricsCollector$ metricsCollector$ = this;
        synchronized (metricsCollector$) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$MetricsCollector$$LOGGER = LoggerFactory.getLogger(this.getClass());
                this.bitmap$0 = true;
            }
            return this.org$apache$spark$sql$MetricsCollector$$LOGGER;
        }
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        MetricsCollector$ metricsCollector$ = this;
        synchronized (metricsCollector$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public com.typesafe.scalalogging.Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public Logger org$apache$spark$sql$MetricsCollector$$LOGGER() {
        return this.bitmap$0 ? this.org$apache$spark$sql$MetricsCollector$$LOGGER : this.org$apache$spark$sql$MetricsCollector$$LOGGER$lzycompute();
    }

    private TrieMap<SparkSession, String> sparkSessionToIdMap() {
        return this.sparkSessionToIdMap;
    }

    public TrieMap<String, ProphecyEventSendingListener> org$apache$spark$sql$MetricsCollector$$sessionIdToListener() {
        return this.org$apache$spark$sql$MetricsCollector$$sessionIdToListener;
    }

    public TrieMap<String, SparkSession> org$apache$spark$sql$MetricsCollector$$sparkSessionIdToSparkSession() {
        return this.org$apache$spark$sql$MetricsCollector$$sparkSessionIdToSparkSession;
    }

    public TrieMap<String, InMemoryStore> sessionDataStore() {
        return this.sessionDataStore;
    }

    private String groupIdKey() {
        return this.groupIdKey;
    }

    public String sparkConfPipelineUriKey() {
        return this.sparkConfPipelineUriKey;
    }

    public String sparkConfFabricIdKey() {
        return this.sparkConfFabricIdKey;
    }

    public String sparkConfServiceUrlKey() {
        return this.sparkConfServiceUrlKey;
    }

    public String sparkConfRunTypeKey() {
        return this.sparkConfRunTypeKey;
    }

    public String sparkConfJobUriKey() {
        return this.sparkConfJobUriKey;
    }

    public String sparkConfUserIdKey() {
        return this.sparkConfUserIdKey;
    }

    public String sparkConfPipelineProcessesKey() {
        return this.sparkConfPipelineProcessesKey;
    }

    public String DeltaPathPrefix() {
        return this.DeltaPathPrefix;
    }

    public String sparkConfPipelineUUIDKey() {
        return this.sparkConfPipelineUUIDKey;
    }

    public String sparkConfJobBranch() {
        return this.sparkConfJobBranch;
    }

    public String sparkConfURL() {
        return this.sparkConfURL;
    }

    public String sparkConfTestEnabled() {
        return this.sparkConfTestEnabled;
    }

    public String sparkConfProjectID() {
        return this.sparkConfProjectID;
    }

    public String getSessionAppendedKey(String key, String session) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, session}));
    }

    public Option<String> getUniqueSessionId(SparkSession session) {
        return this.sparkSessionToIdMap().get((Object)session);
    }

    public String getSession(String sessionForInteractive) {
        return sessionForInteractive.isEmpty() ? UUID.randomUUID().toString() : sessionForInteractive;
    }

    public String getJobGroup(SparkSession spark) {
        return spark.sparkContext().getLocalProperty(this.groupIdKey());
    }

    public String getTaskIdFromGroup(SparkSession spark) {
        String jobGroup = this.getJobGroup(spark);
        String[] split2 = new StringOps(Predef$.MODULE$.augmentString(jobGroup)).split('_');
        Option jobAndRun = Predef$.MODULE$.refArrayOps((Object[])split2).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String str) {
                return str.contains("job") && str.contains("run");
            }
        });
        return (String)jobAndRun.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String str) {
                return new StringOps(Predef$.MODULE$.augmentString(str)).split('-')[3];
            }
        }).getOrElse((Function0)new Serializable(jobGroup){
            public static final long serialVersionUID = 0L;
            private final String jobGroup$1;

            public final String apply() {
                return this.jobGroup$1;
            }
            {
                this.jobGroup$1 = jobGroup$1;
            }
        });
    }

    @Py4JWhitelist
    public void initializeMetrics(SparkSession spark) {
        InterimStrategy interimStrategy = new InterimStrategy(spark);
        spark.experimental().extraStrategies_$eq((Seq)Nil$.MODULE$.$colon$colon((Object)interimStrategy));
        InterimStore$.MODULE$.reset(spark);
    }

    @Py4JWhitelist
    public void addSparkListener(SparkSession spark, String executionUrl, String session, boolean scheduled) {
        this.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().update((Object)session, (Object)new ProphecyEventSendingListener(executionUrl, session, scheduled));
        spark.sparkContext().addSparkListener((SparkListenerInterface)this.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().apply((Object)session));
    }

    @Py4JWhitelist
    public void start(SparkSession spark, String pipelineId, String sessionForInteractive) {
        String session = this.getSession(sessionForInteractive);
        String pipelineUri = CommonUtils$.MODULE$.isBlank(pipelineId) ? (String)spark.conf().getOption(this.sparkConfPipelineUriKey()).getOrElse((Function0)new Serializable(pipelineId){
            public static final long serialVersionUID = 0L;
            private final String pipelineId$1;

            public final String apply() {
                return this.pipelineId$1;
            }
            {
                this.pipelineId$1 = pipelineId$1;
            }
        }) : package$.MODULE$.addProjectIdToProphecyUri(pipelineId, (Option<String>)spark.conf().getOption(this.sparkConfProjectID()));
        this.org$apache$spark$sql$MetricsCollector$$LOGGER().info(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                   | MetricsCollector.start method with spark ", " pipelineId ", " and sessionForInteractive ", "\n                   |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{session, pipelineUri, sessionForInteractive})))).stripMargin());
        this.org$apache$spark$sql$MetricsCollector$$sparkSessionIdToSparkSession().put((Object)session, (Object)spark);
        this.sparkSessionToIdMap().put((Object)spark, (Object)session);
        Option<String> executionUrlOption = this.getSparkExecutionUrl(spark, session);
        executionUrlOption.foreach((Function1)new Serializable(spark, pipelineId, sessionForInteractive, session, pipelineUri){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            private final String pipelineId$1;
            private final String sessionForInteractive$1;
            private final String session$1;
            private final String pipelineUri$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void apply(String executionUrl) {
                MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Execution ServiceURL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executionUrl})));
                boolean isJob = this.sessionForInteractive$1.isEmpty();
                MetricsCollector$ metricsCollector$ = MetricsCollector$.MODULE$;
                synchronized (metricsCollector$) {
                    BoxedUnit boxedUnit;
                    if (MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().contains((Object)this.session$1)) {
                        MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$LOGGER().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EventSendingListener is inactive for session: ", ", isJob: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.session$1, BoxesRunTime.boxToBoolean((boolean)isJob)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating new EventSendingListener"})).s((Seq)Nil$.MODULE$)).toString());
                        MetricsCollector$.MODULE$.addSparkListener(this.spark$1, executionUrl, this.session$1, isJob);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating new EventSendingListener for session: ", ", isJob: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.session$1, BoxesRunTime.boxToBoolean((boolean)isJob)})));
                        MetricsCollector$.MODULE$.addSparkListener(this.spark$1, executionUrl, this.session$1, isJob);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                long timeStarted = System.currentTimeMillis();
                if (isJob) {
                    Option jobURI = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfJobUriKey());
                    Option fabricId = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfFabricIdKey());
                    Option userID = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfUserIdKey());
                    Option branch = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfJobBranch());
                    Option prophecyUrl = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfURL());
                    String taskRunId = MetricsCollector$.MODULE$.getTaskIdFromGroup(this.spark$1);
                    String uuid = UUID.randomUUID().toString();
                    Some x$9 = new Some((Object)uuid);
                    Option x$10 = jobURI;
                    Some x$11 = new Some((Object)this.pipelineUri$1);
                    Option x$12 = fabricId;
                    long x$13 = timeStarted;
                    Option x$14 = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfRunTypeKey()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$2) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
                        }
                    });
                    String x$15 = taskRunId;
                    Option x$16 = userID;
                    Option x$17 = branch;
                    Option x$18 = prophecyUrl;
                    JobMetricsMetadata jobMetricsMetadata = new JobMetricsMetadata((Option<String>)x$9, (Option<String>)x$10, (Option<String>)x$12, x$13, (Option<Object>)x$14, x$15, (Option<String>)x$11, (Option<String>)x$16, (Option<String>)x$17, (Option<String>)x$18);
                    MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JobsMetricsEvent ", " spark ", " with pipelineUri ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobMetricsMetadata, this.session$1, this.pipelineUri$1})));
                    MetricsCollector$.MODULE$.sessionDataStore().putIfAbsent((Object)uuid, (Object)new InMemoryStore(uuid, this.spark$1, (ExecutionContext)ProphecyEventSendingListener$.MODULE$.system().dispatcher()));
                    MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().get((Object)this.session$1).foreach((Function1)new Serializable(this, jobMetricsMetadata){
                        public static final long serialVersionUID = 0L;
                        private final JobMetricsMetadata jobMetricsMetadata$1;

                        public final void apply(ProphecyEventSendingListener x$3) {
                            x$3.beginJobMetricsCollection(this.jobMetricsMetadata$1);
                        }
                        {
                            this.jobMetricsMetadata$1 = jobMetricsMetadata$1;
                        }
                    });
                    return;
                }
                Option fabricId = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfFabricIdKey(), this.session$1));
                String pipelineURI = this.pipelineId$1;
                Option userID = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfUserIdKey(), this.session$1));
                Map pipelineProcesses = (Map)this.spark$1.conf().getOption(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfPipelineProcessesKey(), this.session$1)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, package.WorkflowProcessNodeInfo> apply(String x$4) {
                        return (Map)Json$.MODULE$.parse(x$4).as(Reads$.MODULE$.mapReads(package$WorkflowProcessNodeInfo$.MODULE$.processWorkflowNodeInfo()));
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, Nothing$> apply() {
                        return Predef$.MODULE$.Map().empty();
                    }
                });
                package.DatabricksJobGroupMatcher jobGroupMatcher = new package.DatabricksJobGroupMatcher("");
                String uuid = this.spark$1.conf().get(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfPipelineUUIDKey(), this.session$1));
                String taskRunId = MetricsCollector$.MODULE$.getTaskIdFromGroup(this.spark$1);
                SparkExecutionMetricsCollector.ExecutionMetricsMetadata executionMetricsMetadata = new SparkExecutionMetricsCollector.ExecutionMetricsMetadata((Option<String>)new Some((Object)uuid), "", pipelineURI, (String)fabricId.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }), timeStarted, RunType$Interactive$.MODULE$, taskRunId, taskRunId, (String)userID.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }), SparkExecutionMetricsCollector$ExecutionMetricsMetadata$.MODULE$.apply$default$10(), SparkExecutionMetricsCollector$ExecutionMetricsMetadata$.MODULE$.apply$default$11());
                SparkExecutionMetricsCollector.JobGroupStatusTrackRequest jobGroupStatusTrackRequest = new SparkExecutionMetricsCollector.JobGroupStatusTrackRequest(this.session$1, MetricsCollector$.MODULE$.getJobGroup(this.spark$1), jobGroupMatcher, (Option<SparkExecutionMetricsCollector.ExecutionMetricsMetadata>)new Some((Object)executionMetricsMetadata));
                MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Interactive metrics collection beginning with metadata ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executionMetricsMetadata})));
                MetricsCollector$.MODULE$.sessionDataStore().putIfAbsent((Object)uuid, (Object)new InMemoryStore(uuid, this.spark$1, (ExecutionContext)ProphecyEventSendingListener$.MODULE$.system().dispatcher()));
                ((InMemoryStore)MetricsCollector$.MODULE$.sessionDataStore().apply((Object)uuid)).updateRunUID(taskRunId, taskRunId);
                MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().get((Object)this.session$1).foreach((Function1)new Serializable(this, pipelineProcesses, jobGroupStatusTrackRequest){
                    public static final long serialVersionUID = 0L;
                    private final Map pipelineProcesses$1;
                    private final SparkExecutionMetricsCollector.JobGroupStatusTrackRequest jobGroupStatusTrackRequest$1;

                    public final void apply(ProphecyEventSendingListener x$5) {
                        x$5.beginInteractiveMetricsCollection(this.jobGroupStatusTrackRequest$1, (Map<String, package.WorkflowProcessNodeInfo>)this.pipelineProcesses$1);
                    }
                    {
                        this.pipelineProcesses$1 = pipelineProcesses$1;
                        this.jobGroupStatusTrackRequest$1 = jobGroupStatusTrackRequest$1;
                    }
                });
            }
            {
                this.spark$1 = spark$1;
                this.pipelineId$1 = pipelineId$1;
                this.sessionForInteractive$1 = sessionForInteractive$1;
                this.session$1 = session$1;
                this.pipelineUri$1 = pipelineUri$1;
            }
        });
    }

    public String start$default$3() {
        return "";
    }

    @Py4JWhitelist
    public void end(SparkSession spark) {
        this.sparkSessionToIdMap().get((Object)spark).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<ProphecyEventSendingListener> apply(String k) {
                return MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().get((Object)k);
            }
        }).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<InMemoryStore> apply(ProphecyEventSendingListener listener) {
                BoxedUnit boxedUnit;
                if (listener.scheduled()) {
                    listener.endJobMetricsCollection(package$PipelineStatus$SUCCEEDED$.MODULE$);
                } else {
                    Succeeded succeededResult = new Succeeded(listener.session(), "", package$PipelineStatus$SUCCEEDED$.MODULE$.entryName());
                    SparkExecutionMetricsCollector.JobGroupStatusTrackStopRequest stopRequest = new SparkExecutionMetricsCollector.JobGroupStatusTrackStopRequest(succeededResult);
                    listener.endInteractiveMetricsCollection(stopRequest);
                }
                String uuid = (String)listener.metricsCollector().recordUID().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                if (MetricsCollector$.MODULE$.logger().underlying().isInfoEnabled()) {
                    MetricsCollector$.MODULE$.logger().underlying().info("In memory state at the end of the run\n{}", new Object[]{MetricsCollector$.MODULE$.sessionDataStore().get((Object)uuid).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(InMemoryStore x$6) {
                            return x$6.toString();
                        }
                    })});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Option output = MetricsCollector$.MODULE$.sessionDataStore().get((Object)uuid).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<List<package.ComponentRuns>, List<String>> apply(InMemoryStore x$7) {
                        return x$7.offload();
                    }
                });
                return MetricsCollector$.MODULE$.sessionDataStore().remove((Object)uuid);
            }
        });
        this.sparkSessionToIdMap().remove((Object)spark).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<SparkSession> apply(String sessionId) {
                return MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$sparkSessionIdToSparkSession().remove((Object)sessionId);
            }
        });
        InterimStore$.MODULE$.reset(spark);
    }

    public void end() {
        if (this.sparkSessionToIdMap().nonEmpty()) {
            ((ProphecyEventSendingListener)((Object)((Tuple2)this.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().head())._2())).sendJobPipelineEndEvent(package$PipelineStatus$SUCCEEDED$.MODULE$);
            this.sparkSessionToIdMap().remove(((Tuple2)this.sparkSessionToIdMap().head())._1());
        }
    }

    private Option<String> getSparkExecutionUrl(SparkSession spark, String session) {
        return spark.conf().getOption(this.sparkConfServiceUrlKey()).map((Function1)new Serializable(session){
            public static final long serialVersionUID = 0L;
            private final String session$2;

            public final String apply(String x$8) {
                return new StringBuilder().append((Object)x$8).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.session$2}))).toString();
            }
            {
                this.session$2 = session$2;
            }
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MetricsCollector$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.sparkSessionToIdMap = new TrieMap();
        this.org$apache$spark$sql$MetricsCollector$$sessionIdToListener = new TrieMap();
        this.org$apache$spark$sql$MetricsCollector$$sparkSessionIdToSparkSession = new TrieMap();
        this.sessionDataStore = new TrieMap();
        this.groupIdKey = "spark.jobGroup.id";
        this.sparkConfPipelineUriKey = "prophecy.metadata.pipeline.uri";
        this.sparkConfFabricIdKey = "prophecy.metadata.fabric.id";
        this.sparkConfServiceUrlKey = "prophecy.execution.service.url";
        this.sparkConfRunTypeKey = "prophecy.metadata.is.interactive.run";
        this.sparkConfJobUriKey = "prophecy.metadata.job.uri";
        this.sparkConfUserIdKey = "prophecy.metadata.user.id";
        this.sparkConfPipelineProcessesKey = "prophecy.metadata.pipeline.processes";
        this.DeltaPathPrefix = "prophecy.delta.path.prefix";
        this.sparkConfPipelineUUIDKey = "prophecy.metadata.pipeline.uuid";
        this.sparkConfJobBranch = "prophecy.metadata.job.branch";
        this.sparkConfURL = "prophecy.metadata.url";
        this.sparkConfTestEnabled = "prophecy.execution.test.enabled";
        this.sparkConfProjectID = "prophecy.project.id";
    }
}

