/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.prophecy.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import io.prophecy.libs.core.interim.LInterimContent;
import io.prophecy.libs.core.interim.LInterimContent$;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageCompleted$;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted$;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskEnd$;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult$;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerTaskStart$;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.util.JsonProtocol$;
import org.apache.spark.util.Utils$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonAST$JNothing$;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsArray$;
import play.api.libs.json.JsBoolean;
import play.api.libs.json.JsBoolean$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class JsonUtils$ {
    public static final JsonUtils$ MODULE$;
    private final DefaultFormats$ format;
    private final String libsInterimContent;
    private final ObjectMapper mapper;

    static {
        new JsonUtils$();
    }

    private DefaultFormats$ format() {
        return this.format;
    }

    public String libsInterimContent() {
        return this.libsInterimContent;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public String sparkEventToJson(SparkListenerEvent event) {
        JsonAST.JValue jValue;
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerStageSubmitted) {
            SparkListenerStageSubmitted sparkListenerStageSubmitted = (SparkListenerStageSubmitted)sparkListenerEvent;
            jValue = this.stageSubmittedToJson(sparkListenerStageSubmitted);
        } else if (sparkListenerEvent instanceof SparkListenerStageCompleted) {
            SparkListenerStageCompleted sparkListenerStageCompleted = (SparkListenerStageCompleted)sparkListenerEvent;
            jValue = this.stageCompletedToJson(sparkListenerStageCompleted);
        } else if (sparkListenerEvent instanceof SparkListenerTaskStart) {
            SparkListenerTaskStart sparkListenerTaskStart = (SparkListenerTaskStart)sparkListenerEvent;
            jValue = this.taskStartToJson(sparkListenerTaskStart);
        } else if (sparkListenerEvent instanceof SparkListenerTaskGettingResult) {
            SparkListenerTaskGettingResult sparkListenerTaskGettingResult = (SparkListenerTaskGettingResult)sparkListenerEvent;
            jValue = this.taskGettingResultToJson(sparkListenerTaskGettingResult);
        } else if (sparkListenerEvent instanceof SparkListenerTaskEnd) {
            SparkListenerTaskEnd sparkListenerTaskEnd = (SparkListenerTaskEnd)sparkListenerEvent;
            jValue = this.taskEndToJson(sparkListenerTaskEnd);
        } else if (sparkListenerEvent instanceof LInterimContent) {
            LInterimContent lInterimContent = (LInterimContent)sparkListenerEvent;
            jValue = this.interimContentToJson(lInterimContent);
        } else {
            jValue = JsonProtocol$.MODULE$.sparkEventToJson(event);
        }
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(jValue, (Formats)this.format()));
    }

    public JsonAST.JValue stageCompletedToJson(SparkListenerStageCompleted stageCompleted) {
        JsonAST.JValue stageInfo = this.stageInfoToJson(stageCompleted.stageInfo());
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName((Object)SparkListenerStageCompleted$.MODULE$)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Info"), (Object)stageInfo), (Function1)Predef$.MODULE$.$conforms());
    }

    public JsonAST.JValue stageSubmittedToJson(SparkListenerStageSubmitted stageSubmitted) {
        JsonAST.JValue stageInfo = this.stageInfoToJson(stageSubmitted.stageInfo());
        JsonAST.JValue properties = JsonProtocol$.MODULE$.propertiesToJson(stageSubmitted.properties());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName((Object)SparkListenerStageSubmitted$.MODULE$)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Info"), (Object)stageInfo), (Function1)Predef$.MODULE$.$conforms())).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Properties"), (Object)properties));
    }

    public JsonAST.JValue stageInfoToJson(StageInfo stageInfo) {
        JsonAST.JArray rddInfo = org.json4s.package$.MODULE$.JArray().apply(((TraversableOnce)stageInfo.rddInfos().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(RDDInfo rddInfo) {
                return JsonProtocol$.MODULE$.rddInfoToJson(rddInfo);
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
        JsonAST.JArray parentIds = org.json4s.package$.MODULE$.JArray().apply(((TraversableOnce)stageInfo.parentIds().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JInt apply(int x$1) {
                return org.json4s.package$.MODULE$.JInt().apply(BigInt$.MODULE$.int2bigInt(x$1));
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
        JsonAST.JValue submissionTime = (JsonAST.JValue)stageInfo.submissionTime().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JInt apply(long x$2) {
                return org.json4s.package$.MODULE$.JInt().apply(BigInt$.MODULE$.long2bigInt(x$2));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST$JNothing$ apply() {
                return org.json4s.package$.MODULE$.JNothing();
            }
        });
        JsonAST.JValue completionTime = (JsonAST.JValue)stageInfo.completionTime().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JInt apply(long x$3) {
                return org.json4s.package$.MODULE$.JInt().apply(BigInt$.MODULE$.long2bigInt(x$3));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST$JNothing$ apply() {
                return org.json4s.package$.MODULE$.JNothing();
            }
        });
        JsonAST.JValue failureReason = (JsonAST.JValue)stageInfo.failureReason().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JString apply(String x$4) {
                return org.json4s.package$.MODULE$.JString().apply(x$4);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST$JNothing$ apply() {
                return org.json4s.package$.MODULE$.JNothing();
            }
        });
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)stageInfo.stageId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)stageInfo.attemptNumber())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Name"), (Object)stageInfo.name()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Number of Tasks"), (Object)BoxesRunTime.boxToInteger((int)stageInfo.numTasks())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"RDD Info"), (Object)rddInfo))).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Parent IDs"), (Object)parentIds))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Details"), (Object)stageInfo.details()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Submission Time"), (Object)submissionTime))).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Completion Time"), (Object)completionTime))).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Failure Reason"), (Object)failureReason));
    }

    public JsonAST.JValue taskStartToJson(SparkListenerTaskStart taskStart) {
        TaskInfo taskInfo = taskStart.taskInfo();
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName((Object)SparkListenerTaskStart$.MODULE$)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)taskStart.stageId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)taskStart.stageAttemptId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task Info"), (Object)this.taskInfoToJson(taskInfo)));
    }

    public JsonAST.JValue taskGettingResultToJson(SparkListenerTaskGettingResult taskGettingResult) {
        TaskInfo taskInfo = taskGettingResult.taskInfo();
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName((Object)SparkListenerTaskGettingResult$.MODULE$)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task Info"), (Object)this.taskInfoToJson(taskInfo)), (Function1)Predef$.MODULE$.$conforms());
    }

    public JsonAST.JValue taskEndToJson(SparkListenerTaskEnd taskEnd) {
        JsonAST.JValue taskEndReason = JsonProtocol$.MODULE$.taskEndReasonToJson(taskEnd.reason());
        TaskInfo taskInfo = taskEnd.taskInfo();
        TaskMetrics taskMetrics = taskEnd.taskMetrics();
        JsonAST$JNothing$ taskMetricsJson = taskMetrics == null ? org.json4s.package$.MODULE$.JNothing() : this.taskMetricsToJson(taskMetrics);
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName((Object)SparkListenerTaskEnd$.MODULE$)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)taskEnd.stageId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)taskEnd.stageAttemptId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task Type"), (Object)taskEnd.taskType()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task End Reason"), (Object)taskEndReason))).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task Info"), (Object)this.taskInfoToJson(taskInfo)))).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task Metrics"), (Object)taskMetricsJson));
    }

    public JsonAST.JValue taskInfoToJson(TaskInfo taskInfo) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task ID"), (Object)BoxesRunTime.boxToLong((long)taskInfo.taskId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Index"), (Object)BoxesRunTime.boxToInteger((int)taskInfo.index())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Attempt"), (Object)BoxesRunTime.boxToInteger((int)taskInfo.attemptNumber())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Launch Time"), (Object)BoxesRunTime.boxToLong((long)taskInfo.launchTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor ID"), (Object)taskInfo.executorId()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Host"), (Object)taskInfo.host()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Locality"), (Object)taskInfo.taskLocality().toString()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Speculative"), (Object)BoxesRunTime.boxToBoolean((boolean)taskInfo.speculative())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Getting Result Time"), (Object)BoxesRunTime.boxToLong((long)taskInfo.gettingResultTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Finish Time"), (Object)BoxesRunTime.boxToLong((long)taskInfo.finishTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Failed"), (Object)BoxesRunTime.boxToBoolean((boolean)taskInfo.failed())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Killed"), (Object)BoxesRunTime.boxToBoolean((boolean)taskInfo.killed())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }));
    }

    public JsonAST.JValue interimContentToJson(LInterimContent interim) {
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName((Object)LInterimContent$.MODULE$)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)LInterimContent$.MODULE$.sparkEventJsonField()), (Object)Json$.MODULE$.toJson((Object)interim, LInterimContent$.MODULE$.implicitInterimContentWrites())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(JsValue json) {
                return JsonUtils$.MODULE$.toJson4s(json);
            }
        });
    }

    public SparkListenerEvent sparkEventFromJson(String json) {
        SparkListenerEvent sparkListenerEvent;
        JsonAST.JValue parsed = JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2());
        try {
            String string2 = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(parsed).$bslash("Event")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
            String string3 = this.libsInterimContent();
            String string4 = string2;
            SparkListenerEvent sparkListenerEvent2 = !(string3 != null ? !string3.equals(string4) : string4 != null) ? (SparkListenerEvent)this.toPlayJson(org.json4s.package$.MODULE$.jvalue2monadic(parsed).$bslash(LInterimContent$.MODULE$.sparkEventJsonField())).as(LInterimContent$.MODULE$.implicitInterimContentWrites()) : JsonProtocol$.MODULE$.sparkEventFromJson(parsed);
            sparkListenerEvent = sparkListenerEvent2;
        }
        catch (Throwable throwable) {
            SparkListenerEvent sparkListenerEvent3;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            String eventTypeClass = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(parsed).$bslash("Event")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
            Class<SparkListenerEvent> claz = Class.forName(eventTypeClass).asSubclass(SparkListenerEvent.class);
            sparkListenerEvent = sparkListenerEvent3 = (SparkListenerEvent)this.mapper().readValue(json, claz);
        }
        return sparkListenerEvent;
    }

    public JsonAST.JValue taskMetricsToJson(TaskMetrics metrics) {
        return JsonProtocol$.MODULE$.taskMetricsToJson(metrics);
    }

    public JsonAST.JValue toJson4s(JsValue json) {
        JsValue jsValue;
        block8: {
            JsonAST.JNull$ jNull$;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            JsBoolean jsBoolean;
                            Option option;
                            block4: {
                                block2: {
                                    jsValue = json;
                                    if (!(jsValue instanceof JsString)) break block2;
                                    JsString jsString = (JsString)jsValue;
                                    String str = jsString.value();
                                    jNull$ = org.json4s.package$.MODULE$.JString().apply(str);
                                    break block3;
                                }
                                if (!JsNull$.MODULE$.equals(jsValue)) break block4;
                                jNull$ = org.json4s.package$.MODULE$.JNull();
                                break block3;
                            }
                            if (!(jsValue instanceof JsBoolean) || (option = JsBoolean$.MODULE$.unapply(jsBoolean = (JsBoolean)jsValue)).isEmpty()) break block5;
                            boolean value = BoxesRunTime.unboxToBoolean((Object)option.get());
                            jNull$ = org.json4s.package$.MODULE$.JBool().apply(value);
                            break block3;
                        }
                        if (!(jsValue instanceof JsNumber)) break block6;
                        JsNumber jsNumber = (JsNumber)jsValue;
                        BigDecimal value = jsNumber.value();
                        jNull$ = org.json4s.package$.MODULE$.JDecimal().apply(value);
                        break block3;
                    }
                    if (!(jsValue instanceof JsArray)) break block7;
                    JsArray jsArray = (JsArray)jsValue;
                    IndexedSeq items = jsArray.value();
                    jNull$ = org.json4s.package$.MODULE$.JArray().apply(((TraversableOnce)items.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final JsonAST.JValue apply(JsValue json) {
                            return JsonUtils$.MODULE$.toJson4s(json);
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom())).toList());
                    break block3;
                }
                if (!(jsValue instanceof JsObject)) break block8;
                JsObject jsObject = (JsObject)jsValue;
                Map items = jsObject.underlying$1();
                jNull$ = org.json4s.package$.MODULE$.JObject().apply(((TraversableOnce)items.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, JsonAST.JValue> apply(Tuple2<String, JsValue> x0$1) {
                        Tuple2<String, JsValue> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            JsValue v = (JsValue)tuple2._2();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)JsonUtils$.MODULE$.toJson4s(v));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom())).toList());
            }
            return jNull$;
        }
        throw new MatchError((Object)jsValue);
    }

    public JsValue toPlayJson(JsonAST.JValue json) {
        Object object;
        JsonAST.JValue jValue = json;
        if (jValue instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue;
            String str = jString.s();
            object = new JsString(str);
        } else {
            JsonAST$JNothing$ jsonAST$JNothing$ = org.json4s.package$.MODULE$.JNothing();
            JsonAST.JValue jValue2 = jValue;
            if (!(jsonAST$JNothing$ != null ? !jsonAST$JNothing$.equals(jValue2) : jValue2 != null)) {
                object = JsNull$.MODULE$;
            } else {
                JsonAST.JNull$ jNull$ = org.json4s.package$.MODULE$.JNull();
                JsonAST.JValue jValue3 = jValue;
                if (!(jNull$ != null ? !jNull$.equals(jValue3) : jValue3 != null)) {
                    object = JsNull$.MODULE$;
                } else if (jValue instanceof JsonAST.JDecimal) {
                    JsonAST.JDecimal jDecimal = (JsonAST.JDecimal)jValue;
                    BigDecimal value = jDecimal.num();
                    object = new JsNumber(value);
                } else if (jValue instanceof JsonAST.JDouble) {
                    JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
                    double value = jDouble.num();
                    object = new JsNumber(BigDecimal$.MODULE$.double2bigDecimal(value));
                } else if (jValue instanceof JsonAST.JInt) {
                    JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                    BigInt value = jInt.num();
                    object = new JsNumber(package$.MODULE$.BigDecimal().apply(value));
                } else if (jValue instanceof JsonAST.JBool) {
                    JsonAST.JBool jBool = (JsonAST.JBool)jValue;
                    boolean value = jBool.value();
                    object = JsBoolean$.MODULE$.apply(value);
                } else if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List fields = jArray.arr();
                    object = JsArray$.MODULE$.apply((Seq)fields.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final JsValue apply(JsonAST.JValue json) {
                            return JsonUtils$.MODULE$.toPlayJson(json);
                        }
                    }, List$.MODULE$.canBuildFrom()));
                } else if (jValue instanceof JsonAST.JObject) {
                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                    List fields = jObject.obj();
                    object = new JsObject((Map)((TraversableOnce)fields.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, JsValue> apply(Tuple2<String, JsonAST.JValue> x0$2) {
                            Tuple2<String, JsonAST.JValue> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String k = (String)tuple2._1();
                                JsonAST.JValue v = (JsonAST.JValue)tuple2._2();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)JsonUtils$.MODULE$.toPlayJson(v));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                } else {
                    object = jValue.values() instanceof Long ? new JsNumber(package$.MODULE$.BigDecimal().apply(BoxesRunTime.unboxToLong((Object)jValue.values()))) : JsArray$.MODULE$.apply((Seq)((Set)jValue.values()).toList().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final JsValue apply(JsonAST.JValue json) {
                            return JsonUtils$.MODULE$.toPlayJson(json);
                        }
                    }, List$.MODULE$.canBuildFrom()));
                }
            }
        }
        return object;
    }

    public JsValue objectToPlayJsonViaJackson(Object o) {
        return Json$.MODULE$.parse(this.mapper().writeValueAsString(o));
    }

    private JsonUtils$() {
        MODULE$ = this;
        this.format = DefaultFormats$.MODULE$;
        this.libsInterimContent = Utils$.MODULE$.getFormattedClassName((Object)LInterimContent$.MODULE$);
        this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

