/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler;

import io.protostuff.compiler.Formatter;
import org.junit.Assert;
import org.junit.Test;

public class FomatterTest {
    private void verify(Formatter f, String expect, String value) {
        Assert.assertEquals((Object)expect, (Object)f.format(value));
    }

    @Test
    public void testCC() {
        Formatter.BUILTIN f = Formatter.BUILTIN.CC;
        this.verify((Formatter)f, "someFoo", "some_foo");
        this.verify((Formatter)f, "someFoo", "SomeFoo");
        this.verify((Formatter)f, "someFoo", "someFoo");
    }

    @Test
    public void testCCU() {
        Formatter.BUILTIN f = Formatter.BUILTIN.CCU;
        this.verify((Formatter)f, "someFoo_", "some_foo");
        this.verify((Formatter)f, "someFoo_", "SomeFoo");
        this.verify((Formatter)f, "someFoo_", "someFoo");
    }

    @Test
    public void testUC() {
        Formatter.BUILTIN f = Formatter.BUILTIN.UC;
        this.verify((Formatter)f, "some_foo", "someFoo");
        this.verify((Formatter)f, "some_foo", "SomeFoo");
        this.verify((Formatter)f, "some_foo", "some_foo");
    }

    @Test
    public void testUCU() {
        Formatter.BUILTIN f = Formatter.BUILTIN.UCU;
        this.verify((Formatter)f, "some_foo_", "someFoo");
        this.verify((Formatter)f, "some_foo_", "SomeFoo");
        this.verify((Formatter)f, "some_foo_", "some_foo");
    }

    @Test
    public void testUUC() {
        Formatter.BUILTIN f = Formatter.BUILTIN.UUC;
        this.verify((Formatter)f, "SOME_FOO", "someFoo");
        this.verify((Formatter)f, "SOME_FOO", "SomeFoo");
        this.verify((Formatter)f, "SOME_FOO", "some_foo");
        this.verify((Formatter)f, "SOME_FOO", "SOME_FOO");
    }

    @Test
    public void testPC() {
        Formatter.BUILTIN f = Formatter.BUILTIN.PC;
        this.verify((Formatter)f, "SomeFoo", "someFoo");
        this.verify((Formatter)f, "SomeFoo", "some_foo");
        this.verify((Formatter)f, "SomeFoo", "SomeFoo");
    }

    @Test
    public void testPCS() {
        Formatter.BUILTIN f = Formatter.BUILTIN.PCS;
        this.verify((Formatter)f, "Some Foo", "someFoo");
        this.verify((Formatter)f, "Some Foo", "some_foo");
        this.verify((Formatter)f, "Some Foo", "SomeFoo");
        this.verify((Formatter)f, "Some Foo", "Some Foo");
    }

    @Test
    public void testPluralize() {
        Assert.assertEquals((Object)"octopi", (Object)Formatter.BUILTIN.PLURAL.format("octopus"));
        Assert.assertEquals((Object)"vertices", (Object)Formatter.BUILTIN.PLURAL.format("vertex"));
        Assert.assertEquals((Object)"oxen", (Object)Formatter.BUILTIN.PLURAL.format("ox"));
        Assert.assertEquals((Object)"books", (Object)Formatter.BUILTIN.PLURAL.format("book"));
        Assert.assertEquals((Object)"people", (Object)Formatter.BUILTIN.PLURAL.format("Person"));
        Assert.assertEquals((Object)"children", (Object)Formatter.BUILTIN.PLURAL.format("Child"));
        Assert.assertEquals((Object)"Addresses", (Object)Formatter.BUILTIN.PLURAL.format("Address"));
        Assert.assertEquals((Object)"money", (Object)Formatter.BUILTIN.PLURAL.format("money"));
        Assert.assertEquals((Object)"libraries", (Object)Formatter.BUILTIN.PLURAL.format("library"));
    }

    @Test
    public void testSingularize() {
        Assert.assertEquals((Object)"prognosis", (Object)Formatter.BUILTIN.SINGULAR.format("prognoses"));
        Assert.assertEquals((Object)"Analysis", (Object)Formatter.BUILTIN.SINGULAR.format("Analyses"));
        Assert.assertEquals((Object)"book", (Object)Formatter.BUILTIN.SINGULAR.format("books"));
        Assert.assertEquals((Object)"person", (Object)Formatter.BUILTIN.SINGULAR.format("people"));
        Assert.assertEquals((Object)"money", (Object)Formatter.BUILTIN.SINGULAR.format("money"));
        Assert.assertEquals((Object)"action", (Object)Formatter.BUILTIN.SINGULAR.format("actions"));
        Assert.assertEquals((Object)"availableBettingLimit", (Object)Formatter.BUILTIN.SINGULAR.format("availableBettingLimits"));
        Assert.assertEquals((Object)"availableExtendDuration", (Object)Formatter.BUILTIN.SINGULAR.format("availableExtendDurations"));
        Assert.assertEquals((Object)"betStat", (Object)Formatter.BUILTIN.SINGULAR.format("betStats"));
        Assert.assertEquals((Object)"bet", (Object)Formatter.BUILTIN.SINGULAR.format("bets"));
        Assert.assertEquals((Object)"brokenGame", (Object)Formatter.BUILTIN.SINGULAR.format("brokenGames"));
        Assert.assertEquals((Object)"capability", (Object)Formatter.BUILTIN.SINGULAR.format("capabilities"));
        Assert.assertEquals((Object)"card", (Object)Formatter.BUILTIN.SINGULAR.format("cards"));
        Assert.assertEquals((Object)"casinoClientProperty", (Object)Formatter.BUILTIN.SINGULAR.format("casinoClientProperties"));
        Assert.assertEquals((Object)"clientProperty", (Object)Formatter.BUILTIN.SINGULAR.format("clientProperties"));
        Assert.assertEquals((Object)"countRange", (Object)Formatter.BUILTIN.SINGULAR.format("countRanges"));
        Assert.assertEquals((Object)"deleted", (Object)Formatter.BUILTIN.SINGULAR.format("deleted"));
        Assert.assertEquals((Object)"delta", (Object)Formatter.BUILTIN.SINGULAR.format("delta"));
        Assert.assertEquals((Object)"gameType", (Object)Formatter.BUILTIN.SINGULAR.format("gameTypes"));
        Assert.assertEquals((Object)"history", (Object)Formatter.BUILTIN.SINGULAR.format("histories"));
        Assert.assertEquals((Object)"history", (Object)Formatter.BUILTIN.SINGULAR.format("history"));
        Assert.assertEquals((Object)"info", (Object)Formatter.BUILTIN.SINGULAR.format("infos"));
        Assert.assertEquals((Object)"limit", (Object)Formatter.BUILTIN.SINGULAR.format("limits"));
        Assert.assertEquals((Object)"maskUrl", (Object)Formatter.BUILTIN.SINGULAR.format("maskUrls"));
        Assert.assertEquals((Object)"metadata", (Object)Formatter.BUILTIN.SINGULAR.format("metadata"));
        Assert.assertEquals((Object)"offlineGame", (Object)Formatter.BUILTIN.SINGULAR.format("offlineGames"));
        Assert.assertEquals((Object)"playerInfo", (Object)Formatter.BUILTIN.SINGULAR.format("playerInfo"));
        Assert.assertEquals((Object)"playerInfo", (Object)Formatter.BUILTIN.SINGULAR.format("playerInfos"));
        Assert.assertEquals((Object)"position", (Object)Formatter.BUILTIN.SINGULAR.format("positions"));
        Assert.assertEquals((Object)"providerItem", (Object)Formatter.BUILTIN.SINGULAR.format("providerItems"));
        Assert.assertEquals((Object)"resolvedSideBet", (Object)Formatter.BUILTIN.SINGULAR.format("resolvedSideBets"));
        Assert.assertEquals((Object)"resultCount", (Object)Formatter.BUILTIN.SINGULAR.format("resultCounts"));
        Assert.assertEquals((Object)"result", (Object)Formatter.BUILTIN.SINGULAR.format("results"));
        Assert.assertEquals((Object)"serviceUrl", (Object)Formatter.BUILTIN.SINGULAR.format("serviceUrls"));
        Assert.assertEquals((Object)"setting", (Object)Formatter.BUILTIN.SINGULAR.format("settings"));
        Assert.assertEquals((Object)"statistic", (Object)Formatter.BUILTIN.SINGULAR.format("statistic"));
        Assert.assertEquals((Object)"stream", (Object)Formatter.BUILTIN.SINGULAR.format("streams"));
        Assert.assertEquals((Object)"suggestedBet", (Object)Formatter.BUILTIN.SINGULAR.format("suggestedBets"));
        Assert.assertEquals((Object)"supportedMessage", (Object)Formatter.BUILTIN.SINGULAR.format("supportedMessages"));
        Assert.assertEquals((Object)"tableHistory", (Object)Formatter.BUILTIN.SINGULAR.format("tableHistory"));
        Assert.assertEquals((Object)"tableStat", (Object)Formatter.BUILTIN.SINGULAR.format("tableStats"));
        Assert.assertEquals((Object)"table", (Object)Formatter.BUILTIN.SINGULAR.format("tables"));
        Assert.assertEquals((Object)"tag", (Object)Formatter.BUILTIN.SINGULAR.format("tags"));
        Assert.assertEquals((Object)"updated", (Object)Formatter.BUILTIN.SINGULAR.format("updated"));
        Assert.assertEquals((Object)"urlTypeList", (Object)Formatter.BUILTIN.SINGULAR.format("urlTypeList"));
        Assert.assertEquals((Object)"urlsList", (Object)Formatter.BUILTIN.SINGULAR.format("urlsList"));
        Assert.assertEquals((Object)"winnerListRange", (Object)Formatter.BUILTIN.SINGULAR.format("winnerListRanges"));
        Assert.assertEquals((Object)"winner", (Object)Formatter.BUILTIN.SINGULAR.format("winners"));
    }

    @Test
    public void testTrim() throws Exception {
        Formatter.BUILTIN f = Formatter.BUILTIN.TRIM;
        Assert.assertEquals((Object)"Some Foo", (Object)f.format("\n\n   Some Foo\n"));
    }

    @Test
    public void testCutL() throws Exception {
        Formatter.BUILTIN f = Formatter.BUILTIN.CUT_L;
        Assert.assertEquals((Object)"oo", (Object)f.format("foo"));
        Assert.assertEquals((Object)"", (Object)f.format(""));
    }

    @Test
    public void testCutR() throws Exception {
        Formatter.BUILTIN f = Formatter.BUILTIN.CUT_R;
        Assert.assertEquals((Object)"fo", (Object)f.format("foo"));
        Assert.assertEquals((Object)"", (Object)f.format(""));
    }
}

