/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.runtime.MappedSchema;

public interface Predicate {
    public boolean apply(MappedSchema.Field<?> var1);

    public boolean apply(MappedSchema.Field<?> var1, Object var2);

    public static enum Factories implements Factory
    {
        EQ{

            @Override
            public Predicate create(String[] args) {
                return new EQ(Integer.parseInt(args[0]));
            }
        }
        ,
        NOTEQ{

            @Override
            public Predicate create(String[] args) {
                return new NOTEQ(Integer.parseInt(args[0]));
            }
        }
        ,
        GT{

            @Override
            public Predicate create(String[] args) {
                return new GT(Integer.parseInt(args[0]));
            }
        }
        ,
        LT{

            @Override
            public Predicate create(String[] args) {
                return new LT(Integer.parseInt(args[0]));
            }
        }
        ,
        RANGE{

            @Override
            public Predicate create(String[] args) {
                return new RANGE(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
            }
        }
        ,
        NOTRANGE{

            @Override
            public Predicate create(String[] args) {
                return new NOTRANGE(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
            }
        };

    }

    public static final class NOTRANGE
    implements Predicate,
    Factory {
        final int min;
        final int max;

        NOTRANGE(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean apply(MappedSchema.Field<?> f) {
            return f.number < this.min || f.number > this.max;
        }

        @Override
        public boolean apply(MappedSchema.Field<?> f, Object message) {
            return f.number < this.min || f.number > this.max;
        }

        @Override
        public Predicate create(String[] args) {
            return this;
        }
    }

    public static final class RANGE
    implements Predicate,
    Factory {
        final int min;
        final int max;

        RANGE(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean apply(MappedSchema.Field<?> f) {
            return f.number >= this.min && f.number <= this.max;
        }

        @Override
        public boolean apply(MappedSchema.Field<?> f, Object message) {
            return f.number >= this.min && f.number <= this.max;
        }

        @Override
        public Predicate create(String[] args) {
            return this;
        }
    }

    public static final class LT
    implements Predicate,
    Factory {
        final int num;

        LT(int num) {
            this.num = num;
        }

        @Override
        public boolean apply(MappedSchema.Field<?> f) {
            return f.number < this.num;
        }

        @Override
        public boolean apply(MappedSchema.Field<?> f, Object message) {
            return f.number < this.num;
        }

        @Override
        public Predicate create(String[] args) {
            return this;
        }
    }

    public static final class GT
    implements Predicate,
    Factory {
        final int num;

        GT(int num) {
            this.num = num;
        }

        @Override
        public boolean apply(MappedSchema.Field<?> f) {
            return f.number > this.num;
        }

        @Override
        public boolean apply(MappedSchema.Field<?> f, Object message) {
            return f.number > this.num;
        }

        @Override
        public Predicate create(String[] args) {
            return this;
        }
    }

    public static final class NOTEQ
    implements Predicate,
    Factory {
        final int num;

        NOTEQ(int num) {
            this.num = num;
        }

        @Override
        public boolean apply(MappedSchema.Field<?> f) {
            return f.number != this.num;
        }

        @Override
        public boolean apply(MappedSchema.Field<?> f, Object message) {
            return f.number != this.num;
        }

        @Override
        public Predicate create(String[] args) {
            return this;
        }
    }

    public static final class EQ
    implements Predicate,
    Factory {
        final int num;

        EQ(int num) {
            this.num = num;
        }

        @Override
        public boolean apply(MappedSchema.Field<?> f) {
            return f.number == this.num;
        }

        @Override
        public boolean apply(MappedSchema.Field<?> f, Object message) {
            return f.number == this.num;
        }

        @Override
        public Predicate create(String[] args) {
            return this;
        }
    }

    public static interface Factory {
        public Predicate create(String[] var1);
    }
}

