/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.runtime.MappedSchema;
import io.protostuff.runtime.Predicate;
import io.protostuff.runtime.RuntimeEnv;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class RuntimeView {
    private RuntimeView() {
    }

    public static <T> Schema<T> createFrom(RuntimeSchema<T> rs, Factory vf, Predicate.Factory pf, String ... args) {
        return RuntimeView.createFrom(rs, rs.instantiator, vf, pf, args);
    }

    public static <T> Schema<T> createFrom(MappedSchema<T> ms, RuntimeEnv.Instantiator<T> instantiator, Factory vf, Predicate.Factory pf, String ... args) {
        return vf.create(ms.typeClass, ms.fields, ms.fieldsByNumber, ms.fieldsByName, instantiator, pf, args);
    }

    static <T> HashMap<String, MappedSchema.Field<T>> copyAndExclude(Class<T> typeClass, Map<String, MappedSchema.Field<T>> byName, Predicate predicate) {
        HashMap<String, MappedSchema.Field<T>> map = new HashMap<String, MappedSchema.Field<T>>(byName);
        for (MappedSchema.Field<T> f : byName.values()) {
            if (!predicate.apply(f)) continue;
            map.remove(f.name);
        }
        if (map.size() == 0) {
            throw new IllegalArgumentException("No fields are left.  Everything was excluded.");
        }
        return map;
    }

    static <T> HashMap<String, MappedSchema.Field<T>> copyAndExclude(Class<T> typeClass, Map<String, MappedSchema.Field<T>> byName, String[] args) {
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("You must provide at least 1 field to exclude.");
        }
        HashMap<String, MappedSchema.Field<T>> map = new HashMap<String, MappedSchema.Field<T>>(byName);
        for (String name : args) {
            if (null != map.remove(name)) continue;
            throw new IllegalArgumentException(name + " field is either a duplicate or not a field of " + typeClass);
        }
        if (map.size() == 0) {
            throw new IllegalArgumentException("No fields are left.  Everything was excluded.");
        }
        return map;
    }

    static <T> int includeAndAddTo(Map<String, MappedSchema.Field<T>> map, Class<T> typeClass, Map<String, MappedSchema.Field<T>> byName, String[] args) {
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("You must provide at least 1 field to include.");
        }
        int maxFieldNumber = 0;
        for (String name : args) {
            MappedSchema.Field<T> field = byName.get(name);
            if (field == null) {
                throw new IllegalArgumentException(name + " is not a field of " + typeClass);
            }
            map.put(field.name, field);
            maxFieldNumber = Math.max(field.number, maxFieldNumber);
        }
        return maxFieldNumber;
    }

    public static enum Factories implements Factory
    {
        PREDICATE{

            @Override
            public <T> Schema<T> create(Class<T> typeClass, final MappedSchema.Field<T>[] fields, final MappedSchema.Field<T>[] fieldsByNumber, final Map<String, MappedSchema.Field<T>> fieldsByName, RuntimeEnv.Instantiator<T> instantiator, Predicate.Factory pf, String[] args) {
                if (pf == null) {
                    throw new IllegalArgumentException("Predicate.Factory arg must not be null.");
                }
                final Predicate predicate = pf.create(args);
                return new BaseSchema<T>(typeClass, instantiator){

                    public int getFieldNumber(String name) {
                        MappedSchema.Field field = (MappedSchema.Field)fieldsByName.get(name);
                        return field != null && predicate.apply(field) ? field.number : 0;
                    }

                    public void mergeFrom(Input input, T message) throws IOException {
                        int number = input.readFieldNumber((Schema)this);
                        while (number != 0) {
                            MappedSchema.Field field;
                            MappedSchema.Field field2 = field = number < fieldsByNumber.length ? fieldsByNumber[number] : null;
                            if (field == null || !predicate.apply(field, message)) {
                                input.handleUnknownField(number, (Schema)this);
                            } else {
                                field.mergeFrom(input, message);
                            }
                            number = input.readFieldNumber((Schema)this);
                        }
                    }

                    public String getFieldName(int number) {
                        MappedSchema.Field field = number < fieldsByNumber.length ? fieldsByNumber[number] : null;
                        return field == null ? null : field.name;
                    }

                    public void writeTo(Output output, T message) throws IOException {
                        for (MappedSchema.Field f : fields) {
                            if (!predicate.apply(f, message)) continue;
                            f.writeTo(output, message);
                        }
                    }
                };
            }
        }
        ,
        EXCLUDE{

            @Override
            public <T> Schema<T> create(Class<T> typeClass, MappedSchema.Field<T>[] flds, final MappedSchema.Field<T>[] fieldsByNumber, Map<String, MappedSchema.Field<T>> byName, RuntimeEnv.Instantiator<T> instantiator, Predicate.Factory factory, String[] args) {
                final HashMap<String, MappedSchema.Field<T>> fieldsByName = factory == null ? RuntimeView.copyAndExclude(typeClass, byName, args) : RuntimeView.copyAndExclude(typeClass, byName, factory.create(args));
                MappedSchema.Field[] fields = new MappedSchema.Field[fieldsByName.size()];
                int j = 0;
                for (int i = 1; i < fieldsByNumber.length; ++i) {
                    MappedSchema.Field<T> field = fieldsByNumber[i];
                    if (field == null || !fieldsByName.containsKey(field.name)) continue;
                    fields[j++] = field;
                }
                return new PostFilteredSchema<T>(typeClass, instantiator, fields){

                    public int getFieldNumber(String name) {
                        MappedSchema.Field field = (MappedSchema.Field)fieldsByName.get(name);
                        return field == null ? 0 : field.number;
                    }

                    public void mergeFrom(Input input, T message) throws IOException {
                        int number = input.readFieldNumber((Schema)this);
                        while (number != 0) {
                            MappedSchema.Field field;
                            MappedSchema.Field field2 = field = number < fieldsByNumber.length ? fieldsByNumber[number] : null;
                            if (field == null || !fieldsByName.containsKey(field.name)) {
                                input.handleUnknownField(number, (Schema)this);
                            } else {
                                field.mergeFrom(input, message);
                            }
                            number = input.readFieldNumber((Schema)this);
                        }
                    }

                    public String getFieldName(int number) {
                        MappedSchema.Field field = number < fieldsByNumber.length ? fieldsByNumber[number] : null;
                        return field == null ? null : field.name;
                    }

                    public void writeTo(Output output, T message) throws IOException {
                        for (MappedSchema.Field f : this.fields) {
                            f.writeTo(output, message);
                        }
                    }
                };
            }
        }
        ,
        EXCLUDE_OPTIMIZED_FOR_MERGE_ONLY{

            @Override
            public <T> Schema<T> create(Class<T> typeClass, final MappedSchema.Field<T>[] fields, final MappedSchema.Field<T>[] fieldsByNumber, Map<String, MappedSchema.Field<T>> byName, RuntimeEnv.Instantiator<T> instantiator, Predicate.Factory pf, String[] args) {
                final HashMap<String, MappedSchema.Field<T>> fieldsByName = RuntimeView.copyAndExclude(typeClass, byName, args);
                return new BaseSchema<T>(typeClass, instantiator){

                    public int getFieldNumber(String name) {
                        MappedSchema.Field field = (MappedSchema.Field)fieldsByName.get(name);
                        return field == null ? 0 : field.number;
                    }

                    public void mergeFrom(Input input, T message) throws IOException {
                        int number = input.readFieldNumber((Schema)this);
                        while (number != 0) {
                            MappedSchema.Field field;
                            MappedSchema.Field field2 = field = number < fieldsByNumber.length ? fieldsByNumber[number] : null;
                            if (field == null || !fieldsByName.containsKey(field.name)) {
                                input.handleUnknownField(number, (Schema)this);
                            } else {
                                field.mergeFrom(input, message);
                            }
                            number = input.readFieldNumber((Schema)this);
                        }
                    }

                    public String getFieldName(int number) {
                        MappedSchema.Field field = number < fieldsByNumber.length ? fieldsByNumber[number] : null;
                        return field == null ? null : field.name;
                    }

                    public void writeTo(Output output, T message) throws IOException {
                        for (MappedSchema.Field f : fields) {
                            if (!fieldsByName.containsKey(f.name)) continue;
                            f.writeTo(output, message);
                        }
                    }
                };
            }
        }
        ,
        INCLUDE{

            @Override
            public <T> Schema<T> create(Class<T> typeClass, MappedSchema.Field<T>[] flds, final MappedSchema.Field<T>[] fieldsByNumber, Map<String, MappedSchema.Field<T>> byName, RuntimeEnv.Instantiator<T> instantiator, Predicate.Factory factory, String[] args) {
                final HashMap fieldsByName = new HashMap();
                int maxFieldNumber = RuntimeView.includeAndAddTo(fieldsByName, typeClass, byName, args);
                MappedSchema.Field[] fields = new MappedSchema.Field[fieldsByName.size()];
                int j = 0;
                for (int i = 1; i <= maxFieldNumber; ++i) {
                    MappedSchema.Field<T> field = fieldsByNumber[i];
                    if (field == null || !fieldsByName.containsKey(field.name)) continue;
                    fields[j++] = field;
                }
                return new PostFilteredSchema<T>(typeClass, instantiator, fields){

                    public int getFieldNumber(String name) {
                        MappedSchema.Field field = (MappedSchema.Field)fieldsByName.get(name);
                        return field == null ? 0 : field.number;
                    }

                    public void mergeFrom(Input input, T message) throws IOException {
                        int number = input.readFieldNumber((Schema)this);
                        while (number != 0) {
                            MappedSchema.Field field;
                            MappedSchema.Field field2 = field = number < fieldsByNumber.length ? fieldsByNumber[number] : null;
                            if (field == null || !fieldsByName.containsKey(field.name)) {
                                input.handleUnknownField(number, (Schema)this);
                            } else {
                                field.mergeFrom(input, message);
                            }
                            number = input.readFieldNumber((Schema)this);
                        }
                    }

                    public String getFieldName(int number) {
                        MappedSchema.Field field = number < fieldsByNumber.length ? fieldsByNumber[number] : null;
                        return field == null ? null : field.name;
                    }

                    public void writeTo(Output output, T message) throws IOException {
                        for (MappedSchema.Field f : this.fields) {
                            f.writeTo(output, message);
                        }
                    }
                };
            }
        }
        ,
        INCLUDE_OPTIMIZED_FOR_MERGE_ONLY{

            @Override
            public <T> Schema<T> create(Class<T> typeClass, final MappedSchema.Field<T>[] fields, final MappedSchema.Field<T>[] fieldsByNumber, Map<String, MappedSchema.Field<T>> byName, RuntimeEnv.Instantiator<T> instantiator, Predicate.Factory pf, String[] args) {
                final HashMap fieldsByName = new HashMap();
                RuntimeView.includeAndAddTo(fieldsByName, typeClass, byName, args);
                return new BaseSchema<T>(typeClass, instantiator){

                    public int getFieldNumber(String name) {
                        MappedSchema.Field field = (MappedSchema.Field)fieldsByName.get(name);
                        return field == null ? 0 : field.number;
                    }

                    public void mergeFrom(Input input, T message) throws IOException {
                        int number = input.readFieldNumber((Schema)this);
                        while (number != 0) {
                            MappedSchema.Field field;
                            MappedSchema.Field field2 = field = number < fieldsByNumber.length ? fieldsByNumber[number] : null;
                            if (field == null || !fieldsByName.containsKey(field.name)) {
                                input.handleUnknownField(number, (Schema)this);
                            } else {
                                field.mergeFrom(input, message);
                            }
                            number = input.readFieldNumber((Schema)this);
                        }
                    }

                    public String getFieldName(int number) {
                        MappedSchema.Field field = number < fieldsByNumber.length ? fieldsByNumber[number] : null;
                        return field == null ? null : field.name;
                    }

                    public void writeTo(Output output, T message) throws IOException {
                        for (MappedSchema.Field f : fields) {
                            if (!fieldsByName.containsKey(f.name)) continue;
                            f.writeTo(output, message);
                        }
                    }
                };
            }
        };

    }

    public static abstract class PostFilteredSchema<T>
    extends BaseSchema<T> {
        public final MappedSchema.Field<T>[] fields;

        protected PostFilteredSchema(Class<T> typeClass, RuntimeEnv.Instantiator<T> instantiator, MappedSchema.Field<T>[] fields) {
            super(typeClass, instantiator);
            this.fields = fields;
        }
    }

    public static abstract class BaseSchema<T>
    implements Schema<T> {
        public final Class<T> typeClass;
        public final RuntimeEnv.Instantiator<T> instantiator;

        protected BaseSchema(Class<T> typeClass, RuntimeEnv.Instantiator<T> instantiator) {
            this.typeClass = typeClass;
            this.instantiator = instantiator;
        }

        public Class<T> typeClass() {
            return this.typeClass;
        }

        public String messageName() {
            return this.typeClass.getSimpleName();
        }

        public String messageFullName() {
            return this.typeClass.getName();
        }

        public boolean isInitialized(T message) {
            return true;
        }

        public T newMessage() {
            return (T)this.instantiator.newInstance();
        }
    }

    public static interface Factory {
        public <T> Schema<T> create(Class<T> var1, MappedSchema.Field<T>[] var2, MappedSchema.Field<T>[] var3, Map<String, MappedSchema.Field<T>> var4, RuntimeEnv.Instantiator<T> var5, Predicate.Factory var6, String[] var7);
    }
}

