/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.plugins.vault;

import com.google.gson.Gson;
import io.provenance.core.Plugin;
import io.provenance.entity.KeyEntity;
import io.provenance.entity.KeyType;
import io.provenance.entity.direct.DirectKeyEntity;
import io.provenance.plugins.vault.VaultPlugin;
import io.provenance.plugins.vault.VaultSpec;
import io.provenance.plugins.vault.config.VaultSecret;
import io.provenance.scope.encryption.model.DirectKeyRef;
import io.provenance.scope.encryption.util.KeyExtensionsKt;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J,\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/provenance/plugins/vault/VaultPlugin;", "Lio/provenance/core/Plugin;", "()V", "log", "Lmu/KLogger;", "fetch", "Lio/provenance/entity/KeyEntity;", "pluginSpec", "", "getKey", "", "secretData", "", "keyName", "originator", "supports", "", "lib"})
public final class VaultPlugin
implements Plugin {
    @NotNull
    private final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    @Override
    public boolean supports(@NotNull Object pluginSpec) {
        Intrinsics.checkNotNullParameter((Object)pluginSpec, (String)"pluginSpec");
        return pluginSpec instanceof VaultSpec;
    }

    @Override
    @NotNull
    public KeyEntity fetch(@NotNull Object pluginSpec) {
        VaultSecret secret;
        Intrinsics.checkNotNullParameter((Object)pluginSpec, (String)"pluginSpec");
        VaultSpec spec = (VaultSpec)pluginSpec;
        this.log.info("Fetching properties and creating configuration for " + spec.getEntity());
        File path = new File(spec.getTokenPath()).exists() ? new File(spec.getTokenPath()) : FilesKt.resolve((File)new File(System.getProperty("user.home")), (String)spec.getTokenPath());
        String token = FilesKt.readText((File)path, (Charset)Charsets.UTF_8);
        HttpResponse response = ((GetRequest)Unirest.get((String)spec.getVaultUrl()).header("X-Vault-Token", token)).asJson();
        VaultSecret vaultSecret = secret = (VaultSecret)new Gson().fromJson(((JsonNode)response.getBody()).toString(), VaultSecret.class);
        if ((vaultSecret == null ? null : vaultSecret.getData()) == null) {
            String[] stringArray = secret.getErrors();
            if (!(stringArray == null || stringArray.length == 0)) {
                throw new Error(ArraysKt.joinToString$default((Object[])secret.getErrors(), null, null, null, (int)3, null, null, (int)55, null));
            }
            throw new IllegalArgumentException("Could not find secret for " + spec.getEntity() + ".");
        }
        Map<String, Object> secretData = secret.getData().getData();
        DirectKeyRef signingKeyRef = new DirectKeyRef(KeyExtensionsKt.toJavaPublicKey((String)this.getKey(secretData, "public_signing_key", spec.getEntity())), KeyExtensionsKt.toJavaPrivateKey((String)this.getKey(secretData, "private_signing_key", spec.getEntity())));
        DirectKeyRef encryptionKeyRef = new DirectKeyRef(KeyExtensionsKt.toJavaPublicKey((String)this.getKey(secretData, "public_encryption_key", spec.getEntity())), KeyExtensionsKt.toJavaPrivateKey((String)this.getKey(secretData, "private_encryption_key", spec.getEntity())));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)KeyType.SIGNING), (Object)signingKeyRef), TuplesKt.to((Object)((Object)KeyType.ENCRYPTION), (Object)encryptionKeyRef)};
        return new DirectKeyEntity(MapsKt.mapOf((Pair[])pairArray), KeyExtensionsKt.toJavaPrivateKey((String)this.getKey(secretData, "private_signing_key", spec.getEntity())));
    }

    private final String getKey(Map<String, ? extends Object> secretData, String keyName, String originator) {
        if (!secretData.containsKey(keyName)) {
            throw new IllegalArgumentException("Missing " + keyName + " key for " + originator + ".");
        }
        return String.valueOf(secretData.get(keyName));
    }
}

