/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.adapters.cipher;

import io.proximax.xpx.adapters.cipher.SymmetricKeyEncryption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class BinaryPBKDF2CipherEncryption
extends SymmetricKeyEncryption {
    private static final String CONST_ALGO_PBKDF2 = "PBKDF2WithHmacSHA256";
    private static final byte[] SALT = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
    private static final byte[] FIXED_NONCE = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};

    @Override
    public byte[] encrypt(byte[] binary, char[] password) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(CONST_ALGO_PBKDF2);
        PBEKeySpec keyspec = new PBEKeySpec(password, SALT, 65536, 128);
        SecretKey tmp = factory.generateSecret(keyspec);
        SecretKeySpec key = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec spec = new GCMParameterSpec(128, FIXED_NONCE);
        cipher.init(1, (Key)key, spec);
        byte[] byteCipher = cipher.doFinal(binary);
        return byteCipher;
    }

    public String encryptToBase64String(byte[] binary, char[] password) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(CONST_ALGO_PBKDF2);
        PBEKeySpec keyspec = new PBEKeySpec(password, SALT, 65536, 128);
        SecretKey tmp = factory.generateSecret(keyspec);
        SecretKeySpec key = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec spec = new GCMParameterSpec(128, FIXED_NONCE);
        cipher.init(1, (Key)key, spec);
        byte[] byteCipher = cipher.doFinal(binary);
        String cipherText = new String(Base64.getEncoder().encode(byteCipher));
        return cipherText;
    }

    public byte[] decrypt(String encodedCipherText, char[] password) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(CONST_ALGO_PBKDF2);
        PBEKeySpec keyspec = new PBEKeySpec(password, SALT, 65536, 128);
        SecretKey tmp = factory.generateSecret(keyspec);
        SecretKeySpec key = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec spec = new GCMParameterSpec(128, FIXED_NONCE);
        cipher.init(2, (Key)key, spec);
        byte[] decryptedCipher = cipher.doFinal(Base64.getDecoder().decode(encodedCipherText));
        return decryptedCipher;
    }

    public String decryptToBase64String(String encodedCipherText, char[] password) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(CONST_ALGO_PBKDF2);
        PBEKeySpec keyspec = new PBEKeySpec(password, SALT, 65536, 128);
        SecretKey tmp = factory.generateSecret(keyspec);
        SecretKeySpec key = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec spec = new GCMParameterSpec(128, FIXED_NONCE);
        cipher.init(2, (Key)key, spec);
        byte[] decryptedCipher = cipher.doFinal(Base64.getDecoder().decode(encodedCipherText));
        String decryptedCipherText = new String(decryptedCipher);
        return decryptedCipherText;
    }

    @Override
    public byte[] decrypt(byte[] binary, char[] password) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(CONST_ALGO_PBKDF2);
        PBEKeySpec keyspec = new PBEKeySpec(password, SALT, 65536, 128);
        SecretKey tmp = factory.generateSecret(keyspec);
        SecretKeySpec key = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec spec = new GCMParameterSpec(128, FIXED_NONCE);
        cipher.init(2, (Key)key, spec);
        byte[] decryptedCipher = cipher.doFinal(binary);
        return decryptedCipher;
    }

    public String decryptToBase64String(byte[] binary, char[] password) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(CONST_ALGO_PBKDF2);
        PBEKeySpec keyspec = new PBEKeySpec(password, SALT, 65536, 128);
        SecretKey tmp = factory.generateSecret(keyspec);
        SecretKeySpec key = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec spec = new GCMParameterSpec(128, FIXED_NONCE);
        cipher.init(2, (Key)key, spec);
        byte[] decryptedCipher = cipher.doFinal(binary);
        String decryptedCipherText = new String(decryptedCipher);
        return decryptedCipherText;
    }
}

