/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.builder;

import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.model.XpxSdkGlobalConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.nem.core.crypto.Hash;
import org.nem.core.crypto.Signature;
import org.nem.core.model.Account;
import org.nem.core.model.MultisigSignatureTransaction;
import org.nem.core.model.Transaction;
import org.nem.core.model.TransactionFeeCalculator;
import org.nem.core.model.primitive.Amount;
import org.nem.core.serialization.Deserializer;
import org.nem.core.time.TimeInstant;

public class MultisigSignatureTransactionBuilder {
    private MultisigSignatureTransactionBuilder() {
    }

    public static IPeerConnection peerConnection(PeerConnection peerConnection) {
        return new Builder(peerConnection);
    }

    private static class Builder
    implements IPeerConnection,
    ISigner,
    ITransaction,
    IBuild {
        private MultisigSignatureTransaction instance;
        private PeerConnection peerConnection;
        private TimeInstant timeStamp;
        private Account multisig;
        private Transaction otherTransaction;
        private Hash hashTransaction;
        private Signature signature;
        private Amount fee;
        private TransactionFeeCalculator feeCalculator;
        private Account signBy;
        private TimeInstant deadline;
        private List<Account> signers = new ArrayList<Account>();

        @Override
        public ISigner startAssignSigners() {
            return this;
        }

        @Override
        public ITransaction endAssignSigners() {
            return this;
        }

        public Builder(PeerConnection peerConnection) {
            this.peerConnection = peerConnection;
        }

        @Override
        public ISigner multisig(Account multisig) {
            this.multisig = multisig;
            return this;
        }

        private MultisigSignatureTransaction buildMultisigSignatureTransaction() {
            if (this.timeStamp == null) {
                this.timeStamp = XpxSdkGlobalConstants.TIME_PROVIDER.getCurrentTime();
            }
            for (Account signer : this.signers) {
                if (this.otherTransaction != null) {
                    this.instance = new MultisigSignatureTransaction(this.timeStamp, signer, this.multisig, this.otherTransaction);
                }
                if (this.hashTransaction != null) {
                    this.instance = new MultisigSignatureTransaction(this.timeStamp, signer, this.multisig, this.hashTransaction);
                }
                if (this.fee == null && this.feeCalculator == null) {
                    this.instance.setFee(this.peerConnection.getTransactionFeeCalculators().getFeeCalculator().calculateMinimumFee((Transaction)this.instance));
                } else if (this.fee != null) {
                    this.instance.setFee(this.fee);
                } else if (this.feeCalculator != null) {
                    TransactionFeeCalculator feeCalculator = this.feeCalculator != null ? this.feeCalculator : this.peerConnection.getTransactionFeeCalculators().getFeeCalculator();
                    this.instance.setFee(feeCalculator.calculateMinimumFee((Transaction)this.instance));
                }
                if (this.deadline != null) {
                    this.instance.setDeadline(this.deadline);
                } else {
                    this.instance.setDeadline(this.timeStamp.addHours(23));
                }
                if (this.signature != null) {
                    this.instance.setSignature(this.signature);
                }
                if (this.signBy != null) {
                    this.instance.signBy(this.signBy);
                }
                this.instance.sign();
            }
            return this.instance;
        }

        @Override
        public MultisigSignatureTransaction coSign() throws ApiException {
            this.peerConnection.getTransactionSender().sendMultisigSignatureTransaction(this.buildMultisigSignatureTransaction());
            return this.instance;
        }

        @Override
        public IBuild fee(Amount amount) {
            this.fee = amount;
            return this;
        }

        @Override
        public IBuild deadline(TimeInstant deadline) {
            this.deadline = deadline;
            return this;
        }

        @Override
        public IBuild signature(Signature signature) {
            this.signature = signature;
            return this;
        }

        @Override
        public IBuild timeStamp(TimeInstant timeInstance) {
            this.timeStamp = timeInstance;
            return this;
        }

        @Override
        public IBuild signBy(Account account) {
            this.signBy = account;
            return this;
        }

        @Override
        public IBuild feeCalculator(TransactionFeeCalculator feeCalculator) {
            this.feeCalculator = feeCalculator;
            return this;
        }

        @Override
        public IBuild otherTransaction(Transaction transaction) {
            this.otherTransaction = transaction;
            return this;
        }

        @Override
        public IBuild otherTransaction(Hash hashTransaction) {
            this.hashTransaction = hashTransaction;
            return this;
        }

        @Override
        public ISigner addSigner(Account signer) {
            this.signers.add(signer);
            return this;
        }

        @Override
        public ITransaction addSigners(List<Account> signers) {
            this.signers.addAll(signers);
            return this;
        }

        @Override
        public ITransaction signer(Account signer) {
            this.signers.add(signer);
            return this;
        }

        @Override
        public CompletableFuture<Deserializer> coSignFuture() throws ApiException {
            return this.peerConnection.getTransactionSender().sendFutureMultisigSignatureTransaction(this.buildMultisigSignatureTransaction());
        }
    }

    public static interface IBuild {
        public IBuild timeStamp(TimeInstant var1);

        public IBuild signBy(Account var1);

        public IBuild fee(Amount var1);

        public IBuild feeCalculator(TransactionFeeCalculator var1);

        public IBuild deadline(TimeInstant var1);

        public IBuild signature(Signature var1);

        public MultisigSignatureTransaction coSign() throws ApiException;

        public CompletableFuture<Deserializer> coSignFuture() throws ApiException;
    }

    public static interface ITransaction {
        public IBuild otherTransaction(Transaction var1);

        public IBuild otherTransaction(Hash var1);
    }

    public static interface ISigner {
        public ITransaction signer(Account var1);

        public ISigner startAssignSigners();

        public ISigner addSigner(Account var1);

        public ITransaction addSigners(List<Account> var1);

        public ITransaction endAssignSigners();
    }

    public static interface IPeerConnection {
        public ISigner multisig(Account var1);
    }
}

