/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.builder;

import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.model.RequestAnnounceDataSignature;
import io.proximax.xpx.model.XpxSdkGlobalConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.nem.core.crypto.Signature;
import org.nem.core.model.Account;
import org.nem.core.model.MultisigSignatureTransaction;
import org.nem.core.model.MultisigTransaction;
import org.nem.core.model.Transaction;
import org.nem.core.model.TransactionFeeCalculator;
import org.nem.core.model.TransferTransaction;
import org.nem.core.model.mosaic.Mosaic;
import org.nem.core.model.mosaic.MosaicId;
import org.nem.core.model.namespace.NamespaceId;
import org.nem.core.model.ncc.NemAnnounceResult;
import org.nem.core.model.ncc.RequestAnnounce;
import org.nem.core.model.primitive.Amount;
import org.nem.core.model.primitive.Quantity;
import org.nem.core.serialization.BinarySerializer;
import org.nem.core.serialization.Deserializer;
import org.nem.core.serialization.JsonDeserializer;
import org.nem.core.serialization.JsonSerializer;
import org.nem.core.serialization.SerializableEntity;
import org.nem.core.time.TimeInstant;

public class MultisigTransactionBuilder {
    private MultisigTransactionBuilder() {
    }

    public static IPeerConnection peerConnection(PeerConnection peerConnection) {
        return new Builder(peerConnection);
    }

    private static class Builder
    implements IPeerConnection,
    ITransaction,
    IBuild {
        private MultisigTransaction instance;
        private PeerConnection peerConnection;
        private TimeInstant timeStamp;
        private Account sender;
        private Transaction otherTransaction;
        private Signature signature;
        private Amount fee;
        private TransactionFeeCalculator feeCalculator;
        private Account signBy;
        private TimeInstant deadline;
        private List<MultisigSignatureTransaction> multisigSignature = new ArrayList<MultisigSignatureTransaction>();

        public Builder(PeerConnection peerConnection) {
            this.peerConnection = peerConnection;
        }

        @Override
        public ITransaction sender(Account sender) {
            this.sender = sender;
            return this;
        }

        @Override
        public MultisigTransaction buildMultisigTransaction() {
            Mosaic xpxMosaic = new Mosaic(new MosaicId(new NamespaceId("prx"), "xpx"), Quantity.fromValue((long)1L));
            ((TransferTransaction)this.instance.getOtherTransaction()).getAttachment().addMosaic(xpxMosaic);
            if (this.timeStamp == null) {
                this.timeStamp = XpxSdkGlobalConstants.TIME_PROVIDER.getCurrentTime();
            }
            this.instance = new MultisigTransaction(this.timeStamp, this.sender, this.otherTransaction);
            if (this.fee == null && this.feeCalculator == null) {
                this.instance.setFee(this.peerConnection.getTransactionFeeCalculators().getFeeCalculatorMultiSig().calculateMinimumFee((Transaction)this.instance));
            } else if (this.fee != null) {
                this.instance.setFee(this.fee);
            } else if (this.feeCalculator != null) {
                TransactionFeeCalculator feeCalculator = this.feeCalculator != null ? this.feeCalculator : this.peerConnection.getTransactionFeeCalculators().getFeeCalculatorMultiSig();
                this.instance.setFee(feeCalculator.calculateMinimumFee((Transaction)this.instance));
            }
            if (this.deadline != null) {
                this.instance.setDeadline(this.deadline);
            } else {
                this.instance.setDeadline(this.timeStamp.addHours(23));
            }
            if (this.signature != null) {
                this.instance.setSignature(this.signature);
            }
            if (this.signBy != null) {
                this.instance.signBy(this.signBy);
            }
            if (this.multisigSignature.size() > 0) {
                for (MultisigSignatureTransaction multiSigSignatureTransaction : this.multisigSignature) {
                    this.instance.addSignature(multiSigSignatureTransaction);
                }
            }
            this.instance.sign();
            return this.instance;
        }

        @Override
        public NemAnnounceResult buildAndSendMultisigTransaction() throws ApiException {
            this.buildMultisigTransaction().sign();
            byte[] data = BinarySerializer.serializeToBytes((SerializableEntity)this.instance.asNonVerifiable());
            RequestAnnounce request = new RequestAnnounce(data, this.instance.getSignature().getBytes());
            RequestAnnounceDataSignature requestAnnounceDataSignature = new RequestAnnounceDataSignature();
            requestAnnounceDataSignature.setData(new JsonDeserializer(JsonSerializer.serializeToJson((SerializableEntity)request), null).readString("data", 5000));
            requestAnnounceDataSignature.setSignature(new JsonDeserializer(JsonSerializer.serializeToJson((SerializableEntity)request), null).readString("signature", 5000));
            return this.peerConnection.getTransactionSender().sendMultisigTransaction(this.instance);
        }

        @Override
        public IBuild fee(Amount amount) {
            this.fee = amount;
            return this;
        }

        @Override
        public IBuild deadline(TimeInstant timeInstant) {
            this.deadline = timeInstant;
            return this;
        }

        @Override
        public IBuild signature(Signature signature) {
            this.signature = signature;
            return this;
        }

        @Override
        public IBuild timeStamp(TimeInstant timeInstance) {
            return this;
        }

        @Override
        public IBuild signBy(Account account) {
            this.signBy = account;
            return this;
        }

        @Override
        public IBuild feeCalculator(TransactionFeeCalculator feeCalculator) {
            this.feeCalculator = feeCalculator;
            return this;
        }

        @Override
        public IBuild addSignature(MultisigSignatureTransaction signature) {
            this.multisigSignature.add(signature);
            return this;
        }

        @Override
        public IBuild otherTransaction(Transaction transaction) {
            this.otherTransaction = transaction;
            return this;
        }

        @Override
        public CompletableFuture<Deserializer> buildAndSendFutureMultisigTransaction() throws ApiException {
            return this.peerConnection.getTransactionSender().sendFutureMultiSigTransaction(this.buildMultisigTransaction());
        }

        @Override
        public RequestAnnounceDataSignature buildAndSignMultisigTransaction() throws ApiException {
            this.buildMultisigTransaction().sign();
            byte[] data = BinarySerializer.serializeToBytes((SerializableEntity)this.instance.asNonVerifiable());
            RequestAnnounce request = new RequestAnnounce(data, this.instance.getSignature().getBytes());
            RequestAnnounceDataSignature requestAnnounceDataSignature = new RequestAnnounceDataSignature();
            requestAnnounceDataSignature.setData(new JsonDeserializer(JsonSerializer.serializeToJson((SerializableEntity)request), null).readString("data", 5000));
            requestAnnounceDataSignature.setSignature(new JsonDeserializer(JsonSerializer.serializeToJson((SerializableEntity)request), null).readString("signature", 5000));
            return requestAnnounceDataSignature;
        }
    }

    public static interface IBuild {
        public IBuild timeStamp(TimeInstant var1);

        public IBuild signBy(Account var1);

        public IBuild fee(Amount var1);

        public IBuild feeCalculator(TransactionFeeCalculator var1);

        public IBuild deadline(TimeInstant var1);

        public IBuild signature(Signature var1);

        public IBuild addSignature(MultisigSignatureTransaction var1);

        public MultisigTransaction buildMultisigTransaction();

        public NemAnnounceResult buildAndSendMultisigTransaction() throws ApiException;

        public RequestAnnounceDataSignature buildAndSignMultisigTransaction() throws ApiException;

        public CompletableFuture<Deserializer> buildAndSendFutureMultisigTransaction() throws ApiException;
    }

    public static interface ITransaction {
        public IBuild otherTransaction(Transaction var1);
    }

    public static interface IPeerConnection {
        public ITransaction sender(Account var1);
    }
}

