/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.account;

import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.exceptions.PeerConnectionNotFoundException;
import io.proximax.xpx.facade.AbstractFacadeService;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.model.ResourceHashMessageJsonEntity;
import io.proximax.xpx.service.NemTransactionApi;
import io.proximax.xpx.service.intf.AccountApi;
import io.proximax.xpx.service.intf.SearchApi;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.nem.core.crypto.CryptoEngine;
import org.nem.core.crypto.CryptoEngines;
import org.nem.core.crypto.PublicKey;
import org.nem.core.model.Address;
import org.nem.core.model.Transaction;
import org.nem.core.model.ncc.TransactionMetaDataPair;

public class Account
extends AbstractFacadeService {
    protected final String publicKey;
    private final PeerConnection peerConnection;
    private final CryptoEngine engine;
    private final AccountApi accountApi;
    protected final NemTransactionApi nemTransactionApi;
    protected final SearchApi searchApi;
    private final boolean isLocalPeerConnection;

    public Account(PeerConnection peerConnection, String publicKey) {
        if (peerConnection == null) {
            throw new PeerConnectionNotFoundException("PeerConnection can't be null");
        }
        this.accountApi = peerConnection.getAccountApi();
        this.searchApi = peerConnection.getSearchApi();
        this.isLocalPeerConnection = peerConnection.isLocal();
        this.peerConnection = peerConnection;
        this.nemTransactionApi = peerConnection.getNemTransactionApi();
        this.engine = CryptoEngines.ed25519Engine();
        this.publicKey = publicKey;
    }

    public List<TransactionMetaDataPair> getIncomingTransactions() throws ApiException, InterruptedException, ExecutionException {
        ArrayList<TransactionMetaDataPair> returnListOfTxnMetaDataPair = new ArrayList<TransactionMetaDataPair>();
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getIncomingTransactions(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)this.publicKey)).getEncoded());
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            if (!this.checkIfTxnHaveXPXMosaic((Transaction)metaDataPair.getEntity())) continue;
            returnListOfTxnMetaDataPair.add(metaDataPair);
        }
        return returnListOfTxnMetaDataPair;
    }

    public List<TransactionMetaDataPair> getAllTransactions() throws ApiException, InterruptedException, ExecutionException {
        ArrayList<TransactionMetaDataPair> returnListOfTxnMetaDataPair = new ArrayList<TransactionMetaDataPair>();
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getAllTransactions(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)this.publicKey)).getEncoded());
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            if (!this.checkIfTxnHaveXPXMosaic((Transaction)metaDataPair.getEntity())) continue;
            returnListOfTxnMetaDataPair.add(metaDataPair);
        }
        return returnListOfTxnMetaDataPair;
    }

    public List<TransactionMetaDataPair> getOutgoingTransactions() throws ApiException, InterruptedException, ExecutionException {
        ArrayList<TransactionMetaDataPair> returnListOfTxnMetaDataPair = new ArrayList<TransactionMetaDataPair>();
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getOutgoingTransactions(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)this.publicKey)).getEncoded());
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            if (!this.checkIfTxnHaveXPXMosaic((Transaction)metaDataPair.getEntity())) continue;
            returnListOfTxnMetaDataPair.add(metaDataPair);
        }
        return returnListOfTxnMetaDataPair;
    }

    public List<TransactionMetaDataPair> getUnconfirmedTransactions() throws ApiException, InterruptedException, ExecutionException {
        ArrayList<TransactionMetaDataPair> returnListOfTxnMetaDataPair = new ArrayList<TransactionMetaDataPair>();
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getUnconfirmedTransactions(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)this.publicKey)).getEncoded());
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            if (!this.checkIfTxnHaveXPXMosaic((Transaction)metaDataPair.getEntity())) continue;
            returnListOfTxnMetaDataPair.add(metaDataPair);
        }
        return returnListOfTxnMetaDataPair;
    }

    public List<ResourceHashMessageJsonEntity> searchByName(String xPvkey, String name) throws ApiException, InterruptedException, ExecutionException {
        return this.searchApi.searchTransactionWithKeywordUsingGET(xPvkey, this.publicKey, name);
    }

    public List<ResourceHashMessageJsonEntity> searchByKeyword(String xPvkey, String keywords) throws ApiException, InterruptedException, ExecutionException {
        return this.searchApi.searchTransactionWithKeywordUsingGET(xPvkey, this.publicKey, keywords);
    }

    public List<ResourceHashMessageJsonEntity> searchByMetaDataKeyValue(String xPvkey, String key, String value) throws ApiException, InterruptedException, ExecutionException {
        return this.searchApi.searchTransactionWithMetadataKeyValuePair(xPvkey, this.publicKey, key, value);
    }
}

