/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.account;

import io.proximax.xpx.callback.ServiceAsyncCallback;
import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.facade.AbstractAsyncFacadeService;
import io.proximax.xpx.facade.account.Account;
import io.proximax.xpx.facade.connection.PeerConnection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.nem.core.model.ncc.TransactionMetaDataPair;

public class AccountAsync
extends AbstractAsyncFacadeService {
    private Account account;

    public AccountAsync(PeerConnection peerConnection, String publicKey) {
        this.account = new Account(peerConnection, publicKey);
    }

    public CompletableFuture<List<TransactionMetaDataPair>> getIncomingTransactions(ServiceAsyncCallback<List<TransactionMetaDataPair>> callback) {
        return this.runAsync(() -> {
            try {
                return this.account.getIncomingTransactions();
            }
            catch (ApiException | InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        }, callback);
    }

    public CompletableFuture<List<TransactionMetaDataPair>> getAllTransactions(ServiceAsyncCallback<List<TransactionMetaDataPair>> callback) {
        return this.runAsync(() -> {
            try {
                return this.account.getAllTransactions();
            }
            catch (ApiException | InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        }, callback);
    }

    public CompletableFuture<List<TransactionMetaDataPair>> getOutgoingTransactions(ServiceAsyncCallback<List<TransactionMetaDataPair>> callback) {
        return this.runAsync(() -> {
            try {
                return this.account.getOutgoingTransactions();
            }
            catch (ApiException | InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        }, callback);
    }

    public CompletableFuture<List<TransactionMetaDataPair>> getUnconfirmedTransactions(ServiceAsyncCallback<List<TransactionMetaDataPair>> callback) {
        return this.runAsync(() -> {
            try {
                return this.account.getUnconfirmedTransactions();
            }
            catch (ApiException | InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        }, callback);
    }
}

