/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.connection;

import io.ipfs.api.IPFS;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.service.NemAccountApi;
import io.proximax.xpx.service.NemTransactionApi;
import io.proximax.xpx.service.TransactionFeeCalculators;
import io.proximax.xpx.service.TransactionSender;
import io.proximax.xpx.service.common.FileAndNamingRouteApi;
import io.proximax.xpx.service.intf.AccountApi;
import io.proximax.xpx.service.intf.DataHashApi;
import io.proximax.xpx.service.intf.DirectoryLoadApi;
import io.proximax.xpx.service.intf.DownloadApi;
import io.proximax.xpx.service.intf.NodeApi;
import io.proximax.xpx.service.intf.PublishAndSubscribeApi;
import io.proximax.xpx.service.intf.SearchApi;
import io.proximax.xpx.service.intf.TransactionAndAnnounceApi;
import io.proximax.xpx.service.intf.UploadApi;
import io.proximax.xpx.service.local.LocalAccountApi;
import io.proximax.xpx.service.local.LocalDataHashApi;
import io.proximax.xpx.service.local.LocalDownloadApi;
import io.proximax.xpx.service.local.LocalNodeApi;
import io.proximax.xpx.service.local.LocalPublishAndSubscribeApi;
import io.proximax.xpx.service.local.LocalSearchApi;
import io.proximax.xpx.service.local.LocalTransactionAndAnnounceApi;
import io.proximax.xpx.service.local.LocalUploadApi;
import java.util.List;
import org.nem.core.connect.client.DefaultAsyncNemConnector;
import org.nem.core.node.ApiId;
import org.nem.core.node.NodeEndpoint;

public abstract class AbstractLocalPeerConnection
extends PeerConnection {
    private IPFS proximaxIpfsConnection;
    private AccountApi accountApi;
    private DataHashApi dataHashApi;
    private DownloadApi downloadApi;
    private NodeApi nodeApi;
    private PublishAndSubscribeApi publishAndSubscribeApi;
    private SearchApi searchApi;
    private TransactionAndAnnounceApi transactionAndAnnounceApi;
    private FileAndNamingRouteApi fileAndNamingRouteApi;
    private UploadApi uploadApi;
    private DefaultAsyncNemConnector<ApiId> asyncNemConnector;
    private NemTransactionApi nemTransactionApi;
    private NemAccountApi nemAccountApi;
    private TransactionSender transactionSender;
    private TransactionFeeCalculators transactionFeeCalculators;

    AbstractLocalPeerConnection(NodeEndpoint nodeEndpoint, IPFS ipfsConnection, List<String> syncGateways) {
        this.nodeEndpoint = nodeEndpoint;
        this.proximaxIpfsConnection = ipfsConnection;
        this.setSyncGateways(syncGateways);
    }

    @Override
    public final boolean isLocal() {
        return true;
    }

    @Override
    public AccountApi getAccountApi() {
        if (this.accountApi == null) {
            this.accountApi = new LocalAccountApi(this.getNemTransactionApi());
        }
        return this.accountApi;
    }

    @Override
    public DataHashApi getDataHashApi() {
        if (this.dataHashApi == null) {
            this.dataHashApi = new LocalDataHashApi(this.proximaxIpfsConnection);
        }
        return this.dataHashApi;
    }

    @Override
    public DirectoryLoadApi getDirectoryLoadApi() {
        throw new RuntimeException("not supported");
    }

    @Override
    public FileAndNamingRouteApi getFileAndNamingRouteApi() {
        throw new RuntimeException("not supported");
    }

    @Override
    public DownloadApi getDownloadApi() {
        if (this.downloadApi == null) {
            this.downloadApi = new LocalDownloadApi(this.getNemTransactionApi(), this.proximaxIpfsConnection);
        }
        return this.downloadApi;
    }

    @Override
    public NodeApi getNodeApi() {
        if (this.nodeApi == null) {
            this.nodeApi = new LocalNodeApi(this.proximaxIpfsConnection);
        }
        return this.nodeApi;
    }

    @Override
    public PublishAndSubscribeApi getPublishAndSubscribeApi() {
        if (this.publishAndSubscribeApi == null) {
            this.publishAndSubscribeApi = new LocalPublishAndSubscribeApi(this.proximaxIpfsConnection);
        }
        return this.publishAndSubscribeApi;
    }

    @Override
    public SearchApi getSearchApi() {
        if (this.searchApi == null) {
            this.searchApi = new LocalSearchApi(this.getNemTransactionApi());
        }
        return this.searchApi;
    }

    @Override
    public TransactionAndAnnounceApi getTransactionAndAnnounceApi() {
        if (this.transactionAndAnnounceApi == null) {
            this.transactionAndAnnounceApi = new LocalTransactionAndAnnounceApi(this.getNemTransactionApi());
        }
        return this.transactionAndAnnounceApi;
    }

    @Override
    public UploadApi getUploadApi() {
        if (this.uploadApi == null) {
            this.uploadApi = new LocalUploadApi(this.proximaxIpfsConnection);
        }
        return this.uploadApi;
    }
}

