/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.connection;

import io.proximax.xpx.factory.ConnectionFactory;
import io.proximax.xpx.service.NemAccountApi;
import io.proximax.xpx.service.NemNamespaceAndMosaicsApi;
import io.proximax.xpx.service.NemTransactionApi;
import io.proximax.xpx.service.TransactionAnnouncer;
import io.proximax.xpx.service.TransactionFeeCalculators;
import io.proximax.xpx.service.TransactionSender;
import io.proximax.xpx.service.common.FileAndNamingRouteApi;
import io.proximax.xpx.service.intf.AccountApi;
import io.proximax.xpx.service.intf.DataHashApi;
import io.proximax.xpx.service.intf.DirectoryLoadApi;
import io.proximax.xpx.service.intf.DownloadApi;
import io.proximax.xpx.service.intf.NodeApi;
import io.proximax.xpx.service.intf.PublishAndSubscribeApi;
import io.proximax.xpx.service.intf.SearchApi;
import io.proximax.xpx.service.intf.TransactionAndAnnounceApi;
import io.proximax.xpx.service.intf.UploadApi;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nem.core.connect.client.DefaultAsyncNemConnector;
import org.nem.core.node.ApiId;
import org.nem.core.node.NodeEndpoint;

public abstract class PeerConnection {
    protected NodeEndpoint nodeEndpoint;
    private List<String> syncGateways = Collections.emptyList();
    private DefaultAsyncNemConnector<ApiId> asyncNemConnector;
    private NemTransactionApi nemTransactionApi;
    private NemAccountApi nemAccountApi;
    private NemNamespaceAndMosaicsApi nemNamespaceAndMosaicsApi;
    private TransactionSender transactionSender;
    private TransactionFeeCalculators transactionFeeCalculators;
    private TransactionAnnouncer transactionAnnouncer;

    public abstract boolean isLocal();

    public abstract AccountApi getAccountApi();

    public abstract DataHashApi getDataHashApi();

    public abstract DirectoryLoadApi getDirectoryLoadApi();

    public abstract DownloadApi getDownloadApi();

    public abstract NodeApi getNodeApi();

    public abstract PublishAndSubscribeApi getPublishAndSubscribeApi();

    public abstract FileAndNamingRouteApi getFileAndNamingRouteApi();

    public abstract SearchApi getSearchApi();

    public abstract TransactionAndAnnounceApi getTransactionAndAnnounceApi();

    public abstract UploadApi getUploadApi();

    protected void setSyncGateways(List<String> ... syncGateways) {
        this.syncGateways = Collections.unmodifiableList(Stream.of(syncGateways).filter(Objects::nonNull).flatMap(list -> list.stream()).collect(Collectors.toList()));
    }

    public List<String> getSyncGateways() {
        return this.syncGateways;
    }

    public NemTransactionApi getNemTransactionApi() {
        if (this.nemTransactionApi == null) {
            this.nemTransactionApi = new NemTransactionApi(this.nodeEndpoint, this.getAsyncNemConnector());
        }
        return this.nemTransactionApi;
    }

    public NemAccountApi getNemAccountApi() {
        if (this.nemAccountApi == null) {
            this.nemAccountApi = new NemAccountApi(this.nodeEndpoint, this.getAsyncNemConnector());
        }
        return this.nemAccountApi;
    }

    public NemNamespaceAndMosaicsApi getNemNamespaceAndMosaicsApi() {
        if (this.nemNamespaceAndMosaicsApi == null) {
            this.nemNamespaceAndMosaicsApi = new NemNamespaceAndMosaicsApi(this.nodeEndpoint, this.getAsyncNemConnector());
        }
        return this.nemNamespaceAndMosaicsApi;
    }

    public TransactionSender getTransactionSender() {
        if (this.transactionSender == null) {
            this.transactionSender = new TransactionSender(this.getNemTransactionApi(), this.getNemAccountApi());
        }
        return this.transactionSender;
    }

    public TransactionFeeCalculators getTransactionFeeCalculators() {
        if (this.transactionFeeCalculators == null) {
            this.transactionFeeCalculators = new TransactionFeeCalculators(this.getNemAccountApi(), this.getNemNamespaceAndMosaicsApi());
        }
        return this.transactionFeeCalculators;
    }

    public TransactionAnnouncer getTransactionAnnouncer() {
        if (this.transactionAnnouncer == null) {
            this.transactionAnnouncer = new TransactionAnnouncer(this.getTransactionFeeCalculators(), this.getTransactionSender());
        }
        return this.transactionAnnouncer;
    }

    private DefaultAsyncNemConnector<ApiId> getAsyncNemConnector() {
        if (this.asyncNemConnector == null) {
            this.asyncNemConnector = ConnectionFactory.createConnector();
        }
        return this.asyncNemConnector;
    }
}

