/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.connection;

import io.proximax.ApiClient;
import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.exceptions.PeerConnectionInitFailureException;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.factory.ConnectionFactory;
import io.proximax.xpx.model.NodeInfo;
import io.proximax.xpx.service.common.FileAndNamingRouteApi;
import io.proximax.xpx.service.intf.AccountApi;
import io.proximax.xpx.service.intf.DataHashApi;
import io.proximax.xpx.service.intf.DirectoryLoadApi;
import io.proximax.xpx.service.intf.DownloadApi;
import io.proximax.xpx.service.intf.NodeApi;
import io.proximax.xpx.service.intf.PublishAndSubscribeApi;
import io.proximax.xpx.service.intf.SearchApi;
import io.proximax.xpx.service.intf.TransactionAndAnnounceApi;
import io.proximax.xpx.service.intf.UploadApi;
import io.proximax.xpx.service.remote.RemoteAccountApi;
import io.proximax.xpx.service.remote.RemoteDataHashApi;
import io.proximax.xpx.service.remote.RemoteDirectoryLoadApi;
import io.proximax.xpx.service.remote.RemoteDownloadApi;
import io.proximax.xpx.service.remote.RemoteNodeApi;
import io.proximax.xpx.service.remote.RemotePublishAndSubscribeApi;
import io.proximax.xpx.service.remote.RemoteSearchApi;
import io.proximax.xpx.service.remote.RemoteTransactionAndAnnounceApi;
import io.proximax.xpx.service.remote.RemoteUploadApi;
import java.util.Arrays;
import java.util.List;
import org.nem.core.node.NodeEndpoint;

public final class RemotePeerConnection
extends PeerConnection {
    private ApiClient apiClient;
    private AccountApi accountApi;
    private DataHashApi dataHashApi;
    private DirectoryLoadApi directoryLoadApi;
    private DownloadApi downloadApi;
    private NodeApi nodeApi;
    private PublishAndSubscribeApi publishAndSubscribeApi;
    private SearchApi searchApi;
    private TransactionAndAnnounceApi transactionAndAnnounceApi;
    private FileAndNamingRouteApi fileAndNamingRouteApi;
    private UploadApi uploadApi;

    public RemotePeerConnection(String baseUrl, String ... syncGateways) {
        this(baseUrl, Arrays.asList(syncGateways));
    }

    public RemotePeerConnection(String baseUrl, List<String> syncGateways) {
        this.init(baseUrl, syncGateways, null);
    }

    RemotePeerConnection(String baseUrl, List<String> syncGateways, RemoteNodeApi remoteNodeApi) {
        this.init(baseUrl, syncGateways, remoteNodeApi);
    }

    private void init(String baseUrl, List<String> syncGateways, RemoteNodeApi remoteNodeApi) {
        this.apiClient = new ApiClient().setBasePath(baseUrl);
        this.nodeApi = remoteNodeApi == null ? new RemoteNodeApi(this.apiClient) : remoteNodeApi;
        try {
            NodeInfo nodeInfo = this.nodeApi.getNodeInfoUsingGET();
            ConnectionFactory.setNetwork(nodeInfo.getNetwork());
            this.nodeEndpoint = new NodeEndpoint("http", nodeInfo.getNetworkAddress(), Integer.valueOf(nodeInfo.getNetworkPort()).intValue());
            this.setSyncGateways(syncGateways, nodeInfo.getSyncGateways());
        }
        catch (ApiException e) {
            throw new PeerConnectionInitFailureException(String.format("Failed it initialise due exception on API: %s", baseUrl), e);
        }
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public AccountApi getAccountApi() {
        if (this.accountApi == null) {
            this.accountApi = new RemoteAccountApi(this.apiClient);
        }
        return this.accountApi;
    }

    @Override
    public DataHashApi getDataHashApi() {
        if (this.dataHashApi == null) {
            this.dataHashApi = new RemoteDataHashApi(this.apiClient);
        }
        return this.dataHashApi;
    }

    @Override
    public DirectoryLoadApi getDirectoryLoadApi() {
        if (this.directoryLoadApi == null) {
            this.directoryLoadApi = new RemoteDirectoryLoadApi(this.apiClient);
        }
        return this.directoryLoadApi;
    }

    @Override
    public DownloadApi getDownloadApi() {
        if (this.downloadApi == null) {
            this.downloadApi = new RemoteDownloadApi(this.apiClient);
        }
        return this.downloadApi;
    }

    @Override
    public NodeApi getNodeApi() {
        return this.nodeApi;
    }

    @Override
    public PublishAndSubscribeApi getPublishAndSubscribeApi() {
        if (this.publishAndSubscribeApi == null) {
            this.publishAndSubscribeApi = new RemotePublishAndSubscribeApi(this.apiClient);
        }
        return this.publishAndSubscribeApi;
    }

    @Override
    public FileAndNamingRouteApi getFileAndNamingRouteApi() {
        if (this.fileAndNamingRouteApi == null) {
            this.fileAndNamingRouteApi = new FileAndNamingRouteApi(this.apiClient);
        }
        return this.fileAndNamingRouteApi;
    }

    @Override
    public SearchApi getSearchApi() {
        if (this.searchApi == null) {
            this.searchApi = new RemoteSearchApi(this.apiClient, this.getNemTransactionApi());
        }
        return this.searchApi;
    }

    @Override
    public TransactionAndAnnounceApi getTransactionAndAnnounceApi() {
        if (this.transactionAndAnnounceApi == null) {
            this.transactionAndAnnounceApi = new RemoteTransactionAndAnnounceApi(this.apiClient);
        }
        return this.transactionAndAnnounceApi;
    }

    @Override
    public UploadApi getUploadApi() {
        if (this.uploadApi == null) {
            this.uploadApi = new RemoteUploadApi(this.apiClient);
        }
        return this.uploadApi;
    }
}

