/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.download;

import io.proximax.xpx.exceptions.PeerConnectionNotFoundException;
import io.proximax.xpx.facade.AbstractFacadeService;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.facade.download.DownloadBinaryResult;
import io.proximax.xpx.facade.download.DownloadException;
import io.proximax.xpx.facade.download.DownloadFileResult;
import io.proximax.xpx.facade.download.DownloadParameter;
import io.proximax.xpx.facade.download.DownloadResult;
import io.proximax.xpx.facade.download.DownloadTextDataResult;
import io.proximax.xpx.model.NemMessageType;
import io.proximax.xpx.service.NemTransactionApi;
import io.proximax.xpx.service.intf.DownloadApi;
import io.proximax.xpx.service.model.buffers.ResourceHashMessage;
import org.nem.core.model.TransferTransaction;

public class Download
extends AbstractFacadeService {
    private final DownloadApi downloadApi;
    private final NemTransactionApi nemTransactionApi;

    public Download(PeerConnection peerConnection) {
        if (peerConnection == null) {
            throw new PeerConnectionNotFoundException("PeerConnection can't be null");
        }
        this.downloadApi = peerConnection.getDownloadApi();
        this.nemTransactionApi = peerConnection.getNemTransactionApi();
    }

    public DownloadBinaryResult downloadBinary(DownloadParameter downloadParameter) throws DownloadException {
        return DownloadBinaryResult.fromDownloadResult(this.download(downloadParameter));
    }

    public DownloadTextDataResult downloadTextData(DownloadParameter downloadParameter) throws DownloadException {
        return DownloadTextDataResult.fromDownloadResult(this.download(downloadParameter));
    }

    public DownloadFileResult downloadFile(DownloadParameter downloadParameter) throws DownloadException {
        return DownloadFileResult.fromDownloadResult(this.download(downloadParameter));
    }

    private DownloadResult download(DownloadParameter downloadParameter) throws DownloadException {
        if (downloadParameter.getNemHash() != null) {
            TransferTransaction transaction = this.getNemTransaction(downloadParameter.getNemHash());
            byte[] decodedDataFromNemMessage = downloadParameter.getPrivacyStrategy().decodeTransaction(transaction);
            ResourceHashMessage resourceMessage = this.deserializeResourceMessageHash(decodedDataFromNemMessage);
            byte[] downloadedData = this.downloadUsingDataHash(resourceMessage.hash());
            byte[] decryptedDownloadedData = downloadParameter.getPrivacyStrategy().decrypt(downloadedData, transaction, resourceMessage);
            return new DownloadResult(resourceMessage, decryptedDownloadedData, NemMessageType.fromInt(transaction.getMessage().getType()));
        }
        byte[] downloadedData = this.downloadUsingDataHash(downloadParameter.getIpfsHash());
        byte[] decryptedDownloadedData = downloadParameter.getPrivacyStrategy().decrypt(downloadedData, null, null);
        return new DownloadResult(null, decryptedDownloadedData, null);
    }

    private TransferTransaction getNemTransaction(String nemHash) throws DownloadException {
        try {
            return (TransferTransaction)this.nemTransactionApi.getTransaction(nemHash).getEntity();
        }
        catch (Exception e) {
            throw new DownloadException(String.format("Failed to retrieve a Nem Transaction for hash %s", nemHash), e);
        }
    }

    private byte[] downloadUsingDataHash(String hash) throws DownloadException {
        try {
            return this.downloadApi.downloadUsingDataHashUsingGET(hash);
        }
        catch (Exception e) {
            throw new DownloadException(String.format("Failed to download using data hash %s", hash), e);
        }
    }
}

