/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.download;

import io.proximax.xpx.callback.ServiceAsyncCallback;
import io.proximax.xpx.facade.AbstractAsyncFacadeService;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.facade.download.Download;
import io.proximax.xpx.facade.download.DownloadBinaryResult;
import io.proximax.xpx.facade.download.DownloadException;
import io.proximax.xpx.facade.download.DownloadFileResult;
import io.proximax.xpx.facade.download.DownloadParameter;
import io.proximax.xpx.facade.download.DownloadTextDataResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class DownloadAsync
extends AbstractAsyncFacadeService {
    private Download download;

    public DownloadAsync(PeerConnection peerConnection) {
        this.download = new Download(peerConnection);
    }

    public CompletableFuture<DownloadBinaryResult> downloadBinary(DownloadParameter downloadParameter, ServiceAsyncCallback<DownloadBinaryResult> callback) {
        return this.runAsync(() -> {
            try {
                return this.download.downloadBinary(downloadParameter);
            }
            catch (DownloadException e) {
                throw new CompletionException(e);
            }
        }, callback);
    }

    public CompletableFuture<DownloadTextDataResult> downloadTextData(DownloadParameter downloadParameter, ServiceAsyncCallback<DownloadTextDataResult> callback) {
        return this.runAsync(() -> {
            try {
                return this.download.downloadTextData(downloadParameter);
            }
            catch (DownloadException e) {
                throw new CompletionException(e);
            }
        }, callback);
    }

    public CompletableFuture<DownloadFileResult> downloadFile(DownloadParameter downloadParameter, ServiceAsyncCallback<DownloadFileResult> callback) {
        return this.runAsync(() -> {
            try {
                return this.download.downloadFile(downloadParameter);
            }
            catch (DownloadException e) {
                throw new CompletionException(e);
            }
        }, callback);
    }
}

