/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.download;

import io.proximax.xpx.facade.download.DownloadResult;
import io.proximax.xpx.model.NemMessageType;
import io.proximax.xpx.service.model.buffers.ResourceHashMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DownloadFileResult
extends DownloadResult {
    private DownloadFileResult(ResourceHashMessage dataMessage, byte[] data, NemMessageType messageType) {
        super(dataMessage, data, messageType);
    }

    public static DownloadFileResult fromDownloadResult(DownloadResult downloadResult) {
        return new DownloadFileResult(downloadResult.getDataMessage(), downloadResult.getData(), downloadResult.getMessageType());
    }

    public void saveToFile(File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            outputStream.write(this.getData());
        }
    }

    public String getFileName() {
        return this.getDataMessage() != null ? this.getDataMessage().name() : null;
    }

    public String getContentType() {
        return this.getDataMessage() != null ? this.getDataMessage().type() : null;
    }
}

