/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.download;

import io.proximax.xpx.builder.steps.HashStep;
import io.proximax.xpx.builder.steps.PrivacyStrategyDownloadStep;
import io.proximax.xpx.strategy.privacy.PrivacyStrategy;
import io.proximax.xpx.strategy.privacy.PrivacyStrategyFactory;
import io.proximax.xpx.strategy.privacy.SecuredWithShamirSecretSharingPrivacyStrategy;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DownloadParameter
implements Serializable {
    private String ipfsHash;
    private String nemHash;
    private String senderOrReceiverPrivateKey;
    private String receiverOrSenderPublicKey;
    private PrivacyStrategy privacyStrategy = PrivacyStrategyFactory.plainPrivacy();

    public String getNemHash() {
        return this.nemHash;
    }

    public void setNemHash(String nemHash) {
        this.nemHash = nemHash;
    }

    public String getIpfsHash() {
        return this.ipfsHash;
    }

    public void setIpfsHash(String ipfsHash) {
        this.ipfsHash = ipfsHash;
    }

    public String getSenderOrReceiverPrivateKey() {
        return this.senderOrReceiverPrivateKey;
    }

    public void setSenderOrReceiverPrivateKey(String senderOrReceiverPrivateKey) {
        this.senderOrReceiverPrivateKey = senderOrReceiverPrivateKey;
    }

    public String getReceiverOrSenderPublicKey() {
        return this.receiverOrSenderPublicKey;
    }

    public void setReceiverOrSenderPublicKey(String receiverOrSenderPublicKey) {
        this.receiverOrSenderPublicKey = receiverOrSenderPublicKey;
    }

    public PrivacyStrategy getPrivacyStrategy() {
        return this.privacyStrategy;
    }

    public void setPrivacyStrategy(PrivacyStrategy privacyStrategy) {
        this.privacyStrategy = privacyStrategy;
    }

    public static HashStep<BuildStep> create() {
        return new Builder();
    }

    private static class Builder
    implements HashStep,
    BuildStep {
        DownloadParameter instance = new DownloadParameter();

        private Builder() {
        }

        @Override
        public BuildStep privacyStrategy(PrivacyStrategy privacyStrategy) {
            this.instance.setPrivacyStrategy(privacyStrategy);
            return this;
        }

        @Override
        public BuildStep plainPrivacy() {
            this.instance.setPrivacyStrategy(PrivacyStrategyFactory.plainPrivacy());
            return this;
        }

        @Override
        public BuildStep securedWithNemKeysPrivacyStrategy(String senderOrReceiverPrivateKey, String receiverOrSenderPublicKey) {
            this.instance.setPrivacyStrategy(PrivacyStrategyFactory.securedWithNemKeysPrivacyStrategy(senderOrReceiverPrivateKey, receiverOrSenderPublicKey));
            this.instance.setSenderOrReceiverPrivateKey(senderOrReceiverPrivateKey);
            this.instance.setReceiverOrSenderPublicKey(receiverOrSenderPublicKey);
            return this;
        }

        @Override
        public BuildStep securedWithPasswordPrivacyStrategy(String password) {
            this.instance.setPrivacyStrategy(PrivacyStrategyFactory.securedWithPasswordPrivacyStrategy(password));
            return this;
        }

        @Override
        public BuildStep securedWithShamirSecretSharingPrivacyStrategy(int secretTotalPartCount, int secretMinimumPartCountToBuild, SecuredWithShamirSecretSharingPrivacyStrategy.SecretPart ... secretParts) {
            this.instance.setPrivacyStrategy(PrivacyStrategyFactory.securedWithShamirSecretSharingPrivacyStrategy(secretTotalPartCount, secretMinimumPartCountToBuild, Stream.of(secretParts).collect(Collectors.toMap(parts -> parts.index, parts -> parts.secretPart))));
            return this;
        }

        @Override
        public BuildStep securedWithShamirSecretSharingPrivacyStrategy(int secretTotalPartCount, int secretMinimumPartCountToBuild, List<SecuredWithShamirSecretSharingPrivacyStrategy.SecretPart> secretParts) {
            this.instance.setPrivacyStrategy(PrivacyStrategyFactory.securedWithShamirSecretSharingPrivacyStrategy(secretTotalPartCount, secretMinimumPartCountToBuild, secretParts == null ? Collections.emptyMap() : secretParts.stream().collect(Collectors.toMap(parts -> parts.index, parts -> parts.secretPart))));
            return this;
        }

        @Override
        public BuildStep securedWithShamirSecretSharingPrivacyStrategy(int secretTotalPartCount, int secretMinimumPartCountToBuild, Map<Integer, byte[]> secretParts) {
            this.instance.setPrivacyStrategy(PrivacyStrategyFactory.securedWithShamirSecretSharingPrivacyStrategy(secretTotalPartCount, secretMinimumPartCountToBuild, secretParts == null ? Collections.emptyMap() : secretParts));
            return this;
        }

        public BuildStep nemHash(String nemHash) {
            this.instance.setNemHash(nemHash);
            return this;
        }

        public BuildStep ipfsHash(String ipfsHash) {
            this.instance.setIpfsHash(ipfsHash);
            return this;
        }

        @Override
        public DownloadParameter build() {
            return this.instance;
        }
    }

    public static interface BuildStep
    extends PrivacyStrategyDownloadStep<BuildStep> {
        public DownloadParameter build();
    }
}

