/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.multisigupload;

import io.proximax.xpx.builder.MultisigTransactionBuilder;
import io.proximax.xpx.builder.TransferTransactionBuilder;
import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.exceptions.PeerConnectionNotFoundException;
import io.proximax.xpx.facade.AbstractFacadeService;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.facade.multisigupload.MultisigUploadBinaryParameter;
import io.proximax.xpx.facade.multisigupload.MultisigUploadFileParameter;
import io.proximax.xpx.facade.multisigupload.MultisigUploadResult;
import io.proximax.xpx.facade.multisigupload.MultisigUploadTextDataParameter;
import io.proximax.xpx.facade.upload.UploadException;
import io.proximax.xpx.facade.upload.UploadResult;
import io.proximax.xpx.model.NemMessageType;
import io.proximax.xpx.model.RequestAnnounceDataSignature;
import io.proximax.xpx.service.IpfsGatewaySyncService;
import io.proximax.xpx.service.UploadDelegate;
import io.proximax.xpx.service.intf.TransactionAndAnnounceApi;
import io.proximax.xpx.utils.CryptoUtils;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.nem.core.crypto.CryptoEngine;
import org.nem.core.crypto.CryptoEngines;
import org.nem.core.crypto.KeyPair;
import org.nem.core.crypto.PrivateKey;
import org.nem.core.crypto.PublicKey;
import org.nem.core.model.Account;
import org.nem.core.model.Address;
import org.nem.core.model.Message;
import org.nem.core.model.Transaction;
import org.nem.core.model.TransferTransaction;
import org.nem.core.model.ncc.NemAnnounceResult;
import org.nem.core.model.primitive.Amount;

public class MultisigUpload
extends AbstractFacadeService {
    private final PeerConnection peerConnection;
    private final CryptoEngine engine;
    private final UploadDelegate uploadDelegate;
    private final TransactionAndAnnounceApi transactionAndAnnounceApi;
    private final boolean isLocalPeerConnection;
    private final IpfsGatewaySyncService ipfsGatewaySyncService;

    public MultisigUpload(PeerConnection peerConnection) {
        if (peerConnection == null) {
            throw new PeerConnectionNotFoundException("PeerConnection can't be null");
        }
        this.peerConnection = peerConnection;
        this.transactionAndAnnounceApi = peerConnection.getTransactionAndAnnounceApi();
        this.isLocalPeerConnection = peerConnection.isLocal();
        this.engine = CryptoEngines.ed25519Engine();
        this.ipfsGatewaySyncService = new IpfsGatewaySyncService(peerConnection.getSyncGateways());
        this.uploadDelegate = new UploadDelegate(peerConnection.getUploadApi());
    }

    public MultisigUploadResult uploadDataOnMultisigTransaction(MultisigUploadTextDataParameter parameters) throws ApiException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, IOException, UploadException {
        MultisigUploadResult multisigUploadData = this.handleMultisigDataUpload(parameters);
        return multisigUploadData;
    }

    public MultisigUploadResult uploadFileOnMultisigTransaction(MultisigUploadFileParameter uploadParameter) throws IOException, ApiException, InvalidKeyException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UploadException {
        MultisigUploadResult multisigUploadData = this.handleMultisigFileUpload(uploadParameter);
        return multisigUploadData;
    }

    public MultisigUploadResult uploadBinaryOnMultisigTransaction(MultisigUploadBinaryParameter uploadParameter) throws IOException, ApiException, InvalidKeyException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UploadException {
        MultisigUploadResult multisigUploadData = this.handleMultisigBinaryUpload(uploadParameter);
        return multisigUploadData;
    }

    public MultisigUploadResult handleMultisigDataUpload(MultisigUploadTextDataParameter param) throws IOException, ApiException, UploadException {
        byte[] encrypted = null;
        Object response = null;
        UploadDelegate.ResourceHashMessageWrapper hashMessageWrapper = null;
        String publishedData = "";
        String secretKey = null;
        try {
            TransferTransaction transaction;
            if (param.getPrivacyStrategy().getNemMessageType() == NemMessageType.SECURE) {
                KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                keyGen.init(128);
                String keyRandom = Base64.encodeBase64String((byte[])keyGen.generateKey().getEncoded());
                encrypted = CryptoUtils.encrypt(param.getData().getBytes(), keyRandom.toCharArray());
                hashMessageWrapper = this.uploadDelegate.uploadTextToIpfs(encrypted, param.getName(), param.getContentType(), param.getEncoding(), param.getKeywords(), param.getMetaDataAsString());
                secretKey = keyRandom;
            } else {
                hashMessageWrapper = this.uploadDelegate.uploadTextToIpfs(param.getData().getBytes(), param.getName(), param.getContentType(), param.getEncoding(), param.getKeywords(), param.getMetaDataAsString());
            }
            Message nemMessage = param.getPrivacyStrategy().encodeToMessage(hashMessageWrapper.getData());
            if (this.isLocalPeerConnection) {
                transaction = new TransferTransactionBuilder(this.peerConnection.getTransactionFeeCalculators()).sender(new Account(new KeyPair(PublicKey.fromHexString((String)param.getMultisigPublicKey())))).recipient(new Account(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)param.getReceiverPublicKey())))).amount(Amount.fromNem((long)1L)).version(2).message(nemMessage).buildTransaction();
                NemAnnounceResult announceResult = MultisigTransactionBuilder.peerConnection(this.peerConnection).sender(new Account(new KeyPair(PrivateKey.fromHexString((String)param.getSenderPrivateKey())))).otherTransaction((Transaction)transaction).buildAndSendMultisigTransaction();
                publishedData = announceResult.getTransactionHash().toString();
            } else {
                transaction = new TransferTransactionBuilder(this.peerConnection.getTransactionFeeCalculators()).sender(new Account(new KeyPair(PublicKey.fromHexString((String)param.getMultisigPublicKey())))).recipient(new Account(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)param.getReceiverPublicKey())))).addMosaics(param.getMosaics()).amount(Amount.fromNem((long)1L)).message(nemMessage).buildTransaction();
                RequestAnnounceDataSignature requestAnnounceDataSignature = MultisigTransactionBuilder.peerConnection(this.peerConnection).sender(new Account(new KeyPair(PrivateKey.fromHexString((String)param.getSenderPrivateKey())))).otherTransaction((Transaction)transaction).buildAndSignMultisigTransaction();
                publishedData = this.transactionAndAnnounceApi.announceRequestPublishDataSignatureUsingPOST(requestAnnounceDataSignature);
            }
        }
        catch (Exception e) {
            this.uploadDelegate.deletePinnedContent(hashMessageWrapper.getResourceHashMessage().hash());
            throw new UploadException(e);
        }
        finally {
            this.ipfsGatewaySyncService.syncToGatewaysAsynchronously(hashMessageWrapper.getResourceHashMessage().hash());
        }
        return new MultisigUploadResult(new UploadResult(hashMessageWrapper.getResourceHashMessage(), publishedData), secretKey);
    }

    public MultisigUploadResult handleMultisigFileUpload(MultisigUploadFileParameter param) throws IOException, ApiException, UploadException {
        byte[] encrypted = null;
        byte[] response = null;
        UploadDelegate.ResourceHashMessageWrapper hashMessageWrapper = null;
        String publishedData = "";
        String secretKey = null;
        try {
            TransferTransaction transaction;
            if (param.getPrivacyStrategy().getNemMessageType() == NemMessageType.SECURE) {
                KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                keyGen.init(128);
                String keyRandom = Base64.encodeBase64String((byte[])keyGen.generateKey().getEncoded());
                encrypted = CryptoUtils.encrypt(FileUtils.readFileToByteArray((File)param.getFile()), keyRandom.toCharArray());
                hashMessageWrapper = this.uploadDelegate.uploadBinaryToIpfs(encrypted, param.getName(), param.getContentType(), param.getKeywords(), param.getMetaDataAsString());
                secretKey = keyRandom;
            } else {
                hashMessageWrapper = this.uploadDelegate.uploadBinaryToIpfs(FileUtils.readFileToByteArray((File)param.getFile()), param.getName(), param.getContentType(), param.getKeywords(), param.getMetaDataAsString());
            }
            Message nemMessage = param.getPrivacyStrategy().encodeToMessage(response);
            if (this.isLocalPeerConnection) {
                transaction = new TransferTransactionBuilder(this.peerConnection.getTransactionFeeCalculators()).sender(new Account(new KeyPair(PublicKey.fromHexString((String)param.getMultisigPublicKey())))).recipient(new Account(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)param.getReceiverPublicKey())))).amount(Amount.fromNem((long)1L)).message(nemMessage).buildTransaction();
                NemAnnounceResult announceResult = MultisigTransactionBuilder.peerConnection(this.peerConnection).sender(new Account(new KeyPair(PrivateKey.fromHexString((String)param.getSenderPrivateKey())))).otherTransaction((Transaction)transaction).buildAndSendMultisigTransaction();
                publishedData = announceResult.getTransactionHash().toString();
            } else {
                transaction = new TransferTransactionBuilder(this.peerConnection.getTransactionFeeCalculators()).sender(new Account(new KeyPair(PublicKey.fromHexString((String)param.getMultisigPublicKey())))).recipient(new Account(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)param.getReceiverPublicKey())))).addMosaics(param.getMosaics()).amount(Amount.fromNem((long)1L)).message(nemMessage).buildTransaction();
                RequestAnnounceDataSignature requestAnnounceDataSignature = MultisigTransactionBuilder.peerConnection(this.peerConnection).sender(new Account(new KeyPair(PrivateKey.fromHexString((String)param.getSenderPrivateKey())))).otherTransaction((Transaction)transaction).buildAndSignMultisigTransaction();
                publishedData = this.transactionAndAnnounceApi.announceRequestPublishDataSignatureUsingPOST(requestAnnounceDataSignature);
            }
        }
        catch (Exception e) {
            this.uploadDelegate.deletePinnedContent(hashMessageWrapper.getResourceHashMessage().hash());
            throw new UploadException(e);
        }
        return new MultisigUploadResult(new UploadResult(hashMessageWrapper.getResourceHashMessage(), publishedData), secretKey);
    }

    public MultisigUploadResult handleMultisigBinaryUpload(MultisigUploadBinaryParameter param) throws IOException, ApiException, UploadException {
        byte[] encrypted = null;
        byte[] response = null;
        UploadDelegate.ResourceHashMessageWrapper hashMessageWrapper = null;
        String publishedData = "";
        String secretKey = null;
        try {
            TransferTransaction transaction;
            if (param.getPrivacyStrategy().getNemMessageType() == NemMessageType.SECURE) {
                KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                keyGen.init(128);
                String keyRandom = Base64.encodeBase64String((byte[])keyGen.generateKey().getEncoded());
                encrypted = CryptoUtils.encrypt(param.getData(), keyRandom.toCharArray());
                hashMessageWrapper = this.uploadDelegate.uploadBinaryToIpfs(encrypted, param.getName(), param.getContentType(), param.getKeywords(), param.getMetaDataAsString());
                secretKey = keyRandom;
            } else {
                hashMessageWrapper = this.uploadDelegate.uploadBinaryToIpfs(param.getData(), param.getName(), param.getContentType(), param.getKeywords(), param.getMetaDataAsString());
            }
            Message nemMessage = param.getPrivacyStrategy().encodeToMessage(response);
            if (this.isLocalPeerConnection) {
                transaction = new TransferTransactionBuilder(this.peerConnection.getTransactionFeeCalculators()).sender(new Account(new KeyPair(PublicKey.fromHexString((String)param.getMultisigPublicKey())))).recipient(new Account(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)param.getReceiverPublicKey())))).amount(Amount.fromNem((long)1L)).message(nemMessage).buildTransaction();
                NemAnnounceResult announceResult = MultisigTransactionBuilder.peerConnection(this.peerConnection).sender(new Account(new KeyPair(PrivateKey.fromHexString((String)param.getSenderPrivateKey())))).otherTransaction((Transaction)transaction).buildAndSendMultisigTransaction();
                publishedData = announceResult.getTransactionHash().toString();
            } else {
                transaction = new TransferTransactionBuilder(this.peerConnection.getTransactionFeeCalculators()).sender(new Account(new KeyPair(PublicKey.fromHexString((String)param.getMultisigPublicKey())))).recipient(new Account(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)param.getReceiverPublicKey())))).addMosaics(param.getMosaics()).amount(Amount.fromNem((long)1L)).message(nemMessage).buildTransaction();
                RequestAnnounceDataSignature requestAnnounceDataSignature = MultisigTransactionBuilder.peerConnection(this.peerConnection).sender(new Account(new KeyPair(PrivateKey.fromHexString((String)param.getSenderPrivateKey())))).otherTransaction((Transaction)transaction).buildAndSignMultisigTransaction();
                publishedData = this.transactionAndAnnounceApi.announceRequestPublishDataSignatureUsingPOST(requestAnnounceDataSignature);
            }
        }
        catch (Exception e) {
            this.uploadDelegate.deletePinnedContent(hashMessageWrapper.getResourceHashMessage().hash());
            throw new UploadException(e);
        }
        return new MultisigUploadResult(new UploadResult(hashMessageWrapper.getResourceHashMessage(), publishedData), secretKey);
    }
}

