/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.publishandsubscribe;

import io.proximax.xpx.exceptions.PeerConnectionNotFoundException;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.service.intf.PublishAndSubscribeApi;
import io.proximax.xpx.service.intf.TransactionAndAnnounceApi;
import org.nem.core.crypto.CryptoEngine;
import org.nem.core.crypto.CryptoEngines;

public class PublishAndSubscribe {
    private PeerConnection peerConnection;
    private CryptoEngine engine;
    private PublishAndSubscribeApi publishAndSubscribeApi;
    private final TransactionAndAnnounceApi transactionAndAnnounceApi;
    private boolean isLocalPeerConnection = false;

    public PublishAndSubscribe(PeerConnection peerConnection) throws PeerConnectionNotFoundException {
        if (peerConnection == null) {
            throw new PeerConnectionNotFoundException("PeerConnection can't be null");
        }
        this.peerConnection = peerConnection;
        this.publishAndSubscribeApi = peerConnection.getPublishAndSubscribeApi();
        this.transactionAndAnnounceApi = peerConnection.getTransactionAndAnnounceApi();
        this.isLocalPeerConnection = peerConnection.isLocal();
        this.engine = CryptoEngines.ed25519Engine();
    }

    public void subscribeAndListenToTopic(String topic) {
    }

    public void publishTopic(String topic, String initialMessage) throws Exception {
        this.publishAndSubscribeApi.publishTopicUsingGET(topic, initialMessage);
    }

    public void sendToTopic(String topic, String message) throws Exception {
        this.publishAndSubscribeApi.sendToTopicUsingGET(topic, message);
    }

    public void sendToTopicByNemHash(String nemHash, String message) throws Exception {
        this.publishAndSubscribeApi.sendToTopicUsingGET(nemHash, message);
    }
}

