/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.search;

import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.exceptions.PeerConnectionNotFoundException;
import io.proximax.xpx.facade.AbstractFacadeService;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.model.ResourceHashMessageJsonEntity;
import io.proximax.xpx.service.intf.SearchApi;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.nem.core.crypto.CryptoEngine;
import org.nem.core.crypto.CryptoEngines;

public class Search
extends AbstractFacadeService {
    private final PeerConnection peerConnection;
    protected final CryptoEngine engine;
    protected final SearchApi searchApi;
    protected final boolean isLocalPeerConnection;

    public Search(PeerConnection peerConnection) {
        if (peerConnection == null) {
            throw new PeerConnectionNotFoundException("PeerConnection can't be null");
        }
        this.searchApi = peerConnection.getSearchApi();
        this.isLocalPeerConnection = peerConnection.isLocal();
        this.peerConnection = peerConnection;
        this.engine = CryptoEngines.ed25519Engine();
    }

    public List<ResourceHashMessageJsonEntity> searchByName(String xPvkey, String xPubkey, String name) throws ApiException, InterruptedException, ExecutionException {
        return this.searchApi.searchTransactionWithNameUsingGET(xPvkey, xPubkey, name);
    }

    public List<ResourceHashMessageJsonEntity> searchByKeyword(String xPvkey, String xPubkey, String keywords) throws ApiException, InterruptedException, ExecutionException {
        return this.searchApi.searchTransactionWithKeywordUsingGET(xPvkey, xPubkey, keywords);
    }

    public List<ResourceHashMessageJsonEntity> searchByMetaDataKeyValue(String xPvkey, String xPubkey, String key, String value) throws ApiException, InterruptedException, ExecutionException {
        return this.searchApi.searchTransactionWithMetadataKeyValuePair(xPvkey, xPubkey, key, value);
    }
}

