/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.transaction;

import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.exceptions.PeerConnectionNotFoundException;
import io.proximax.xpx.facade.AbstractFacadeService;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.service.NemTransactionApi;
import io.proximax.xpx.service.intf.AccountApi;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.nem.core.crypto.CryptoEngine;
import org.nem.core.crypto.CryptoEngines;
import org.nem.core.crypto.PublicKey;
import org.nem.core.model.Address;
import org.nem.core.model.ncc.TransactionMetaDataPair;

public class Transaction
extends AbstractFacadeService {
    private final PeerConnection peerConnection;
    private final CryptoEngine engine;
    private final AccountApi accountApi;
    protected final NemTransactionApi nemTransactionApi;
    private final boolean isLocalPeerConnection;

    public Transaction(PeerConnection peerConnection) {
        if (peerConnection == null) {
            throw new PeerConnectionNotFoundException("PeerConnection can't be null");
        }
        this.accountApi = peerConnection.getAccountApi();
        this.isLocalPeerConnection = peerConnection.isLocal();
        this.peerConnection = peerConnection;
        this.nemTransactionApi = peerConnection.getNemTransactionApi();
        this.engine = CryptoEngines.ed25519Engine();
    }

    public TransactionMetaDataPair getTransaction(String hash) throws ApiException, InterruptedException, ExecutionException {
        TransactionMetaDataPair transaction = this.nemTransactionApi.getTransaction(hash);
        return transaction;
    }

    public List<TransactionMetaDataPair> getIncomingTransactions(String publicKey) throws ApiException, InterruptedException, ExecutionException {
        ArrayList<TransactionMetaDataPair> returnListOfTxnMetaDataPair = new ArrayList<TransactionMetaDataPair>();
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getIncomingTransactions(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)publicKey)).getEncoded());
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            if (!this.checkIfTxnHaveXPXMosaic((org.nem.core.model.Transaction)metaDataPair.getEntity())) continue;
            returnListOfTxnMetaDataPair.add(metaDataPair);
        }
        return returnListOfTxnMetaDataPair;
    }

    public List<TransactionMetaDataPair> getAllTransactions(String publicKey) throws ApiException, InterruptedException, ExecutionException {
        ArrayList<TransactionMetaDataPair> returnListOfTxnMetaDataPair = new ArrayList<TransactionMetaDataPair>();
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getAllTransactions(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)publicKey)).getEncoded());
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            if (!this.checkIfTxnHaveXPXMosaic((org.nem.core.model.Transaction)metaDataPair.getEntity())) continue;
            returnListOfTxnMetaDataPair.add(metaDataPair);
        }
        return returnListOfTxnMetaDataPair;
    }

    public List<TransactionMetaDataPair> getOutgoingTransactions(String publicKey) throws ApiException, InterruptedException, ExecutionException {
        ArrayList<TransactionMetaDataPair> returnListOfTxnMetaDataPair = new ArrayList<TransactionMetaDataPair>();
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getOutgoingTransactions(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)publicKey)).getEncoded());
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            if (!this.checkIfTxnHaveXPXMosaic((org.nem.core.model.Transaction)metaDataPair.getEntity())) continue;
            returnListOfTxnMetaDataPair.add(metaDataPair);
        }
        return returnListOfTxnMetaDataPair;
    }

    public List<TransactionMetaDataPair> getUnconfirmedTransactions(String publicKey) throws ApiException, InterruptedException, ExecutionException {
        ArrayList<TransactionMetaDataPair> returnListOfTxnMetaDataPair = new ArrayList<TransactionMetaDataPair>();
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getUnconfirmedTransactions(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)publicKey)).getEncoded());
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            if (!this.checkIfTxnHaveXPXMosaic((org.nem.core.model.Transaction)metaDataPair.getEntity())) continue;
            returnListOfTxnMetaDataPair.add(metaDataPair);
        }
        return returnListOfTxnMetaDataPair;
    }
}

