/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.transaction;

import io.proximax.xpx.callback.ServiceAsyncCallback;
import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.facade.AbstractAsyncFacadeService;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.facade.transaction.Transaction;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.nem.core.model.ncc.TransactionMetaDataPair;

public class TransactionAsync
extends AbstractAsyncFacadeService {
    private Transaction transaction;

    public TransactionAsync(PeerConnection peerConnection) {
        this.transaction = new Transaction(peerConnection);
    }

    public CompletableFuture<TransactionMetaDataPair> getTransaction(String hash, ServiceAsyncCallback<TransactionMetaDataPair> callback) {
        return this.runAsync(() -> {
            try {
                return this.transaction.getTransaction(hash);
            }
            catch (ApiException | InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        }, callback);
    }

    public CompletableFuture<List<TransactionMetaDataPair>> getAllTransactions(String publicKey, ServiceAsyncCallback<List<TransactionMetaDataPair>> callback) {
        return this.runAsync(() -> {
            try {
                return this.transaction.getAllTransactions(publicKey);
            }
            catch (ApiException | InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        }, callback);
    }

    public CompletableFuture<List<TransactionMetaDataPair>> getIncomingTransactions(String publicKey, ServiceAsyncCallback<List<TransactionMetaDataPair>> callback) {
        return this.runAsync(() -> {
            try {
                return this.transaction.getIncomingTransactions(publicKey);
            }
            catch (ApiException | InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        }, callback);
    }

    public CompletableFuture<List<TransactionMetaDataPair>> getOutgoingTransactions(String publicKey, ServiceAsyncCallback<List<TransactionMetaDataPair>> callback) {
        return this.runAsync(() -> {
            try {
                return this.transaction.getOutgoingTransactions(publicKey);
            }
            catch (ApiException | InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        }, callback);
    }

    public CompletableFuture<List<TransactionMetaDataPair>> getUnconfirmedTransactions(String publicKey, ServiceAsyncCallback<List<TransactionMetaDataPair>> callback) {
        return this.runAsync(() -> {
            try {
                return this.transaction.getUnconfirmedTransactions(publicKey);
            }
            catch (ApiException | InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        }, callback);
    }
}

