/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.upload;

import io.proximax.xpx.exceptions.KeywordsAboveMaxLengthLimitException;
import io.proximax.xpx.exceptions.MetadataAboveMaxLengthLimitException;
import io.proximax.xpx.strategy.privacy.PrivacyStrategy;
import io.proximax.xpx.strategy.privacy.PrivacyStrategyFactory;
import io.proximax.xpx.utils.JsonUtils;
import java.util.Map;
import org.nem.core.model.mosaic.Mosaic;

public abstract class AbstractUploadParameter {
    public static final int MAX_LENGTH_ALLOWED_FOR_METADATA = 400;
    public static final int MAX_LENGTH_ALLOWED_FOR_KEYWORDS = 80;
    private String senderPrivateKey;
    private String receiverPublicKey;
    private String contentType;
    private String name;
    private String keywords;
    private String metaData;
    private Mosaic[] mosaics;
    private PrivacyStrategy privacyStrategy = PrivacyStrategyFactory.plainPrivacy();

    public String getSenderPrivateKey() {
        return this.senderPrivateKey;
    }

    public void setSenderPrivateKey(String senderPrivateKey) {
        this.senderPrivateKey = senderPrivateKey;
    }

    public String getReceiverPublicKey() {
        return this.receiverPublicKey;
    }

    public void setReceiverPublicKey(String receiverPublicKey) {
        this.receiverPublicKey = receiverPublicKey;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        if (keywords != null && keywords.length() > 80) {
            throw new KeywordsAboveMaxLengthLimitException(String.format("The provided keywords exceeds the maximum %d characters allowed: %s", 80, keywords));
        }
        this.keywords = keywords;
    }

    public String getMetaDataAsString() {
        return this.metaData;
    }

    public void setMetaData(Map<String, String> metaData) {
        if (metaData != null) {
            String metadataAsString = JsonUtils.toJson(metaData);
            if (metadataAsString.length() > 400) {
                throw new MetadataAboveMaxLengthLimitException(String.format("The provided metadata exceeds the maximum %d characters allowed: %s", 400, metadataAsString));
            }
            this.metaData = metadataAsString;
        } else {
            this.metaData = null;
        }
    }

    public Mosaic[] getMosaics() {
        return this.mosaics == null ? new Mosaic[]{} : this.mosaics;
    }

    public void setMosaics(Mosaic[] mosaics) {
        this.mosaics = mosaics;
    }

    public void addMosaic(Mosaic mosaic) {
        this.mosaics[this.mosaics.length - 1] = mosaic;
    }

    public PrivacyStrategy getPrivacyStrategy() {
        return this.privacyStrategy;
    }

    public void setPrivacyStrategy(PrivacyStrategy privacyStrategy) {
        this.privacyStrategy = privacyStrategy;
    }
}

