/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.upload;

import io.proximax.xpx.builder.steps.CommonUploadBuildSteps;
import io.proximax.xpx.builder.steps.ReceiverPublicKeyStep;
import io.proximax.xpx.builder.steps.SenderPrivateKeyStep;
import io.proximax.xpx.facade.upload.AbstractUploadParameter;
import io.proximax.xpx.strategy.privacy.PrivacyStrategy;
import io.proximax.xpx.strategy.privacy.PrivacyStrategyFactory;
import io.proximax.xpx.strategy.privacy.SecuredWithShamirSecretSharingPrivacyStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nem.core.model.mosaic.Mosaic;

public abstract class AbstractUploadParameterBuilder<NextBuildStepAfterPublicKey, FinalBuildSteps>
implements CommonUploadBuildSteps<FinalBuildSteps>,
SenderPrivateKeyStep,
ReceiverPublicKeyStep {
    protected AbstractUploadParameter instance;

    protected AbstractUploadParameterBuilder(AbstractUploadParameter instance) {
        this.instance = instance;
    }

    @Override
    public FinalBuildSteps mosaics(Mosaic ... mosaics) {
        this.instance.setMosaics(mosaics);
        return (FinalBuildSteps)this;
    }

    @Override
    public FinalBuildSteps keywords(String keywords) {
        this.instance.setKeywords(keywords);
        return (FinalBuildSteps)this;
    }

    @Override
    public FinalBuildSteps metadata(Map<String, String> metadata) {
        this.instance.setMetaData(metadata);
        return (FinalBuildSteps)this;
    }

    @Override
    public FinalBuildSteps privacyStrategy(PrivacyStrategy privacyStrategy) {
        this.instance.setPrivacyStrategy(privacyStrategy);
        return (FinalBuildSteps)this;
    }

    @Override
    public FinalBuildSteps plainPrivacy() {
        this.instance.setPrivacyStrategy(PrivacyStrategyFactory.plainPrivacy());
        return (FinalBuildSteps)this;
    }

    @Override
    public FinalBuildSteps securedWithNemKeysPrivacyStrategy() {
        this.instance.setPrivacyStrategy(PrivacyStrategyFactory.securedWithNemKeysPrivacyStrategy(this.instance.getSenderPrivateKey(), this.instance.getReceiverPublicKey()));
        return (FinalBuildSteps)this;
    }

    @Override
    public FinalBuildSteps securedWithPasswordPrivacyStrategy(String password) {
        this.instance.setPrivacyStrategy(PrivacyStrategyFactory.securedWithPasswordPrivacyStrategy(password));
        return (FinalBuildSteps)this;
    }

    @Override
    public FinalBuildSteps securedWithShamirSecretSharingPrivacyStrategy(int secretTotalPartCount, int secretMinimumPartCountToBuild, SecuredWithShamirSecretSharingPrivacyStrategy.SecretPart ... secretParts) {
        this.instance.setPrivacyStrategy(PrivacyStrategyFactory.securedWithShamirSecretSharingPrivacyStrategy(secretTotalPartCount, secretMinimumPartCountToBuild, Stream.of(secretParts).collect(Collectors.toMap(parts -> parts.index, parts -> parts.secretPart))));
        return (FinalBuildSteps)this;
    }

    @Override
    public FinalBuildSteps securedWithShamirSecretSharingPrivacyStrategy(int secretTotalPartCount, int secretMinimumPartCountToBuild, List<SecuredWithShamirSecretSharingPrivacyStrategy.SecretPart> secretParts) {
        this.instance.setPrivacyStrategy(PrivacyStrategyFactory.securedWithShamirSecretSharingPrivacyStrategy(secretTotalPartCount, secretMinimumPartCountToBuild, secretParts == null ? Collections.emptyMap() : secretParts.stream().collect(Collectors.toMap(parts -> parts.index, parts -> parts.secretPart))));
        return (FinalBuildSteps)this;
    }

    @Override
    public FinalBuildSteps securedWithShamirSecretSharingPrivacyStrategy(int secretTotalPartCount, int secretMinimumPartCountToBuild, Map<Integer, byte[]> secretParts) {
        this.instance.setPrivacyStrategy(PrivacyStrategyFactory.securedWithShamirSecretSharingPrivacyStrategy(secretTotalPartCount, secretMinimumPartCountToBuild, secretParts == null ? Collections.emptyMap() : secretParts));
        return (FinalBuildSteps)this;
    }

    public ReceiverPublicKeyStep senderPrivateKey(String senderPrivateKeyStep) {
        this.instance.setSenderPrivateKey(senderPrivateKeyStep);
        return this;
    }

    public NextBuildStepAfterPublicKey receiverPublicKey(String receiverPublicKey) {
        this.instance.setReceiverPublicKey(receiverPublicKey);
        return (NextBuildStepAfterPublicKey)this;
    }
}

