/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.upload;

import io.proximax.xpx.facade.upload.UploadException;
import io.proximax.xpx.facade.upload.UploadResult;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class MultiFileUploadResult {
    private List<FileUploadResult> fileUploadResults;

    public MultiFileUploadResult(List<FileUploadResult> fileUploadResults) {
        this.fileUploadResults = fileUploadResults == null ? Collections.emptyList() : Collections.unmodifiableList(fileUploadResults);
    }

    public List<FileUploadResult> getFileUploadResults() {
        return this.fileUploadResults;
    }

    public boolean hasFailure() {
        return this.fileUploadResults.stream().anyMatch(result -> ((FileUploadResult)result).uploadException != null);
    }

    public static class FileUploadResult {
        private File file;
        private UploadResult uploadResult;
        private UploadException uploadException;

        public FileUploadResult(File file, UploadResult uploadResult) {
            this.file = file;
            this.uploadResult = uploadResult;
        }

        public FileUploadResult(File file, UploadException uploadException) {
            this.file = file;
            this.uploadException = uploadException;
        }

        public File getFile() {
            return this.file;
        }

        public UploadResult getUploadResult() {
            return this.uploadResult;
        }

        public UploadException getUploadException() {
            return this.uploadException;
        }
    }
}

