/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.upload;

import io.proximax.xpx.exceptions.PeerConnectionNotFoundException;
import io.proximax.xpx.facade.AbstractFacadeService;
import io.proximax.xpx.facade.connection.PeerConnection;
import io.proximax.xpx.facade.upload.MultiFileUploadResult;
import io.proximax.xpx.facade.upload.UploadBinaryParameter;
import io.proximax.xpx.facade.upload.UploadException;
import io.proximax.xpx.facade.upload.UploadFileParameter;
import io.proximax.xpx.facade.upload.UploadFilesAsZipParameter;
import io.proximax.xpx.facade.upload.UploadFromUrlParameter;
import io.proximax.xpx.facade.upload.UploadMultipleFilesParameter;
import io.proximax.xpx.facade.upload.UploadPathParameter;
import io.proximax.xpx.facade.upload.UploadResult;
import io.proximax.xpx.facade.upload.UploadTextDataParameter;
import io.proximax.xpx.service.IpfsGatewaySyncService;
import io.proximax.xpx.service.TransactionAnnouncer;
import io.proximax.xpx.service.UploadDelegate;
import io.proximax.xpx.service.intf.UploadApi;
import io.proximax.xpx.strategy.privacy.PrivacyStrategy;
import io.proximax.xpx.utils.ContentTypeUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nem.core.model.Message;
import org.nem.core.model.mosaic.Mosaic;

public class Upload
extends AbstractFacadeService {
    private final PeerConnection peerConnection;
    private final UploadApi uploadApi;
    private final TransactionAnnouncer transactionAnnouncer;
    private final UploadDelegate uploadDelegate;
    private final IpfsGatewaySyncService ipfsGatewaySyncService;

    public Upload(PeerConnection peerConnection) {
        if (peerConnection == null) {
            throw new PeerConnectionNotFoundException("PeerConnection can't be null");
        }
        this.uploadApi = peerConnection.getUploadApi();
        this.transactionAnnouncer = peerConnection.getTransactionAnnouncer();
        this.peerConnection = peerConnection;
        this.uploadDelegate = new UploadDelegate(peerConnection.getUploadApi());
        this.ipfsGatewaySyncService = new IpfsGatewaySyncService(peerConnection.getSyncGateways());
    }

    public UploadResult uploadFile(UploadFileParameter param) throws UploadException {
        try {
            byte[] binaryContent = FileUtils.readFileToByteArray((File)param.getFile());
            return this.handleBinaryUpload(param.getPrivacyStrategy(), param.getSenderPrivateKey(), param.getReceiverPublicKey(), param.getContentType(), param.getKeywords(), param.getMetaDataAsString(), param.getName(), param.getMosaics(), binaryContent);
        }
        catch (UploadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UploadException(String.format("Error on uploading file data: %s", param.getFile().getAbsolutePath()), e);
        }
    }

    public UploadResult uploadTextData(UploadTextDataParameter param) throws UploadException {
        return this.handleTextDataUpload(param.getPrivacyStrategy(), param.getSenderPrivateKey(), param.getReceiverPublicKey(), param.getContentType(), param.getKeywords(), param.getMetaDataAsString(), param.getName(), param.getMosaics(), param.getData(), param.getEncoding());
    }

    public UploadResult uploadBinary(UploadBinaryParameter param) throws UploadException {
        try {
            return this.handleBinaryUpload(param.getPrivacyStrategy(), param.getSenderPrivateKey(), param.getReceiverPublicKey(), param.getContentType(), param.getKeywords(), param.getMetaDataAsString(), param.getName(), param.getMosaics(), param.getData());
        }
        catch (UploadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UploadException("Error on uploading binary data", e);
        }
    }

    public UploadResult uploadPath(UploadPathParameter param) throws UploadException {
        try {
            UploadDelegate.ResourceHashMessageWrapper resourceHashMessageWrapper = this.uploadDelegate.uploadPathToIpfs(param.getPath(), param.getName(), param.getKeywords(), param.getMetaDataAsString());
            return this.handlePostUpload(param.getPrivacyStrategy(), param.getSenderPrivateKey(), param.getReceiverPublicKey(), param.getMosaics(), resourceHashMessageWrapper);
        }
        catch (UploadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UploadException(String.format("Error on uploading path: %s", param.getPath()), e);
        }
    }

    public UploadResult uploadFilesAsZip(UploadFilesAsZipParameter param) throws UploadException {
        try {
            byte[] binaryContent = this.zipFiles(param.getFiles());
            return this.handleBinaryUpload(param.getPrivacyStrategy(), param.getSenderPrivateKey(), param.getReceiverPublicKey(), param.getContentType(), param.getKeywords(), param.getMetaDataAsString(), param.getName(), param.getMosaics(), binaryContent);
        }
        catch (UploadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UploadException("Error on uploading files as zip", e);
        }
    }

    public MultiFileUploadResult uploadMultipleFiles(UploadMultipleFilesParameter param) throws UploadException {
        if (param.getFiles().size() == 0) {
            throw new UploadException("No file to upload");
        }
        List<MultiFileUploadResult.FileUploadResult> fileUploadResults = param.getFiles().parallelStream().map(file -> {
            try {
                byte[] binaryContent = FileUtils.readFileToByteArray((File)file);
                return new MultiFileUploadResult.FileUploadResult((File)file, this.handleBinaryUpload(param.getPrivacyStrategy(), param.getSenderPrivateKey(), param.getReceiverPublicKey(), ContentTypeUtils.detectContentType(binaryContent), param.getKeywords(), param.getMetaDataAsString(), file.getName(), param.getMosaics(), binaryContent));
            }
            catch (Exception e) {
                return new MultiFileUploadResult.FileUploadResult((File)file, new UploadException(String.format("Error on uploading file data: %s", file.getAbsolutePath()), e));
            }
        }).collect(Collectors.toList());
        return new MultiFileUploadResult(fileUploadResults);
    }

    public UploadResult uploadFromUrl(UploadFromUrlParameter param) throws UploadException {
        try {
            byte[] downloadedBinary = IOUtils.toByteArray((URL)param.getUrl());
            String contentTypeOrDetected = param.getContentType() != null ? param.getContentType() : ContentTypeUtils.detectContentType(downloadedBinary);
            return this.handleBinaryUpload(param.getPrivacyStrategy(), param.getSenderPrivateKey(), param.getReceiverPublicKey(), contentTypeOrDetected, param.getKeywords(), param.getMetaDataAsString(), param.getName(), param.getMosaics(), downloadedBinary);
        }
        catch (UploadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UploadException(String.format("Error on uploading from URL: %s", param.getUrl().toString()), e);
        }
    }

    private UploadResult handleTextDataUpload(PrivacyStrategy privacyStrategy, String senderPrivateKey, String receiverPublicKey, String contentType, String keywords, String metadata, String name, Mosaic[] mosaics, String textData, String encoding) throws UploadException {
        try {
            byte[] textInBytes = textData.getBytes(encoding);
            byte[] encryptedTextInBytes = privacyStrategy.encrypt(textInBytes);
            UploadDelegate.ResourceHashMessageWrapper hashMessageWrapper = this.uploadDelegate.uploadTextToIpfs(encryptedTextInBytes, name, contentType, encoding, keywords, metadata);
            return this.handlePostUpload(privacyStrategy, senderPrivateKey, receiverPublicKey, mosaics, hashMessageWrapper);
        }
        catch (UploadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UploadException("Error on uploading text data", e);
        }
    }

    private UploadResult handleBinaryUpload(PrivacyStrategy privacyStrategy, String senderPrivateKey, String receiverPublicKey, String contentType, String keywords, String metadata, String name, Mosaic[] mosaics, byte[] binaryContent) throws UploadException {
        try {
            byte[] encryptedContent = privacyStrategy.encrypt(binaryContent);
            UploadDelegate.ResourceHashMessageWrapper hashMessageWrapper = this.uploadDelegate.uploadBinaryToIpfs(encryptedContent, name, contentType, keywords, metadata);
            return this.handlePostUpload(privacyStrategy, senderPrivateKey, receiverPublicKey, mosaics, hashMessageWrapper);
        }
        catch (UploadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UploadException("Error on uploading binary data", e);
        }
    }

    private byte[] zipFiles(List<File> files) throws UploadException {
        this.validateZipFilesArguments(files);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            for (File file2 : files) {
                ZipEntry entry = new ZipEntry(file2.getName());
                zos.putNextEntry(entry);
                zos.write(FileUtils.readFileToByteArray((File)file2));
                zos.closeEntry();
            }
        }
        catch (IOException e) {
            throw new UploadException(String.format("Unable to zip files together: %s", String.join((CharSequence)",", files.stream().map(file -> file.getAbsolutePath()).collect(Collectors.toList()))), e);
        }
        return baos.toByteArray();
    }

    private void validateZipFilesArguments(List<File> files) throws UploadException {
        if (files.size() == 0) {
            throw new UploadException("No file to upload");
        }
        long uniqueFileNameCount = files.stream().map(file -> file.getName()).distinct().count();
        if (uniqueFileNameCount < (long)files.size()) {
            throw new UploadException(String.format("File names should be unique to zip files together: %s", String.join((CharSequence)",", files.stream().map(file -> file.getName()).collect(Collectors.toList()))));
        }
    }

    private UploadResult handlePostUpload(PrivacyStrategy privacyStrategy, String senderPrivateKey, String receiverPublicKey, Mosaic[] mosaics, UploadDelegate.ResourceHashMessageWrapper hashMessageWrapper) throws Exception {
        try {
            String nemHash = this.createNemTransaction(privacyStrategy, senderPrivateKey, receiverPublicKey, mosaics, hashMessageWrapper.getData());
            this.ipfsGatewaySyncService.syncToGatewaysAsynchronously(hashMessageWrapper.getResourceHashMessage().hash());
            return new UploadResult(hashMessageWrapper.getResourceHashMessage(), nemHash);
        }
        catch (Exception e) {
            Executors.newSingleThreadExecutor().submit(() -> this.uploadDelegate.deletePinnedContent(hashMessageWrapper.getResourceHashMessage().hash()));
            throw e;
        }
    }

    private String createNemTransaction(PrivacyStrategy privacyStrategy, String senderPrivateKey, String receiverPublicKey, Mosaic[] mosaics, byte[] response) throws Exception {
        Message nemMessage = privacyStrategy.encodeToMessage(response);
        return this.transactionAnnouncer.announceTransactionForUploadedContent(nemMessage, senderPrivateKey, receiverPublicKey, mosaics);
    }
}

