/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.upload;

import io.proximax.xpx.builder.steps.BinaryDataStep;
import io.proximax.xpx.builder.steps.CommonUploadBuildSteps;
import io.proximax.xpx.builder.steps.ContentTypeStep;
import io.proximax.xpx.builder.steps.NameStep;
import io.proximax.xpx.builder.steps.ReceiverPublicKeyStep;
import io.proximax.xpx.builder.steps.SenderPrivateKeyStep;
import io.proximax.xpx.facade.upload.AbstractUploadParameter;
import io.proximax.xpx.facade.upload.AbstractUploadParameterBuilder;
import io.proximax.xpx.utils.ContentTypeUtils;
import io.proximax.xpx.utils.StringUtils;
import java.io.Serializable;

public class UploadBinaryParameter
extends AbstractUploadParameter
implements Serializable {
    private byte[] data;

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public static SenderPrivateKeyStep<ReceiverPublicKeyStep<BinaryDataStep<FinalBuildSteps>>> create() {
        return new Builder();
    }

    public static class Builder
    extends AbstractUploadParameterBuilder<BinaryDataStep, FinalBuildSteps>
    implements BinaryDataStep,
    FinalBuildSteps {
        protected UploadBinaryParameter instance;

        private Builder() {
            super(new UploadBinaryParameter());
            this.instance = (UploadBinaryParameter)((AbstractUploadParameterBuilder)this).instance;
        }

        protected Builder(UploadBinaryParameter instance) {
            super(instance);
            this.instance = instance;
        }

        public FinalBuildSteps data(byte[] data) {
            this.instance.setData(data);
            return this;
        }

        @Override
        public FinalBuildSteps contentType(String contentType) {
            this.instance.setContentType(contentType);
            return this;
        }

        @Override
        public FinalBuildSteps name(String name) {
            this.instance.setName(name);
            return this;
        }

        @Override
        public UploadBinaryParameter build() {
            if (StringUtils.isEmpty(this.instance.getContentType())) {
                this.instance.setContentType(ContentTypeUtils.detectContentType(this.instance.data));
            }
            return this.instance;
        }
    }

    public static interface FinalBuildSteps
    extends ContentTypeStep<FinalBuildSteps>,
    NameStep<FinalBuildSteps>,
    CommonUploadBuildSteps<FinalBuildSteps> {
        public UploadBinaryParameter build();
    }
}

