/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.facade.upload;

import io.proximax.xpx.builder.steps.CommonUploadBuildSteps;
import io.proximax.xpx.builder.steps.ContentTypeStep;
import io.proximax.xpx.builder.steps.FileNameStep;
import io.proximax.xpx.builder.steps.FileStep;
import io.proximax.xpx.builder.steps.ReceiverPublicKeyStep;
import io.proximax.xpx.builder.steps.SenderPrivateKeyStep;
import io.proximax.xpx.facade.upload.AbstractUploadParameter;
import io.proximax.xpx.facade.upload.AbstractUploadParameterBuilder;
import io.proximax.xpx.utils.ContentTypeUtils;
import io.proximax.xpx.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;

public class UploadFileParameter
extends AbstractUploadParameter
implements Serializable {
    private File file;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public static SenderPrivateKeyStep<ReceiverPublicKeyStep<FileStep<FinalBuildSteps>>> create() {
        return new Builder();
    }

    public static class Builder
    extends AbstractUploadParameterBuilder<FileStep, FinalBuildSteps>
    implements FileStep,
    FinalBuildSteps {
        protected UploadFileParameter instance;

        private Builder() {
            super(new UploadFileParameter());
            this.instance = (UploadFileParameter)((AbstractUploadParameterBuilder)this).instance;
        }

        protected Builder(UploadFileParameter instance) {
            super(instance);
            this.instance = instance;
        }

        public FinalBuildSteps file(File file) {
            this.instance.setFile(file);
            return this;
        }

        @Override
        public FinalBuildSteps fileName(String fileName) {
            this.instance.setName(fileName);
            return this;
        }

        @Override
        public FinalBuildSteps contentType(String contentType) {
            this.instance.setContentType(contentType);
            return this;
        }

        @Override
        public UploadFileParameter build() throws IOException {
            if (StringUtils.isEmpty(this.instance.getName())) {
                this.instance.setName(this.instance.getFile().getName());
            }
            if (StringUtils.isEmpty(this.instance.getContentType())) {
                this.instance.setContentType(ContentTypeUtils.detectContentType(FileUtils.readFileToByteArray((File)this.instance.getFile())));
            }
            return this.instance;
        }
    }

    public static interface FinalBuildSteps
    extends FileNameStep<FinalBuildSteps>,
    ContentTypeStep<FinalBuildSteps>,
    CommonUploadBuildSteps<FinalBuildSteps> {
        public UploadFileParameter build() throws IOException;
    }
}

