/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.factory;

import io.ipfs.api.IPFS;
import io.ipfs.multiaddr.MultiAddress;
import org.nem.core.connect.ErrorResponseDeserializerUnion;
import org.nem.core.connect.HttpMethodClient;
import org.nem.core.connect.client.DefaultAsyncNemConnector;
import org.nem.core.model.Account;
import org.nem.core.model.NetworkInfo;
import org.nem.core.model.NetworkInfos;
import org.nem.core.node.ApiId;
import org.nem.core.node.NodeEndpoint;

public class ConnectionFactory {
    private static final HttpMethodClient<ErrorResponseDeserializerUnion> CLIENT = ConnectionFactory.createHttpMethodClient();

    public static DefaultAsyncNemConnector<ApiId> createConnector() {
        DefaultAsyncNemConnector connector = new DefaultAsyncNemConnector(CLIENT, r -> {
            throw new RuntimeException(r.toString());
        });
        connector.setAccountLookup(Account::new);
        return connector;
    }

    public static NodeEndpoint createNemNodeConnection(String network, String protocol, String domainOrIp, int port, String wsPort) {
        ConnectionFactory.setNetwork(network);
        return new NodeEndpoint(protocol, domainOrIp, port);
    }

    public static NodeEndpoint createNemNodeConnection(String network, String protocol, String domainOrIp, int port) {
        ConnectionFactory.setNetwork(network);
        return new NodeEndpoint(protocol, domainOrIp, port);
    }

    public static IPFS createIPFSNodeConnection(String multiAddress) {
        return new IPFS(new MultiAddress(multiAddress));
    }

    public static void setNetwork(String network) {
        NetworkInfo networkInfo = NetworkInfos.getTestNetworkInfo();
        if (network.equals("mainnet")) {
            networkInfo = NetworkInfos.getMainNetworkInfo();
        } else if (network.equals("mijinnet")) {
            networkInfo = NetworkInfos.getMijinNetworkInfo();
        }
        NetworkInfos.setDefault((NetworkInfo)networkInfo);
    }

    private static HttpMethodClient<ErrorResponseDeserializerUnion> createHttpMethodClient() {
        int connectionTimeout = 4000;
        int socketTimeout = 10000;
        int requestTimeout = 30000;
        return new HttpMethodClient(4000, 10000, 30000);
    }
}

