/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service;

import io.proximax.xpx.service.HttpClient;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.pmw.tinylog.Logger;

public class IpfsGatewaySyncService {
    private List<String> syncGateways;
    private ExecutorService executor;
    private HttpClient httpClient;

    public IpfsGatewaySyncService(List<String> syncGateways) {
        this(syncGateways, new HttpClient());
    }

    IpfsGatewaySyncService(List<String> syncGateways, HttpClient httpClient) {
        this.syncGateways = syncGateways;
        this.executor = Executors.newCachedThreadPool();
        this.httpClient = httpClient;
    }

    public void syncToGatewaysAsynchronously(String dataHash) {
        if (this.syncGateways == null || this.syncGateways.isEmpty()) {
            return;
        }
        this.executor.submit(() -> this.syncGateways.forEach(gateway -> {
            try {
                URL gatewayUrl = new URL(gateway + "/ipfs/" + dataHash);
                this.httpClient.head(gatewayUrl);
            }
            catch (IOException e) {
                Logger.error((String)String.format("Error syncing to gateways %s for hash %s", gateway, dataHash), (Object[])new Object[]{e});
            }
        }));
    }
}

