/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service;

import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.model.GeneratedAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.nem.core.connect.client.DefaultAsyncNemConnector;
import org.nem.core.connect.client.NisApiId;
import org.nem.core.crypto.KeyPair;
import org.nem.core.model.Account;
import org.nem.core.model.mosaic.Mosaic;
import org.nem.core.model.ncc.AccountMetaDataPair;
import org.nem.core.model.ncc.HarvestInfo;
import org.nem.core.node.ApiId;
import org.nem.core.node.NodeEndpoint;
import org.nem.core.serialization.Deserializer;

public class NemAccountApi {
    private final NodeEndpoint nodeEndpoint;
    private DefaultAsyncNemConnector<ApiId> asyncNemConnector;

    public NemAccountApi(NodeEndpoint nodeEndpoint, DefaultAsyncNemConnector<ApiId> asyncNemConnector) {
        this.nodeEndpoint = nodeEndpoint;
        this.asyncNemConnector = asyncNemConnector;
    }

    public AccountMetaDataPair getAccountByAddress(String address) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)((CompletableFuture)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_LOOK_UP, "address=" + address).exceptionally(fn -> {
            fn.printStackTrace();
            return null;
        })).get();
        return new AccountMetaDataPair(des);
    }

    public List<Mosaic> getAccountOwnedMosaic(String address) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_MOSAIC_OWNED, "address=" + address).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", Mosaic::new);
        return list;
    }

    public List<HarvestInfo> getAccountHarvestInfo(String address) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_HARVESTS, "address=" + address).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", HarvestInfo::new);
        return list;
    }

    public GeneratedAccount generateAccount() {
        GeneratedAccount ga = new GeneratedAccount();
        KeyPair kp = new KeyPair();
        Account account = new Account(kp);
        ga.setKeyPair(kp);
        ga.setAccount(account);
        ga.setEncodedAddress(account.getAddress().getEncoded());
        ga.setEncodedPrivateKey(kp.getPrivateKey().toString());
        ga.setEncodedPublicKey(kp.getPublicKey().toString());
        return ga;
    }
}

