/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.nem.core.connect.client.DefaultAsyncNemConnector;
import org.nem.core.connect.client.NisApiId;
import org.nem.core.model.mosaic.MosaicDefinition;
import org.nem.core.model.namespace.Namespace;
import org.nem.core.model.ncc.MosaicDefinitionMetaDataPair;
import org.nem.core.model.ncc.NamespaceMetaDataPair;
import org.nem.core.node.ApiId;
import org.nem.core.node.NodeEndpoint;
import org.nem.core.serialization.Deserializer;

public class NemNamespaceAndMosaicsApi {
    private final NodeEndpoint nodeEndpoint;
    private DefaultAsyncNemConnector<ApiId> asyncNemConnector;

    public NemNamespaceAndMosaicsApi(NodeEndpoint nodeEndpoint, DefaultAsyncNemConnector<ApiId> asyncNemConnector) {
        this.nodeEndpoint = nodeEndpoint;
        this.asyncNemConnector = asyncNemConnector;
    }

    public List<NamespaceMetaDataPair> getNamespaceRootPage() throws InterruptedException, ExecutionException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_NAMESPACE_ROOT_PAGE, "").get();
        ArrayList list = (ArrayList)des.readObjectArray("data", NamespaceMetaDataPair::new);
        return list;
    }

    public List<NamespaceMetaDataPair> getNamespaceRootPage(String id) throws InterruptedException, ExecutionException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_NAMESPACE_ROOT_PAGE, "id=" + id).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", NamespaceMetaDataPair::new);
        return list;
    }

    public List<NamespaceMetaDataPair> getNamespaceRootPage(String id, String pageSize) throws InterruptedException, ExecutionException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_NAMESPACE_ROOT_PAGE, "id=" + id + "&pagesize=" + pageSize).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", NamespaceMetaDataPair::new);
        return list;
    }

    public Namespace getNamespace(String namespace) throws InterruptedException, ExecutionException {
        Deserializer des = (Deserializer)((CompletableFuture)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_NAMESPACE, "namespace=" + namespace).exceptionally(fn -> {
            fn.printStackTrace();
            return null;
        })).get();
        return new Namespace(des);
    }

    public List<MosaicDefinitionMetaDataPair> getNamespaceMosaicDefinitionPage(String namespace) throws InterruptedException, ExecutionException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_NAMESPACE_MOSAIC_DEFINITION_PAGE, "namespace=" + namespace).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", MosaicDefinitionMetaDataPair::new);
        return list;
    }

    public List<MosaicDefinitionMetaDataPair> getNamespaceMosaicDefinitionPage(String namespace, String id) throws InterruptedException, ExecutionException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_NAMESPACE_MOSAIC_DEFINITION_PAGE, "namespace=" + namespace + "&id=" + id).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", MosaicDefinitionMetaDataPair::new);
        return list;
    }

    public List<MosaicDefinitionMetaDataPair> getNamespaceMosaicDefinitionPage(String namespace, String id, String pageSize) throws InterruptedException, ExecutionException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_NAMESPACE_MOSAIC_DEFINITION_PAGE, "namespace=" + namespace + "&id=" + id + "&pagesize=" + pageSize).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", MosaicDefinitionMetaDataPair::new);
        return list;
    }

    public MosaicDefinition getMosaicInformation(String namespace, String mosaic) throws InterruptedException, ExecutionException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_NAMESPACE_MOSAIC_DEFINITION_PAGE, "namespace=" + namespace).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", MosaicDefinitionMetaDataPair::new);
        for (MosaicDefinitionMetaDataPair mosaicDefinitionMetadataPair : list) {
            if (!((MosaicDefinition)mosaicDefinitionMetadataPair.getEntity()).getId().getName().equals(mosaic)) continue;
            return (MosaicDefinition)mosaicDefinitionMetadataPair.getEntity();
        }
        return null;
    }
}

