/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service;

import io.proximax.xpx.exceptions.ApiException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.nem.core.connect.HttpJsonPostRequest;
import org.nem.core.connect.HttpPostRequest;
import org.nem.core.connect.client.DefaultAsyncNemConnector;
import org.nem.core.connect.client.NisApiId;
import org.nem.core.model.ncc.NemAnnounceResult;
import org.nem.core.model.ncc.RequestAnnounce;
import org.nem.core.model.ncc.TransactionMetaDataPair;
import org.nem.core.node.ApiId;
import org.nem.core.node.NodeEndpoint;
import org.nem.core.serialization.Deserializer;
import org.nem.core.serialization.SerializableEntity;

public class NemTransactionApi {
    private final NodeEndpoint nodeEndpoint;
    private DefaultAsyncNemConnector<ApiId> asyncNemConnector;

    public NemTransactionApi(NodeEndpoint nodeEndpoint, DefaultAsyncNemConnector<ApiId> asyncNemConnector) {
        this.nodeEndpoint = nodeEndpoint;
        this.asyncNemConnector = asyncNemConnector;
    }

    public TransactionMetaDataPair getTransaction(String hash) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_TRANSACTION_GET, "hash=" + hash).get();
        TransactionMetaDataPair trans = new TransactionMetaDataPair(des);
        return trans;
    }

    public List<TransactionMetaDataPair> getAllTransactions(String address) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_TRANSFERS_ALL, "address=" + address).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", TransactionMetaDataPair::new);
        return list;
    }

    public List<TransactionMetaDataPair> getAllTransactionsWithPageSize(String address, String pageSize) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_TRANSFERS_ALL, "address=" + address + "&pageSize=" + pageSize).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", TransactionMetaDataPair::new);
        return list;
    }

    public List<TransactionMetaDataPair> getAllTransactions(String address, String hash) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_TRANSFERS_ALL, "address=" + address + "&hash=" + hash).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", TransactionMetaDataPair::new);
        return list;
    }

    public List<TransactionMetaDataPair> getAllTransactions(String address, String hash, String id) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_TRANSFERS_ALL, "address=" + address + "&hash=" + hash + "&id=" + id).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", TransactionMetaDataPair::new);
        return list;
    }

    public List<TransactionMetaDataPair> getIncomingTransactions(String address) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_TRANSFERS_INCOMING, "address=" + address).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", TransactionMetaDataPair::new);
        return list;
    }

    public List<TransactionMetaDataPair> getIncomingTransactions(String address, String hash) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_TRANSFERS_INCOMING, "address=" + address + "&hash=" + hash).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", TransactionMetaDataPair::new);
        return list;
    }

    public List<TransactionMetaDataPair> getIncomingTransactions(String address, String hash, String id) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_TRANSFERS_INCOMING, "address=" + address + "&hash=" + hash + "&id=" + id).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", TransactionMetaDataPair::new);
        return list;
    }

    public List<TransactionMetaDataPair> getOutgoingTransactions(String address) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_TRANSFERS_OUTGOING, "address=" + address).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", TransactionMetaDataPair::new);
        return list;
    }

    public List<TransactionMetaDataPair> getOutgoingTransactions(String address, String hash) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_TRANSFERS_OUTGOING, "address=" + address + "&hash=" + hash).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", TransactionMetaDataPair::new);
        return list;
    }

    public List<TransactionMetaDataPair> getOutgoingTransactions(String address, String hash, String id) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_TRANSFERS_OUTGOING, "address=" + address + "&hash=" + hash + "&id=" + id).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", TransactionMetaDataPair::new);
        return list;
    }

    public List<TransactionMetaDataPair> getUnconfirmedTransactions(String address) throws InterruptedException, ExecutionException, ApiException {
        Deserializer des = (Deserializer)this.asyncNemConnector.getAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_ACCOUNT_UNCONFIRMED, "address=" + address).get();
        ArrayList list = (ArrayList)des.readObjectArray("data", TransactionMetaDataPair::new);
        return list;
    }

    public NemAnnounceResult sendTransferTransaction(byte[] data, byte[] signature) throws InterruptedException, ExecutionException, ApiException {
        RequestAnnounce request = new RequestAnnounce(data, signature);
        CompletableFuture<Deserializer> future = this.announceTransaction(request);
        Deserializer transDes = future.get();
        return new NemAnnounceResult(transDes);
    }

    public CompletableFuture<Deserializer> announceTransaction(RequestAnnounce request) {
        CompletableFuture des = this.asyncNemConnector.postAsync(this.nodeEndpoint, (Object)NisApiId.NIS_REST_TRANSACTION_ANNOUNCE, (HttpPostRequest)new HttpJsonPostRequest((SerializableEntity)request));
        return des;
    }
}

