/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service;

import io.proximax.xpx.builder.TransferTransactionBuilder;
import io.proximax.xpx.exceptions.AnnounceTransactionFailureException;
import io.proximax.xpx.service.TransactionFeeCalculators;
import io.proximax.xpx.service.TransactionSender;
import org.nem.core.crypto.KeyPair;
import org.nem.core.crypto.PrivateKey;
import org.nem.core.crypto.PublicKey;
import org.nem.core.model.Account;
import org.nem.core.model.Address;
import org.nem.core.model.Message;
import org.nem.core.model.TransferTransaction;
import org.nem.core.model.mosaic.Mosaic;
import org.nem.core.model.mosaic.MosaicId;
import org.nem.core.model.namespace.NamespaceId;
import org.nem.core.model.ncc.NemAnnounceResult;
import org.nem.core.model.primitive.Amount;
import org.nem.core.model.primitive.Quantity;

public class TransactionAnnouncer {
    private final TransactionFeeCalculators transactionFeeCalculators;
    private final TransactionSender transactionSender;

    public TransactionAnnouncer(TransactionFeeCalculators transactionFeeCalculators, TransactionSender transactionSender) {
        this.transactionFeeCalculators = transactionFeeCalculators;
        this.transactionSender = transactionSender;
    }

    public String announceTransactionForUploadedContent(Message nemMessage, String senderPrivateKey, String receiverPublicKey, Mosaic[] mosaics) throws Exception {
        Mosaic xpxMosaic = new Mosaic(new MosaicId(new NamespaceId("prx"), "xpx"), Quantity.fromValue((long)1L));
        TransferTransaction transferTransaction = new TransferTransactionBuilder(this.transactionFeeCalculators).sender(new Account(new KeyPair(PrivateKey.fromHexString((String)senderPrivateKey)))).recipient(new Account(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)receiverPublicKey)))).version(2).amount(Amount.fromNem((long)1L)).message(nemMessage).addMosaics(mosaics).addMosaic(xpxMosaic).buildAndSignTransaction();
        NemAnnounceResult announceResult = this.transactionSender.sendTransferTransaction(transferTransaction);
        if (announceResult.getCode() == 1) {
            return announceResult.getTransactionHash().toString();
        }
        throw new AnnounceTransactionFailureException(String.format("Announcement of Nem transaction failed: %s", announceResult.getMessage()));
    }
}

