/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service;

import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.exceptions.MosaicInformationNotFoundException;
import io.proximax.xpx.service.NemAccountApi;
import io.proximax.xpx.service.NemNamespaceAndMosaicsApi;
import java.util.concurrent.ExecutionException;
import org.nem.core.model.FeeUnitAwareTransactionFeeCalculator;
import org.nem.core.model.TransactionFeeCalculator;
import org.nem.core.model.mosaic.Mosaic;
import org.nem.core.model.mosaic.MosaicDefinition;
import org.nem.core.model.mosaic.MosaicFeeInformation;
import org.nem.core.model.mosaic.MosaicFeeInformationLookup;
import org.nem.core.model.primitive.Amount;
import org.nem.core.model.primitive.Supply;

public final class TransactionFeeCalculators {
    private final NemAccountApi accountApi;
    private final NemNamespaceAndMosaicsApi namespaceMosaicApi;
    private TransactionFeeCalculator feeCalculator;
    private TransactionFeeCalculator feeCalculatorMultiSig;

    public TransactionFeeCalculators(NemAccountApi accountApi, NemNamespaceAndMosaicsApi namespaceMosaicApi) {
        this.accountApi = accountApi;
        this.namespaceMosaicApi = namespaceMosaicApi;
    }

    public TransactionFeeCalculator getFeeCalculator() {
        if (this.feeCalculator == null) {
            this.feeCalculator = new FeeUnitAwareTransactionFeeCalculator(Amount.fromMicroNem((long)50000L), this.mosaicInfoLookup());
        }
        return this.feeCalculator;
    }

    public TransactionFeeCalculator getFeeCalculatorMultiSig() {
        if (this.feeCalculatorMultiSig == null) {
            this.feeCalculatorMultiSig = new FeeUnitAwareTransactionFeeCalculator(Amount.fromMicroNem((long)50000L), this.mosaicInfoLookup());
        }
        return this.feeCalculatorMultiSig;
    }

    public TransactionFeeCalculator getFeeCalculator(String senderAddress) {
        return new FeeUnitAwareTransactionFeeCalculator(Amount.fromMicroNem((long)50000L), this.mosaicInfoLookupForSender(senderAddress));
    }

    public TransactionFeeCalculator getFeeCalculatorMultiSig(String senderAddress) {
        return new FeeUnitAwareTransactionFeeCalculator(Amount.fromMicroNem((long)50000L), this.mosaicInfoLookupForSender(senderAddress));
    }

    private MosaicFeeInformationLookup mosaicInfoLookup() {
        return id -> {
            if (id.getName().equals("xpx")) {
                return new MosaicFeeInformation(Supply.fromValue((long)8999999999L), 4);
            }
            int multiplier = Integer.parseInt(id.getName().substring(4));
            int divisibilityChange = multiplier - 1;
            return new MosaicFeeInformation(Supply.fromValue((long)(100000000 * multiplier)), 3 + divisibilityChange);
        };
    }

    private MosaicFeeInformationLookup mosaicInfoLookupForSender(String sender) {
        return id -> {
            String namespaceToLookup = id.getNamespaceId().getRoot().toString();
            String mosaicNameToLookup = id.getName();
            if (namespaceToLookup.equals("proximax") && mosaicNameToLookup.equals("xem")) {
                return null;
            }
            try {
                for (Mosaic mosaic : this.accountApi.getAccountOwnedMosaic(sender)) {
                    String namespace = mosaic.getMosaicId().getNamespaceId().getRoot().toString();
                    String mosaicName = mosaic.getMosaicId().getName();
                    if (!namespace.equals(namespaceToLookup) || !mosaicName.equals(mosaicNameToLookup)) continue;
                    MosaicDefinition mosaicDefinition = this.namespaceMosaicApi.getMosaicInformation(namespace, mosaicName);
                    return new MosaicFeeInformation(Supply.fromValue((long)mosaicDefinition.getProperties().getInitialSupply()), mosaicDefinition.getProperties().getDivisibility());
                }
                throw new MosaicInformationNotFoundException("Mosaic not found on Sender");
            }
            catch (ApiException | InterruptedException | ExecutionException e) {
                throw new MosaicInformationNotFoundException("Exception occured while getting Mosaic Information." + e.getMessage());
            }
        };
    }
}

