/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service;

import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.exceptions.InsufficientAmountException;
import io.proximax.xpx.service.NemAccountApi;
import io.proximax.xpx.service.NemTransactionApi;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.nem.core.model.MultisigSignatureTransaction;
import org.nem.core.model.MultisigTransaction;
import org.nem.core.model.Transaction;
import org.nem.core.model.TransferTransaction;
import org.nem.core.model.ncc.AccountInfo;
import org.nem.core.model.ncc.NemAnnounceResult;
import org.nem.core.model.ncc.RequestAnnounce;
import org.nem.core.model.primitive.Amount;
import org.nem.core.serialization.BinarySerializer;
import org.nem.core.serialization.Deserializer;
import org.nem.core.serialization.SerializableEntity;
import org.pmw.tinylog.Logger;

public class TransactionSender {
    private final NemTransactionApi nemTransactionApi;
    private final NemAccountApi nemAccountApi;

    public TransactionSender(NemTransactionApi nemTransactionApi, NemAccountApi nemAccountApi) {
        this.nemTransactionApi = nemTransactionApi;
        this.nemAccountApi = nemAccountApi;
    }

    public void sendTransaction(Transaction transaction) throws ApiException {
        byte[] data = BinarySerializer.serializeToBytes((SerializableEntity)transaction.asNonVerifiable());
        RequestAnnounce request = new RequestAnnounce(data, transaction.getSignature().getBytes());
        CompletableFuture<Deserializer> future = this.nemTransactionApi.announceTransaction(request);
        try {
            ((CompletableFuture)((CompletableFuture)future.thenAcceptAsync(d -> {
                NemAnnounceResult result = new NemAnnounceResult(d);
                switch (result.getCode()) {
                    case 1: {
                        Logger.info((String)String.format("successfully send xem " + result.getMessage(), new Object[0]));
                        break;
                    }
                    default: {
                        Logger.info((String)String.format("could not send xem " + result.getMessage(), new Object[0]));
                    }
                }
            })).exceptionally(e -> {
                Logger.error((String)("Error on uploading file data: " + e.getMessage()));
                return null;
            })).get();
        }
        catch (Exception e2) {
            Logger.error((String)("Sending/Announcing Transfer Transaction: " + e2.getMessage()));
        }
    }

    public NemAnnounceResult sendTransferTransaction(TransferTransaction transaction) throws ApiException, InterruptedException, ExecutionException, InsufficientAmountException {
        this.checkAddressBalanceAgainstAmount(transaction.getSigner().getAddress().toString(), transaction.getAmount());
        byte[] data = BinarySerializer.serializeToBytes((SerializableEntity)transaction.asNonVerifiable());
        RequestAnnounce request = new RequestAnnounce(data, transaction.getSignature().getBytes());
        CompletableFuture<Deserializer> future = this.nemTransactionApi.announceTransaction(request);
        try {
            Deserializer transDes = future.get();
            return new NemAnnounceResult(transDes);
        }
        catch (Exception e) {
            Logger.error((String)("Sending/Announcing Transfer Transaction: " + e.getMessage()));
            return null;
        }
    }

    public NemAnnounceResult sendTransferTransaction(byte[] data, byte[] signature) throws ApiException {
        RequestAnnounce request = new RequestAnnounce(data, signature);
        CompletableFuture<Deserializer> future = this.nemTransactionApi.announceTransaction(request);
        try {
            Deserializer transDes = future.get();
            return new NemAnnounceResult(transDes);
        }
        catch (Exception e) {
            Logger.error((String)("Error Occured: " + e.getMessage()));
            return null;
        }
    }

    public CompletableFuture<Deserializer> sendFutureTransferTransaction(TransferTransaction transaction) throws ApiException, InterruptedException, ExecutionException, InsufficientAmountException {
        this.checkAddressBalanceAgainstAmount(transaction.getSigner().getAddress().toString(), transaction.getAmount());
        byte[] data = BinarySerializer.serializeToBytes((SerializableEntity)transaction.asNonVerifiable());
        RequestAnnounce request = new RequestAnnounce(data, transaction.getSignature().getBytes());
        return this.nemTransactionApi.announceTransaction(request);
    }

    public NemAnnounceResult sendMultisigTransaction(MultisigTransaction transaction) throws ApiException {
        byte[] data = BinarySerializer.serializeToBytes((SerializableEntity)transaction.asNonVerifiable());
        RequestAnnounce request = new RequestAnnounce(data, transaction.getSignature().getBytes());
        CompletableFuture<Deserializer> future = this.nemTransactionApi.announceTransaction(request);
        try {
            Deserializer transDes = future.get();
            return new NemAnnounceResult(transDes);
        }
        catch (Exception e) {
            Logger.error((String)("Error Occured: " + e.getMessage()));
            return null;
        }
    }

    public CompletableFuture<Deserializer> sendFutureMultiSigTransaction(MultisigTransaction transaction) throws ApiException {
        byte[] data = BinarySerializer.serializeToBytes((SerializableEntity)transaction.asNonVerifiable());
        RequestAnnounce request = new RequestAnnounce(data, transaction.getSignature().getBytes());
        return this.nemTransactionApi.announceTransaction(request);
    }

    public NemAnnounceResult sendMultisigSignatureTransaction(MultisigSignatureTransaction transaction) throws ApiException {
        byte[] data = BinarySerializer.serializeToBytes((SerializableEntity)transaction.asNonVerifiable());
        RequestAnnounce request = new RequestAnnounce(data, transaction.getSignature().getBytes());
        CompletableFuture<Deserializer> future = this.nemTransactionApi.announceTransaction(request);
        try {
            Deserializer transDes = future.get();
            return new NemAnnounceResult(transDes);
        }
        catch (Exception e) {
            Logger.error((String)("Error Occured: " + e.getMessage()));
            return null;
        }
    }

    public CompletableFuture<Deserializer> sendFutureMultisigSignatureTransaction(MultisigSignatureTransaction transaction) throws ApiException {
        byte[] data = BinarySerializer.serializeToBytes((SerializableEntity)transaction.asNonVerifiable());
        RequestAnnounce request = new RequestAnnounce(data, transaction.getSignature().getBytes());
        return this.nemTransactionApi.announceTransaction(request);
    }

    private void checkAddressBalanceAgainstAmount(String address, Amount amount) throws InterruptedException, ExecutionException, ApiException, InsufficientAmountException {
        long transactionAmount;
        long balance = ((AccountInfo)this.nemAccountApi.getAccountByAddress(address).getEntity()).getBalance().getNumNem();
        if (balance < (transactionAmount = amount.getNumNem())) {
            throw new InsufficientAmountException("Insufficient amount for Address: " + address + ". Balance: " + amount.getNumNem() + ". Transaction Amount: " + transactionAmount);
        }
    }
}

