/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service;

import io.proximax.xpx.exceptions.DeletePinnedContentFailureException;
import io.proximax.xpx.exceptions.UploadContentFailureException;
import io.proximax.xpx.service.intf.UploadApi;
import io.proximax.xpx.service.model.buffers.ResourceHashMessage;
import java.nio.ByteBuffer;
import org.apache.commons.codec.binary.Base64;

public class UploadDelegate {
    private UploadApi uploadApi;

    public UploadDelegate(UploadApi uploadApi) {
        this.uploadApi = uploadApi;
    }

    public ResourceHashMessageWrapper uploadBinaryToIpfs(byte[] binaryData, String name, String contentType, String keywords, String metadata) {
        try {
            byte[] resourceHashMessageData = this.uploadApi.uploadBytesBinary(binaryData, name, contentType, keywords, metadata);
            return new ResourceHashMessageWrapper(resourceHashMessageData);
        }
        catch (Exception e) {
            throw new UploadContentFailureException("Failed to upload text to ipfs", e);
        }
    }

    public ResourceHashMessageWrapper uploadTextToIpfs(byte[] textInBytes, String name, String contentType, String encoding, String keywords, String metadata) {
        try {
            byte[] resourceHashMessageData = this.uploadApi.uploadText(textInBytes, name, contentType, encoding, keywords, metadata);
            return new ResourceHashMessageWrapper(resourceHashMessageData);
        }
        catch (Exception e) {
            throw new UploadContentFailureException("Failed to upload text to ipfs", e);
        }
    }

    public ResourceHashMessageWrapper uploadPathToIpfs(String path, String name, String keywords, String metadata) {
        try {
            byte[] resourceHashMessageData = this.uploadApi.uploadPath(path, name, keywords, metadata);
            return new ResourceHashMessageWrapper(resourceHashMessageData);
        }
        catch (Exception e) {
            throw new UploadContentFailureException("Failed to upload text to ipfs", e);
        }
    }

    public String deletePinnedContent(String multihash) {
        try {
            return this.uploadApi.deletePinnedContent(multihash);
        }
        catch (Exception e) {
            throw new DeletePinnedContentFailureException(String.format("Failed to delete pinned content for %s", multihash), e);
        }
    }

    public static class ResourceHashMessageWrapper {
        private final byte[] data;
        private final ResourceHashMessage resourceHashMessage;

        public ResourceHashMessageWrapper(byte[] data) {
            this.data = data;
            this.resourceHashMessage = this.toResourceHashMessage(data);
        }

        public byte[] getData() {
            return this.data;
        }

        public ResourceHashMessage getResourceHashMessage() {
            return this.resourceHashMessage;
        }

        private ResourceHashMessage toResourceHashMessage(byte[] data) {
            return ResourceHashMessage.getRootAsResourceHashMessage(ByteBuffer.wrap(Base64.decodeBase64((byte[])data)));
        }
    }
}

