/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service.common;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.proximax.ApiCallback;
import io.proximax.ApiClient;
import io.proximax.ApiResponse;
import io.proximax.Pair;
import io.proximax.ProgressRequestBody;
import io.proximax.ProgressResponseBody;
import io.proximax.xpx.exceptions.ApiException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class FileAndNamingRouteApi {
    private ApiClient apiClient;

    public FileAndNamingRouteApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call directXipnsGetUsingGETCall(String ipfsHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xipns/{ipfsHash}".replaceAll("\\{ipfsHash\\}", this.apiClient.escapeString(ipfsHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call directXipnsGetUsingGETValidateBeforeCall(String ipfsHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ipfsHash == null) {
            throw new ApiException("Missing the required parameter 'ipfsHash' when calling directXipnsGetUsingGET(Async)");
        }
        Call call = this.directXipnsGetUsingGETCall(ipfsHash, progressListener, progressRequestListener);
        return call;
    }

    public byte[] directXipnsGetUsingGET(String ipfsHash) throws ApiException {
        ApiResponse<byte[]> resp = this.directXipnsGetUsingGETWithHttpInfo(ipfsHash);
        return resp.getData();
    }

    public ApiResponse<byte[]> directXipnsGetUsingGETWithHttpInfo(String ipfsHash) throws ApiException {
        Call call = this.directXipnsGetUsingGETValidateBeforeCall(ipfsHash, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call directXipnsGetUsingGETAsync(String ipfsHash, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.directXipnsGetUsingGETValidateBeforeCall(ipfsHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call directXipnsHeadUsingHEADCall(String ipfsHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xipns/{ipfsHash}".replaceAll("\\{ipfsHash\\}", this.apiClient.escapeString(ipfsHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "HEAD", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call directXipnsHeadUsingHEADValidateBeforeCall(String ipfsHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ipfsHash == null) {
            throw new ApiException("Missing the required parameter 'ipfsHash' when calling directXipnsHeadUsingHEAD(Async)");
        }
        Call call = this.directXipnsHeadUsingHEADCall(ipfsHash, progressListener, progressRequestListener);
        return call;
    }

    public byte[] directXipnsHeadUsingHEAD(String ipfsHash) throws ApiException {
        ApiResponse<byte[]> resp = this.directXipnsHeadUsingHEADWithHttpInfo(ipfsHash);
        return resp.getData();
    }

    public ApiResponse<byte[]> directXipnsHeadUsingHEADWithHttpInfo(String ipfsHash) throws ApiException {
        Call call = this.directXipnsHeadUsingHEADValidateBeforeCall(ipfsHash, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call directXipnsHeadUsingHEADAsync(String ipfsHash, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.directXipnsHeadUsingHEADValidateBeforeCall(ipfsHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call directXpxfsGetUsingGETCall(String nemHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xpxfs/{nemHash}".replaceAll("\\{nemHash\\}", this.apiClient.escapeString(nemHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call directXpxfsGetUsingGETValidateBeforeCall(String nemHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling directXpxfsGetUsingGET(Async)");
        }
        Call call = this.directXpxfsGetUsingGETCall(nemHash, progressListener, progressRequestListener);
        return call;
    }

    public byte[] directXpxfsGetUsingGET(String nemHash) throws ApiException {
        ApiResponse<byte[]> resp = this.directXpxfsGetUsingGETWithHttpInfo(nemHash);
        return resp.getData();
    }

    public ApiResponse<byte[]> directXpxfsGetUsingGETWithHttpInfo(String nemHash) throws ApiException {
        Call call = this.directXpxfsGetUsingGETValidateBeforeCall(nemHash, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call directXpxfsGetUsingGETAsync(String nemHash, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.directXpxfsGetUsingGETValidateBeforeCall(nemHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call directXpxfsHeadUsingHEADCall(String nemHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xpxfs/{nemHash}".replaceAll("\\{nemHash\\}", this.apiClient.escapeString(nemHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "HEAD", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call directXpxfsHeadUsingHEADValidateBeforeCall(String nemHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling directXpxfsHeadUsingHEAD(Async)");
        }
        Call call = this.directXpxfsHeadUsingHEADCall(nemHash, progressListener, progressRequestListener);
        return call;
    }

    public byte[] directXpxfsHeadUsingHEAD(String nemHash) throws ApiException {
        ApiResponse<byte[]> resp = this.directXpxfsHeadUsingHEADWithHttpInfo(nemHash);
        return resp.getData();
    }

    public ApiResponse<byte[]> directXpxfsHeadUsingHEADWithHttpInfo(String nemHash) throws ApiException {
        Call call = this.directXpxfsHeadUsingHEADValidateBeforeCall(nemHash, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call directXpxfsHeadUsingHEADAsync(String nemHash, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.directXpxfsHeadUsingHEADValidateBeforeCall(nemHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call directXpxnsGetUsingGETCall(String nemHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xpxns/{nemHash}".replaceAll("\\{nemHash\\}", this.apiClient.escapeString(nemHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call directXpxnsGetUsingGETValidateBeforeCall(String nemHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling directXpxnsGetUsingGET(Async)");
        }
        Call call = this.directXpxnsGetUsingGETCall(nemHash, progressListener, progressRequestListener);
        return call;
    }

    public byte[] directXpxnsGetUsingGET(String nemHash) throws ApiException {
        ApiResponse<byte[]> resp = this.directXpxnsGetUsingGETWithHttpInfo(nemHash);
        return resp.getData();
    }

    public ApiResponse<byte[]> directXpxnsGetUsingGETWithHttpInfo(String nemHash) throws ApiException {
        Call call = this.directXpxnsGetUsingGETValidateBeforeCall(nemHash, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call directXpxnsGetUsingGETAsync(String nemHash, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.directXpxnsGetUsingGETValidateBeforeCall(nemHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call directXpxnsHeadUsingHEADCall(String nemHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xpxns/{nemHash}".replaceAll("\\{nemHash\\}", this.apiClient.escapeString(nemHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "HEAD", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call directXpxnsHeadUsingHEADValidateBeforeCall(String nemHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling directXpxnsHeadUsingHEAD(Async)");
        }
        Call call = this.directXpxnsHeadUsingHEADCall(nemHash, progressListener, progressRequestListener);
        return call;
    }

    public byte[] directXpxnsHeadUsingHEAD(String nemHash) throws ApiException {
        ApiResponse<byte[]> resp = this.directXpxnsHeadUsingHEADWithHttpInfo(nemHash);
        return resp.getData();
    }

    public ApiResponse<byte[]> directXpxnsHeadUsingHEADWithHttpInfo(String nemHash) throws ApiException {
        Call call = this.directXpxnsHeadUsingHEADValidateBeforeCall(nemHash, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call directXpxnsHeadUsingHEADAsync(String nemHash, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.directXpxnsHeadUsingHEADValidateBeforeCall(nemHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call directxIpfsGetUsingGETCall(String ipfsHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xipfs/{ipfsHash}".replaceAll("\\{ipfsHash\\}", this.apiClient.escapeString(ipfsHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call directxIpfsGetUsingGETValidateBeforeCall(String ipfsHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ipfsHash == null) {
            throw new ApiException("Missing the required parameter 'ipfsHash' when calling directxIpfsGetUsingGET(Async)");
        }
        Call call = this.directxIpfsGetUsingGETCall(ipfsHash, progressListener, progressRequestListener);
        return call;
    }

    public byte[] directxIpfsGetUsingGET(String ipfsHash) throws ApiException {
        ApiResponse<byte[]> resp = this.directxIpfsGetUsingGETWithHttpInfo(ipfsHash);
        return resp.getData();
    }

    public ApiResponse<byte[]> directxIpfsGetUsingGETWithHttpInfo(String ipfsHash) throws ApiException {
        Call call = this.directxIpfsGetUsingGETValidateBeforeCall(ipfsHash, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call directxIpfsGetUsingGETAsync(String ipfsHash, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.directxIpfsGetUsingGETValidateBeforeCall(ipfsHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call directxIpfsHeadUsingHEADCall(String ipfsHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xipfs/{ipfsHash}".replaceAll("\\{ipfsHash\\}", this.apiClient.escapeString(ipfsHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "HEAD", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call directxIpfsHeadUsingHEADValidateBeforeCall(String ipfsHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ipfsHash == null) {
            throw new ApiException("Missing the required parameter 'ipfsHash' when calling directxIpfsHeadUsingHEAD(Async)");
        }
        Call call = this.directxIpfsHeadUsingHEADCall(ipfsHash, progressListener, progressRequestListener);
        return call;
    }

    public byte[] directxIpfsHeadUsingHEAD(String ipfsHash) throws ApiException {
        ApiResponse<byte[]> resp = this.directxIpfsHeadUsingHEADWithHttpInfo(ipfsHash);
        return resp.getData();
    }

    public ApiResponse<byte[]> directxIpfsHeadUsingHEADWithHttpInfo(String ipfsHash) throws ApiException {
        Call call = this.directxIpfsHeadUsingHEADValidateBeforeCall(ipfsHash, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call directxIpfsHeadUsingHEADAsync(String ipfsHash, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.directxIpfsHeadUsingHEADValidateBeforeCall(ipfsHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call loadXpxfsDirectoryGetUsingGETCall(String nemHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xpxfs/{nemHash}/**".replaceAll("\\{nemHash\\}", this.apiClient.escapeString(nemHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call loadXpxfsDirectoryGetUsingGETValidateBeforeCall(String nemHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling loadXpxfsDirectoryGetUsingGET(Async)");
        }
        Call call = this.loadXpxfsDirectoryGetUsingGETCall(nemHash, progressListener, progressRequestListener);
        return call;
    }

    public Object loadXpxfsDirectoryGetUsingGET(String nemHash) throws ApiException {
        ApiResponse<Object> resp = this.loadXpxfsDirectoryGetUsingGETWithHttpInfo(nemHash);
        return resp.getData();
    }

    public ApiResponse<Object> loadXpxfsDirectoryGetUsingGETWithHttpInfo(String nemHash) throws ApiException {
        Call call = this.loadXpxfsDirectoryGetUsingGETValidateBeforeCall(nemHash, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call loadXpxfsDirectoryGetUsingGETAsync(String nemHash, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.loadXpxfsDirectoryGetUsingGETValidateBeforeCall(nemHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call loadXpxfsDirectoryHeadUsingHEADCall(String nemHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xpxfs/{nemHash}/**".replaceAll("\\{nemHash\\}", this.apiClient.escapeString(nemHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "HEAD", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call loadXpxfsDirectoryHeadUsingHEADValidateBeforeCall(String nemHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling loadXpxfsDirectoryHeadUsingHEAD(Async)");
        }
        Call call = this.loadXpxfsDirectoryHeadUsingHEADCall(nemHash, progressListener, progressRequestListener);
        return call;
    }

    public Object loadXpxfsDirectoryHeadUsingHEAD(String nemHash) throws ApiException {
        ApiResponse<Object> resp = this.loadXpxfsDirectoryHeadUsingHEADWithHttpInfo(nemHash);
        return resp.getData();
    }

    public ApiResponse<Object> loadXpxfsDirectoryHeadUsingHEADWithHttpInfo(String nemHash) throws ApiException {
        Call call = this.loadXpxfsDirectoryHeadUsingHEADValidateBeforeCall(nemHash, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call loadXpxfsDirectoryHeadUsingHEADAsync(String nemHash, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.loadXpxfsDirectoryHeadUsingHEADValidateBeforeCall(nemHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call loadXpxnsDirectoryGetUsingGETCall(String nemHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xpxns/{nemHash}/**".replaceAll("\\{nemHash\\}", this.apiClient.escapeString(nemHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call loadXpxnsDirectoryGetUsingGETValidateBeforeCall(String nemHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling loadXpxnsDirectoryGetUsingGET(Async)");
        }
        Call call = this.loadXpxnsDirectoryGetUsingGETCall(nemHash, progressListener, progressRequestListener);
        return call;
    }

    public Object loadXpxnsDirectoryGetUsingGET(String nemHash) throws ApiException {
        ApiResponse<Object> resp = this.loadXpxnsDirectoryGetUsingGETWithHttpInfo(nemHash);
        return resp.getData();
    }

    public ApiResponse<Object> loadXpxnsDirectoryGetUsingGETWithHttpInfo(String nemHash) throws ApiException {
        Call call = this.loadXpxnsDirectoryGetUsingGETValidateBeforeCall(nemHash, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call loadXpxnsDirectoryGetUsingGETAsync(String nemHash, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.loadXpxnsDirectoryGetUsingGETValidateBeforeCall(nemHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call loadXpxnsDirectoryHeadUsingHEADCall(String nemHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xpxns/{nemHash}/**".replaceAll("\\{nemHash\\}", this.apiClient.escapeString(nemHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "HEAD", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call loadXpxnsDirectoryHeadUsingHEADValidateBeforeCall(String nemHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling loadXpxnsDirectoryHeadUsingHEAD(Async)");
        }
        Call call = this.loadXpxnsDirectoryHeadUsingHEADCall(nemHash, progressListener, progressRequestListener);
        return call;
    }

    public Object loadXpxnsDirectoryHeadUsingHEAD(String nemHash) throws ApiException {
        ApiResponse<Object> resp = this.loadXpxnsDirectoryHeadUsingHEADWithHttpInfo(nemHash);
        return resp.getData();
    }

    public ApiResponse<Object> loadXpxnsDirectoryHeadUsingHEADWithHttpInfo(String nemHash) throws ApiException {
        Call call = this.loadXpxnsDirectoryHeadUsingHEADValidateBeforeCall(nemHash, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call loadXpxnsDirectoryHeadUsingHEADAsync(String nemHash, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.loadXpxnsDirectoryHeadUsingHEADValidateBeforeCall(nemHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

