/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service.common;

import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.model.ResourceHashMessageJsonEntity;
import io.proximax.xpx.service.NemTransactionApi;
import io.proximax.xpx.service.model.buffers.ResourceHashMessage;
import io.proximax.xpx.utils.JsonUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.codec.binary.Base64;
import org.nem.core.crypto.KeyPair;
import org.nem.core.crypto.PrivateKey;
import org.nem.core.crypto.PublicKey;
import org.nem.core.messages.SecureMessage;
import org.nem.core.model.Account;
import org.nem.core.model.Address;
import org.nem.core.model.Transaction;
import org.nem.core.model.TransferTransaction;
import org.nem.core.model.mosaic.Mosaic;
import org.nem.core.model.ncc.TransactionMetaData;
import org.nem.core.model.ncc.TransactionMetaDataPair;

public abstract class PrivateSearchApi {
    private final NemTransactionApi nemTransactionApi;

    public PrivateSearchApi(NemTransactionApi nemTransactionApi) {
        this.nemTransactionApi = nemTransactionApi;
    }

    public List<ResourceHashMessageJsonEntity> searchTransactionWithName(String xPvKey, String xPubkey, String name) throws ApiException, InterruptedException, ExecutionException {
        ArrayList<ResourceHashMessageJsonEntity> encryptedMessage = new ArrayList<ResourceHashMessageJsonEntity>();
        encryptedMessage.addAll(this.getNextForNameSearch(xPvKey, xPubkey, name, ""));
        return encryptedMessage;
    }

    public List<ResourceHashMessageJsonEntity> searchTransactionWithMetadataKeyValuePair(String xPvKey, String xPubkey, String key, String value) throws ApiException, InterruptedException, ExecutionException {
        ArrayList<ResourceHashMessageJsonEntity> encryptedMessage = new ArrayList<ResourceHashMessageJsonEntity>();
        encryptedMessage.addAll(this.getNextForMetadataSearch(xPvKey, xPubkey, key, value, ""));
        return encryptedMessage;
    }

    public List<ResourceHashMessageJsonEntity> searchTransactionWithKeyword(String xPvKey, String xPubkey, String keywords) throws ApiException, InterruptedException, ExecutionException {
        ArrayList<ResourceHashMessageJsonEntity> encryptedMessage = new ArrayList<ResourceHashMessageJsonEntity>();
        encryptedMessage.addAll(this.getNextForKeywordSearch(xPvKey, xPubkey, keywords, ""));
        return encryptedMessage;
    }

    private List<ResourceHashMessageJsonEntity> getNextForNameSearch(String xPvKey, String xPubkey, String name, String hash) throws ApiException, InterruptedException, ExecutionException {
        PrivateKey pvKey = PrivateKey.fromHexString((String)xPvKey);
        KeyPair keyPair = new KeyPair(pvKey);
        String privateKeyAddress = Address.fromPublicKey((PublicKey)keyPair.getPublicKey()).toString();
        List<TransactionMetaDataPair> listOfTransactionMetadataPair = null;
        listOfTransactionMetadataPair = hash.equals("") ? this.nemTransactionApi.getAllTransactions(privateKeyAddress) : this.nemTransactionApi.getAllTransactions(privateKeyAddress, hash);
        ArrayList<ResourceHashMessageJsonEntity> encryptedMessage = new ArrayList<ResourceHashMessageJsonEntity>();
        String currentHash = "";
        for (TransactionMetaDataPair tmp : listOfTransactionMetadataPair) {
            if (!(tmp.getEntity() instanceof TransferTransaction)) continue;
            currentHash = ((TransactionMetaData)tmp.getMetaData()).getHash().toString();
            TransferTransaction transferTransaction = (TransferTransaction)tmp.getEntity();
            if (!this.checkIfTxnHaveXPXMosaic((Transaction)transferTransaction)) continue;
            boolean found = false;
            try {
                ResourceHashMessage resourceMessage;
                if (transferTransaction.getMessage().getType() == 1) {
                    ResourceHashMessage resourceMessage2 = ResourceHashMessage.getRootAsResourceHashMessage(ByteBuffer.wrap(Base64.decodeBase64((byte[])transferTransaction.getMessage().getDecodedPayload())));
                    if (!resourceMessage2.name().toLowerCase().contains(name.toLowerCase())) continue;
                    encryptedMessage.add(this.toEntity(currentHash, resourceMessage2));
                    continue;
                }
                if (transferTransaction.getMessage().getType() != 2) continue;
                SecureMessage secureMessage = null;
                if (transferTransaction.getSigner().getAddress().getEncoded().equals(privateKeyAddress)) {
                    secureMessage = SecureMessage.fromEncodedPayload((Account)new Account(new KeyPair(PrivateKey.fromHexString((String)xPvKey))), (Account)new Account(new KeyPair(PublicKey.fromHexString((String)xPubkey))), (byte[])transferTransaction.getMessage().getEncodedPayload());
                } else if (transferTransaction.getRecipient().getAddress().getEncoded().equals(privateKeyAddress)) {
                    secureMessage = SecureMessage.fromEncodedPayload((Account)new Account(new KeyPair(PublicKey.fromHexString((String)xPubkey))), (Account)new Account(new KeyPair(PrivateKey.fromHexString((String)xPvKey))), (byte[])transferTransaction.getMessage().getEncodedPayload());
                }
                if (!(resourceMessage = ResourceHashMessage.getRootAsResourceHashMessage(ByteBuffer.wrap(Base64.decodeBase64((byte[])secureMessage.getDecodedPayload())))).name().toLowerCase().contains(name.toLowerCase())) continue;
                encryptedMessage.add(this.toEntity(currentHash, resourceMessage));
            }
            catch (Exception e) {}
        }
        if (!currentHash.equals("")) {
            encryptedMessage.addAll(this.getNextForNameSearch(xPvKey, xPubkey, name, currentHash));
        }
        return encryptedMessage;
    }

    private List<ResourceHashMessageJsonEntity> getNextForKeywordSearch(String xPvKey, String xPubkey, String keywords, String hash) throws ApiException, InterruptedException, ExecutionException {
        PrivateKey pvKey = PrivateKey.fromHexString((String)xPvKey);
        KeyPair keyPair = new KeyPair(pvKey);
        String privateKeyAddress = Address.fromPublicKey((PublicKey)keyPair.getPublicKey()).toString();
        List<TransactionMetaDataPair> listOfTransactionMetadataPair = null;
        listOfTransactionMetadataPair = hash.equals("") ? this.nemTransactionApi.getAllTransactions(privateKeyAddress) : this.nemTransactionApi.getAllTransactions(privateKeyAddress, hash);
        ArrayList<ResourceHashMessageJsonEntity> encryptedMessage = new ArrayList<ResourceHashMessageJsonEntity>();
        String currentHash = "";
        for (TransactionMetaDataPair tmp : listOfTransactionMetadataPair) {
            if (!(tmp.getEntity() instanceof TransferTransaction)) continue;
            currentHash = ((TransactionMetaData)tmp.getMetaData()).getHash().toString();
            TransferTransaction transferTransaction = (TransferTransaction)tmp.getEntity();
            if (!this.checkIfTxnHaveXPXMosaic((Transaction)transferTransaction)) continue;
            boolean found = false;
            try {
                String[] commaSeparatedkeywordsSplit;
                if (transferTransaction.getMessage().getType() == 1) {
                    String[] commaSeparatedkeywordsSplit2;
                    ResourceHashMessage resourceMessage = ResourceHashMessage.getRootAsResourceHashMessage(ByteBuffer.wrap(Base64.decodeBase64((byte[])transferTransaction.getMessage().getDecodedPayload())));
                    for (String keyword : commaSeparatedkeywordsSplit2 = keywords.split(",")) {
                        if (!resourceMessage.keywords().contains(keyword)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    encryptedMessage.add(this.toEntity(currentHash, resourceMessage));
                    continue;
                }
                if (transferTransaction.getMessage().getType() != 2) continue;
                SecureMessage secureMessage = null;
                if (transferTransaction.getSigner().getAddress().getEncoded().equals(privateKeyAddress)) {
                    secureMessage = SecureMessage.fromEncodedPayload((Account)new Account(new KeyPair(PrivateKey.fromHexString((String)xPvKey))), (Account)new Account(new KeyPair(PublicKey.fromHexString((String)xPubkey))), (byte[])transferTransaction.getMessage().getEncodedPayload());
                } else if (transferTransaction.getRecipient().getAddress().getEncoded().equals(privateKeyAddress)) {
                    secureMessage = SecureMessage.fromEncodedPayload((Account)new Account(new KeyPair(PublicKey.fromHexString((String)xPubkey))), (Account)new Account(new KeyPair(PrivateKey.fromHexString((String)xPvKey))), (byte[])transferTransaction.getMessage().getEncodedPayload());
                }
                ResourceHashMessage resourceMessage = ResourceHashMessage.getRootAsResourceHashMessage(ByteBuffer.wrap(Base64.decodeBase64((byte[])secureMessage.getDecodedPayload())));
                for (String keyword : commaSeparatedkeywordsSplit = keywords.split(",")) {
                    if (!resourceMessage.keywords().contains(keyword)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                encryptedMessage.add(this.toEntity(currentHash, resourceMessage));
            }
            catch (Exception e) {}
        }
        if (!currentHash.equals("")) {
            encryptedMessage.addAll(this.getNextForKeywordSearch(xPvKey, xPubkey, keywords, currentHash));
        }
        return encryptedMessage;
    }

    private List<ResourceHashMessageJsonEntity> getNextForMetadataSearch(String xPvKey, String xPubkey, String key, String value, String hash) throws ApiException, InterruptedException, ExecutionException {
        PrivateKey pvKey = PrivateKey.fromHexString((String)xPvKey);
        KeyPair keyPair = new KeyPair(pvKey);
        String privateKeyAddress = Address.fromPublicKey((PublicKey)keyPair.getPublicKey()).toString();
        List<TransactionMetaDataPair> listOfTransactionMetadataPair = null;
        listOfTransactionMetadataPair = hash.equals("") ? this.nemTransactionApi.getAllTransactions(privateKeyAddress) : this.nemTransactionApi.getAllTransactions(privateKeyAddress, hash);
        ArrayList<ResourceHashMessageJsonEntity> encryptedMessage = new ArrayList<ResourceHashMessageJsonEntity>();
        String currentHash = "";
        for (TransactionMetaDataPair tmp : listOfTransactionMetadataPair) {
            if (!(tmp.getEntity() instanceof TransferTransaction)) continue;
            currentHash = ((TransactionMetaData)tmp.getMetaData()).getHash().toString();
            TransferTransaction transferTransaction = (TransferTransaction)tmp.getEntity();
            if (!this.checkIfTxnHaveXPXMosaic((Transaction)transferTransaction)) continue;
            boolean found = false;
            try {
                Map jsonToMap;
                ResourceHashMessage resourceMessage;
                if (transferTransaction.getMessage().getType() == 1) {
                    Map jsonToMap2;
                    ResourceHashMessage resourceMessage2 = ResourceHashMessage.getRootAsResourceHashMessage(ByteBuffer.wrap(Base64.decodeBase64((byte[])transferTransaction.getMessage().getDecodedPayload())));
                    if (resourceMessage2.metaData() == null || !(jsonToMap2 = JsonUtils.fromJson(resourceMessage2.metaData(), Map.class)).containsKey(key) || !((String)jsonToMap2.get(key)).equals(value)) continue;
                    encryptedMessage.add(this.toEntity(currentHash, resourceMessage2));
                    continue;
                }
                if (transferTransaction.getMessage().getType() != 2) continue;
                SecureMessage secureMessage = null;
                if (transferTransaction.getSigner().getAddress().getEncoded().equals(privateKeyAddress)) {
                    secureMessage = SecureMessage.fromEncodedPayload((Account)new Account(new KeyPair(PrivateKey.fromHexString((String)xPvKey))), (Account)new Account(new KeyPair(PublicKey.fromHexString((String)xPubkey))), (byte[])transferTransaction.getMessage().getEncodedPayload());
                } else if (transferTransaction.getRecipient().getAddress().getEncoded().equals(privateKeyAddress)) {
                    secureMessage = SecureMessage.fromEncodedPayload((Account)new Account(new KeyPair(PublicKey.fromHexString((String)xPubkey))), (Account)new Account(new KeyPair(PrivateKey.fromHexString((String)xPvKey))), (byte[])transferTransaction.getMessage().getEncodedPayload());
                }
                if ((resourceMessage = ResourceHashMessage.getRootAsResourceHashMessage(ByteBuffer.wrap(Base64.decodeBase64((byte[])secureMessage.getDecodedPayload())))).metaData() == null || !(jsonToMap = JsonUtils.fromJson(resourceMessage.metaData(), Map.class)).containsKey(key) || !((String)jsonToMap.get(key)).equals(value)) continue;
                encryptedMessage.add(this.toEntity(currentHash, resourceMessage));
            }
            catch (Exception e) {}
        }
        if (!currentHash.equals("")) {
            encryptedMessage.addAll(this.getNextForMetadataSearch(xPvKey, xPubkey, key, value, currentHash));
        }
        return encryptedMessage;
    }

    protected ResourceHashMessageJsonEntity toEntity(String nemHash, ResourceHashMessage resourceMessage) {
        ResourceHashMessageJsonEntity resourceHashMessageJsonEntity = new ResourceHashMessageJsonEntity();
        resourceHashMessageJsonEntity.setDigest(resourceMessage.digest());
        resourceHashMessageJsonEntity.setHash(resourceMessage.hash());
        resourceHashMessageJsonEntity.setKeywords(resourceMessage.keywords());
        resourceHashMessageJsonEntity.setMetaData(resourceMessage.metaData());
        resourceHashMessageJsonEntity.setName(resourceMessage.name());
        resourceHashMessageJsonEntity.setTimestamp(resourceMessage.timestamp());
        resourceHashMessageJsonEntity.setType(resourceMessage.type());
        resourceHashMessageJsonEntity.setNemHash(nemHash);
        return resourceHashMessageJsonEntity;
    }

    protected boolean checkIfTxnHaveXPXMosaic(Transaction transaction) {
        if (transaction instanceof TransferTransaction) {
            for (Mosaic mosaic : ((TransferTransaction)transaction).getMosaics()) {
                if (!mosaic.getMosaicId().getNamespaceId().getRoot().toString().equals("prx") || !mosaic.getMosaicId().getName().equals("xpx")) continue;
                return true;
            }
        }
        return false;
    }
}

