/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service.local;

import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.model.AccountMetaDataPair;
import io.proximax.xpx.service.NemTransactionApi;
import io.proximax.xpx.service.intf.AccountApi;
import io.proximax.xpx.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.nem.core.crypto.PublicKey;
import org.nem.core.model.Address;
import org.nem.core.model.Transaction;
import org.nem.core.model.TransferTransaction;
import org.nem.core.model.mosaic.Mosaic;
import org.nem.core.model.ncc.TransactionMetaDataPair;
import org.nem.core.serialization.JsonSerializer;
import org.nem.core.serialization.SerializableEntity;

public class LocalAccountApi
implements AccountApi {
    private final NemTransactionApi nemTransactionApi;

    public LocalAccountApi(NemTransactionApi nemTransactionApi) {
        this.nemTransactionApi = nemTransactionApi;
    }

    @Override
    public String getAllIncomingNemAddressTransactionsUsingGET(String publicKey) throws ApiException, InterruptedException, ExecutionException {
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getIncomingTransactions(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)publicKey)).getEncoded());
        ArrayList<String> transactionString = new ArrayList<String>();
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            if (!this.checkIfTxnHaveXPXMosaic((Transaction)metaDataPair.getEntity())) continue;
            transactionString.add(JsonSerializer.serializeToJson((SerializableEntity)metaDataPair.getEntity()).toJSONString());
        }
        return JsonUtils.toJson(transactionString);
    }

    @Override
    public String getAllNemAddressTransactionsUsingGET(String publicKey) throws ApiException, InterruptedException, ExecutionException {
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getAllTransactions(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)publicKey)).getEncoded());
        ArrayList<String> transactionString = new ArrayList<String>();
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            if (!this.checkIfTxnHaveXPXMosaic((Transaction)metaDataPair.getEntity())) continue;
            transactionString.add(JsonSerializer.serializeToJson((SerializableEntity)metaDataPair.getEntity()).toJSONString());
        }
        return JsonUtils.toJson(transactionString);
    }

    @Override
    public String getAllNemAddressTransactionsWithPageSizeUsingGET(String publicKey, String pageSize) throws ApiException, InterruptedException, ExecutionException {
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getAllTransactionsWithPageSize(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)publicKey)).getEncoded(), pageSize);
        ArrayList<String> transactionString = new ArrayList<String>();
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            if (!this.checkIfTxnHaveXPXMosaic((Transaction)metaDataPair.getEntity())) continue;
            transactionString.add(JsonSerializer.serializeToJson((SerializableEntity)metaDataPair.getEntity()).toJSONString());
        }
        return JsonUtils.toJson(transactionString);
    }

    @Override
    public String getAllOutgoingNemAddressTransactionsUsingGET(String publicKey) throws ApiException, InterruptedException, ExecutionException {
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getOutgoingTransactions(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)publicKey)).getEncoded());
        ArrayList<String> transactionString = new ArrayList<String>();
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            if (!this.checkIfTxnHaveXPXMosaic((Transaction)metaDataPair.getEntity())) continue;
            transactionString.add(JsonSerializer.serializeToJson((SerializableEntity)metaDataPair.getEntity()).toJSONString());
        }
        return JsonUtils.toJson(transactionString);
    }

    @Override
    public String getAllUnconfirmedNemAddressTransactionsUsingGET(String publicKey) throws ApiException, InterruptedException, ExecutionException {
        List<TransactionMetaDataPair> listOfTxnMetaDataPair = this.nemTransactionApi.getUnconfirmedTransactions(Address.fromPublicKey((PublicKey)PublicKey.fromHexString((String)publicKey)).getEncoded());
        ArrayList<String> transactionString = new ArrayList<String>();
        for (TransactionMetaDataPair metaDataPair : listOfTxnMetaDataPair) {
            transactionString.add(JsonSerializer.serializeToJson((SerializableEntity)metaDataPair.getEntity()).toJSONString());
        }
        return JsonUtils.toJson(transactionString);
    }

    @Override
    public AccountMetaDataPair getNemAddressDetailsUsingGET(String publicKey) throws ApiException {
        return null;
    }

    protected boolean checkIfTxnHaveXPXMosaic(Transaction transaction) {
        if (transaction instanceof TransferTransaction) {
            for (Mosaic mosaic : ((TransferTransaction)transaction).getMosaics()) {
                if (!mosaic.getMosaicId().getNamespaceId().getRoot().toString().equals("prx") || !mosaic.getMosaicId().getName().equals("xpx")) continue;
                return true;
            }
        }
        return false;
    }
}

