/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service.local;

import io.ipfs.api.IPFS;
import io.ipfs.api.NamedStreamable;
import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.model.DataHashByteArrayEntity;
import io.proximax.xpx.model.PublishResult;
import io.proximax.xpx.service.intf.DataHashApi;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class LocalDataHashApi
implements DataHashApi {
    private final IPFS proximaxIfpsConnection;

    public LocalDataHashApi(IPFS proximaxIfpsConnection) {
        this.proximaxIfpsConnection = proximaxIfpsConnection;
    }

    @Override
    public String generateHashForDataOnlyUsingPOST(byte[] data) throws ApiException, IOException, NoSuchAlgorithmException {
        DataHashByteArrayEntity dataHashByteArrayEntity = new DataHashByteArrayEntity();
        dataHashByteArrayEntity.setFile(data);
        dataHashByteArrayEntity.setName(Math.abs(System.currentTimeMillis()) + "");
        PublishResult spfsBlockResult = this.getBinaryHashOnly(dataHashByteArrayEntity.getName(), dataHashByteArrayEntity.getFile());
        String multiHashString = spfsBlockResult.getMerkleNode().get((int)0).hash.toBase58();
        return multiHashString;
    }

    private PublishResult getBinaryHashOnly(String name, byte[] binary) throws IOException, ApiException {
        PublishResult result = null;
        result = new PublishResult();
        NamedStreamable.ByteArrayWrapper byteArrayWrapper = new NamedStreamable.ByteArrayWrapper(name, binary);
        List node = this.proximaxIfpsConnection.add((NamedStreamable)byteArrayWrapper, false, true);
        result.setMerkleNode(node);
        return result;
    }
}

