/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service.local;

import io.ipfs.api.IPFS;
import io.ipfs.multihash.Multihash;
import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.exceptions.MessageDigestNotMatchException;
import io.proximax.xpx.service.NemTransactionApi;
import io.proximax.xpx.service.intf.DownloadApi;
import io.proximax.xpx.service.model.buffers.ResourceHashMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.nem.core.model.TransferTransaction;
import org.nem.core.model.ncc.TransactionMetaDataPair;

public class LocalDownloadApi
implements DownloadApi {
    private final NemTransactionApi nemTransactionApi;
    private final IPFS proximaxIfpsConnection;

    public LocalDownloadApi(NemTransactionApi nemTransactionApi, IPFS proximaxIfpsConnection) {
        this.nemTransactionApi = nemTransactionApi;
        this.proximaxIfpsConnection = proximaxIfpsConnection;
    }

    @Override
    public byte[] downloadUsingDataHashUsingGET(String hash) throws ApiException, IOException {
        return this.proximaxIfpsConnection.cat(Multihash.fromBase58((String)hash));
    }

    @Override
    public byte[] downloadTextUsingGET(String nemHash, String transferMode) throws ApiException, IOException, InterruptedException, ExecutionException {
        TransactionMetaDataPair transactionMetaDataPair = this.nemTransactionApi.getTransaction(nemHash);
        TransferTransaction transfer = (TransferTransaction)transactionMetaDataPair.getEntity();
        ResourceHashMessage resourceMessage = ResourceHashMessage.getRootAsResourceHashMessage(ByteBuffer.wrap(Base64.decodeBase64((byte[])transfer.getMessage().getEncodedPayload())));
        return this.proximaxIfpsConnection.cat(Multihash.fromBase58((String)resourceMessage.hash()));
    }

    @Override
    public byte[] downloadBinaryUsingGET(String nemHash, String transferMode) throws ApiException, IOException, InterruptedException, ExecutionException {
        TransactionMetaDataPair transactionMetaDataPair = this.nemTransactionApi.getTransaction(nemHash);
        TransferTransaction transfer = (TransferTransaction)transactionMetaDataPair.getEntity();
        ResourceHashMessage resourceMessage = ResourceHashMessage.getRootAsResourceHashMessage(ByteBuffer.wrap(Base64.decodeBase64((byte[])transfer.getMessage().getEncodedPayload())));
        return this.proximaxIfpsConnection.cat(Multihash.fromBase58((String)resourceMessage.hash()));
    }

    @Override
    public byte[] downloadFileUsingGET(String nemHash, String transferMode) throws ApiException, IOException, InterruptedException, ExecutionException {
        TransactionMetaDataPair transactionMetaDataPair = this.nemTransactionApi.getTransaction(nemHash);
        TransferTransaction transfer = (TransferTransaction)transactionMetaDataPair.getEntity();
        ResourceHashMessage resourceMessage = ResourceHashMessage.getRootAsResourceHashMessage(ByteBuffer.wrap(Base64.decodeBase64((byte[])transfer.getMessage().getEncodedPayload())));
        return this.proximaxIfpsConnection.cat(Multihash.fromBase58((String)resourceMessage.hash()));
    }

    public byte[] loadResource(ResourceHashMessage resourceMessage) throws IOException, ApiException {
        return this.proximaxIfpsConnection.cat(Multihash.fromBase58((String)resourceMessage.hash()));
    }

    private void validateDigest(byte[] binaryData, String digest) throws NoSuchAlgorithmException, MessageDigestNotMatchException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String binaryDigest = new String(Hex.encode((byte[])messageDigest.digest(binaryData)));
        if (!binaryDigest.equals(digest)) {
            throw new MessageDigestNotMatchException("Message Digest Validation Failed. Resource requested seems to be corrupted.");
        }
    }
}

