/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service.local;

import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.model.ResourceHashMessageJsonEntity;
import io.proximax.xpx.service.NemTransactionApi;
import io.proximax.xpx.service.common.PrivateSearchApi;
import io.proximax.xpx.service.intf.SearchApi;
import io.proximax.xpx.service.model.buffers.ResourceHashMessage;
import io.proximax.xpx.utils.JsonUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.codec.binary.Base64;
import org.nem.core.crypto.PublicKey;
import org.nem.core.model.Address;
import org.nem.core.model.Transaction;
import org.nem.core.model.TransferTransaction;
import org.nem.core.model.ncc.TransactionMetaData;
import org.nem.core.model.ncc.TransactionMetaDataPair;
import org.pmw.tinylog.Logger;

public class LocalSearchApi
extends PrivateSearchApi
implements SearchApi {
    private final NemTransactionApi nemTransactionApi;

    public LocalSearchApi(NemTransactionApi nemTransactionApi) {
        super(nemTransactionApi);
        this.nemTransactionApi = nemTransactionApi;
    }

    @Override
    public List<ResourceHashMessageJsonEntity> searchTransactionWithKeywordUsingGET(String xPubkey, String keywords) throws ApiException, InterruptedException, ExecutionException {
        PublicKey pbKey = PublicKey.fromHexString((String)xPubkey);
        Address address = Address.fromPublicKey((PublicKey)pbKey);
        String publicKeyAddress = address.toString();
        List<TransactionMetaDataPair> listOfTransactionMetadataPair = this.nemTransactionApi.getAllTransactions(publicKeyAddress);
        ArrayList<ResourceHashMessageJsonEntity> encryptedMessage = new ArrayList<ResourceHashMessageJsonEntity>();
        String currentHash = "";
        for (TransactionMetaDataPair tmp : listOfTransactionMetadataPair) {
            TransferTransaction transferTransaction;
            currentHash = ((TransactionMetaData)tmp.getMetaData()).getHash().toString();
            if (!(tmp.getEntity() instanceof TransferTransaction) || !this.checkIfTxnHaveXPXMosaic((Transaction)(transferTransaction = (TransferTransaction)tmp.getEntity()))) continue;
            try {
                String[] commaSeparatedkeywordsSplit;
                if (transferTransaction.getMessage().getType() != 1) continue;
                boolean found = false;
                ResourceHashMessage resourceMessage = ResourceHashMessage.getRootAsResourceHashMessage(ByteBuffer.wrap(Base64.decodeBase64((byte[])transferTransaction.getMessage().getDecodedPayload())));
                for (String keyword : commaSeparatedkeywordsSplit = keywords.split(",")) {
                    if (!resourceMessage.keywords().contains(keyword)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                encryptedMessage.add(this.toEntity(currentHash, resourceMessage));
            }
            catch (Exception e) {}
        }
        return encryptedMessage;
    }

    @Override
    public List<ResourceHashMessageJsonEntity> searchTransactionWithMetadataUsingGET(String xPubkey, String key, String value) throws InterruptedException, ExecutionException, ApiException {
        PublicKey pbKey = PublicKey.fromHexString((String)xPubkey);
        Address address = Address.fromPublicKey((PublicKey)pbKey);
        String publicKeyAddress = address.toString();
        List<TransactionMetaDataPair> listOfTransactionMetadataPair = this.nemTransactionApi.getAllTransactions(publicKeyAddress);
        ArrayList<ResourceHashMessageJsonEntity> encryptedMessage = new ArrayList<ResourceHashMessageJsonEntity>();
        for (TransactionMetaDataPair tmp : listOfTransactionMetadataPair) {
            String currentHash = "";
            if (!(tmp.getEntity() instanceof TransferTransaction)) continue;
            TransferTransaction transferTransaction = (TransferTransaction)tmp.getEntity();
            currentHash = ((TransactionMetaData)tmp.getMetaData()).getHash().toString();
            if (!this.checkIfTxnHaveXPXMosaic((Transaction)transferTransaction)) continue;
            try {
                Map jsonToMap;
                if (transferTransaction.getMessage().getType() != 1) continue;
                boolean found = false;
                ResourceHashMessage resourceMessage = ResourceHashMessage.getRootAsResourceHashMessage(ByteBuffer.wrap(Base64.decodeBase64((byte[])transferTransaction.getMessage().getDecodedPayload())));
                if (resourceMessage.metaData() != null && (jsonToMap = JsonUtils.fromJson(resourceMessage.metaData(), Map.class)).containsKey(key) && ((String)jsonToMap.get(key)).equals(value)) {
                    found = true;
                }
                if (!found) continue;
                encryptedMessage.add(this.toEntity(currentHash, resourceMessage));
            }
            catch (Exception e) {
                Logger.info((String)("Error on decoding NEM Transaction Message." + e.getMessage()));
            }
        }
        return encryptedMessage;
    }

    @Override
    public List<ResourceHashMessageJsonEntity> searchTransactionWithMetadataKeyValuePair(String xPvKey, String xPubkey, String key, String value) throws ApiException, InterruptedException, ExecutionException {
        return super.searchTransactionWithMetadataKeyValuePair(xPvKey, xPubkey, key, value);
    }

    @Override
    public List<ResourceHashMessageJsonEntity> searchTransactionWithKeywordUsingGET(String xPvKey, String xPubkey, String keywords) throws ApiException, InterruptedException, ExecutionException {
        return super.searchTransactionWithKeyword(xPvKey, xPubkey, keywords);
    }

    @Override
    public List<ResourceHashMessageJsonEntity> searchTransactionWithNameUsingGET(String xPvKey, String xPubkey, String name) throws ApiException, InterruptedException, ExecutionException {
        return super.searchTransactionWithKeyword(xPvKey, xPubkey, name);
    }
}

