/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service.local;

import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.model.RequestAnnounceDataSignature;
import io.proximax.xpx.service.NemTransactionApi;
import io.proximax.xpx.service.intf.TransactionAndAnnounceApi;
import java.util.concurrent.ExecutionException;
import org.nem.core.model.TransferTransaction;
import org.nem.core.model.ncc.NemAnnounceResult;
import org.nem.core.model.ncc.TransactionMetaDataPair;
import org.nem.core.serialization.JsonSerializer;
import org.nem.core.serialization.SerializableEntity;
import org.nem.core.utils.HexEncoder;

public class LocalTransactionAndAnnounceApi
implements TransactionAndAnnounceApi {
    private final NemTransactionApi nemTransactionApi;

    public LocalTransactionAndAnnounceApi(NemTransactionApi nemTransactionApi) {
        this.nemTransactionApi = nemTransactionApi;
    }

    @Override
    public String announceRequestPublishDataSignatureUsingPOST(RequestAnnounceDataSignature requestAnnounceDataSignature) throws ApiException, InterruptedException, ExecutionException {
        NemAnnounceResult announceResult = this.nemTransactionApi.sendTransferTransaction(HexEncoder.getBytes((String)requestAnnounceDataSignature.getData()), HexEncoder.getBytes((String)requestAnnounceDataSignature.getSignature()));
        TransactionMetaDataPair transactionMpair = this.nemTransactionApi.getTransaction(announceResult.getTransactionHash().toString());
        TransferTransaction transferTransaction = (TransferTransaction)transactionMpair.getEntity();
        return JsonSerializer.serializeToJson((SerializableEntity)transferTransaction).toJSONString();
    }

    @Override
    public String getXPXTransactionUsingGET(String nemHash) throws ApiException, InterruptedException, ExecutionException {
        return JsonSerializer.serializeToJson((SerializableEntity)this.nemTransactionApi.getTransaction(nemHash)).toJSONString();
    }
}

